/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.wires;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import pl.asie.charset.api.wires.IRedstoneEmitter;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.api.wires.WireType;
import pl.asie.charset.lib.capability.Capabilities;
import pl.asie.charset.lib.utils.redstone.RedstoneUtils;
import pl.asie.charset.lib.wires.Wire;
import pl.asie.charset.lib.wires.WireUtils;
import pl.asie.simplelogic.wires.logic.PartWireSignalBase;

public final class LogicWireUtils {
    private static final Set<Block> WIRE_PLACEABLE = new HashSet<Block>();

    private LogicWireUtils() {
    }

    public static int getRedstoneWireLevel(IBlockAccess world, BlockPos pos, WireFace face) {
        Wire wire = WireUtils.getWire((IBlockAccess)world, (BlockPos)pos, (WireFace)face);
        return wire instanceof PartWireSignalBase ? ((PartWireSignalBase)wire).getSignalLevel() : 0;
    }

    public static int getInsulatedWireLevel(IBlockAccess world, BlockPos pos, WireFace face, int color) {
        Wire wire = WireUtils.getWire((IBlockAccess)world, (BlockPos)pos, (WireFace)face);
        if (wire instanceof PartWireSignalBase) {
            PartWireSignalBase signalWire = (PartWireSignalBase)wire;
            switch (signalWire.getWireType()) {
                case NORMAL: {
                    return signalWire.getSignalLevel();
                }
                case INSULATED: {
                    return signalWire.getColor() == color ? signalWire.getSignalLevel() : 0;
                }
                case BUNDLED: {
                    return signalWire.getBundledSignalLevel(color);
                }
            }
        }
        return 0;
    }

    public static int getBundledWireLevel(IBlockAccess world, BlockPos pos, WireFace face, int color) {
        Wire wire = WireUtils.getWire((IBlockAccess)world, (BlockPos)pos, (WireFace)face);
        if (wire instanceof PartWireSignalBase) {
            PartWireSignalBase signalWire = (PartWireSignalBase)wire;
            switch (signalWire.getWireType()) {
                case INSULATED: {
                    return signalWire.getColor() == color ? signalWire.getSignalLevel() : 0;
                }
                case BUNDLED: {
                    return signalWire.getBundledSignalLevel(color);
                }
            }
        }
        return 0;
    }

    public static int getStrongRedstoneLevel(Wire wire, BlockPos pos, IBlockState state, EnumFacing facing, WireFace face) {
        if (facing == null) {
            return 0;
        }
        if (WireUtils.hasCapability((Wire)wire, (BlockPos)pos, (Capability)Capabilities.REDSTONE_EMITTER, (EnumFacing)facing.func_176734_d(), (boolean)false)) {
            return 0;
        }
        World world = wire.getContainer().world();
        return state.func_185893_b((IBlockAccess)world, pos, facing);
    }

    public static int getWeakRedstoneLevel(Wire wire, BlockPos pos, IBlockState state, EnumFacing facing, WireFace face) {
        EnumFacing facingOpposite;
        World world = wire.getContainer().world();
        int power = RedstoneUtils.getModdedWeakPower((IBlockAccess)world, (BlockPos)pos, (EnumFacing)facing, (EnumFacing)face.facing, tileEntity -> true);
        if (power >= 0) {
            return power;
        }
        EnumFacing enumFacing = facingOpposite = facing == null ? null : facing.func_176734_d();
        if (WireUtils.hasCapability((Wire)wire, (BlockPos)pos, (Capability)Capabilities.REDSTONE_EMITTER, (EnumFacing)facingOpposite, (boolean)false)) {
            IRedstoneEmitter emitter = (IRedstoneEmitter)WireUtils.getCapability((Wire)wire, (BlockPos)pos, (Capability)Capabilities.REDSTONE_EMITTER, (EnumFacing)facingOpposite, (boolean)true);
            if (emitter instanceof PartWireSignalBase) {
                return 0;
            }
            return emitter.getRedstoneSignal();
        }
        Block block = state.func_177230_c();
        if (block instanceof BlockRedstoneWire && face == WireFace.DOWN) {
            return (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O);
        }
        return block.shouldCheckWeakPower(state, (IBlockAccess)world, pos, facing) ? state.func_185893_b((IBlockAccess)world, pos, facing) : state.func_185911_a((IBlockAccess)world, pos, facing);
    }

    public static int width(WireType type) {
        switch (type) {
            case NORMAL: {
                return 2;
            }
            case INSULATED: {
                return 4;
            }
            case BUNDLED: {
                return 6;
            }
        }
        return 0;
    }

    public static int height(WireType type) {
        switch (type) {
            case NORMAL: {
                return 2;
            }
            case INSULATED: {
                return 3;
            }
            case BUNDLED: {
                return 4;
            }
        }
        return 0;
    }

    public static boolean canPlaceWire(IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (WIRE_PLACEABLE.contains(state.func_177230_c())) {
            return true;
        }
        return block.isSideSolid(state, world, pos, side);
    }

    static {
        WIRE_PLACEABLE.add(Blocks.field_150426_aN);
        WIRE_PLACEABLE.add((Block)Blocks.field_150331_J);
        WIRE_PLACEABLE.add((Block)Blocks.field_180384_M);
        WIRE_PLACEABLE.add((Block)Blocks.field_150320_F);
    }
}

