/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.odysseyWorld.blocks.tiles;

import com.feed_the_beast.odysseyWorld.FTBOdyssey;
import com.feed_the_beast.odysseyWorld.blocks.tiles.TileFTBPortal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import reborncore.common.network.INetworkPacket;
import reborncore.common.network.packet.CustomDescriptionPacket;
import reborncore.common.util.Inventory;

public class TileFTBPortalFrame
extends TileEntity
implements ITickable {
    boolean master = false;
    public Inventory inventory = new Inventory(1, "portal_frame", 1, (TileEntity)this);

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189515_b(new NBTTagCompound());
        this.func_189515_b(compound);
        return compound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.inventory.readFromNBT(compound);
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.inventory.writeToNBT(compound);
        return super.func_189515_b(compound);
    }

    public void syncWithAll() {
        if (!this.field_145850_b.field_72995_K) {
            reborncore.common.network.NetworkManager.sendToAllAround((INetworkPacket)new CustomDescriptionPacket(this.field_174879_c, this.func_189515_b(new NBTTagCompound())), (NetworkRegistry.TargetPoint)new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.inventory.hasChanged) {
            this.syncWithAll();
            this.inventory.hasChanged = false;
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.checkAndUpdate();
        }
    }

    private void checkAndUpdate() {
        if (this.isValidShape()) {
            List<TileFTBPortalFrame> frames = this.getFrames();
            int items = 0;
            if (this.field_145850_b.field_73011_w.getDimension() == 0) {
                for (TileFTBPortalFrame frame : frames) {
                    if (frame.inventory.func_70301_a(0).func_190926_b()) continue;
                    ++items;
                }
            } else {
                items = 12;
            }
            if (items == 12) {
                this.fillCenter(FTBOdyssey.ftbPortal.func_176223_P());
                BlockPos centerPos = this.func_174877_v().func_177982_a(-2, 0, 1);
                TileFTBPortal tile = (TileFTBPortal)this.field_145850_b.func_175625_s(centerPos);
                if (tile != null) {
                    tile.setCenter(true);
                }
            } else {
                this.fillCenter(Blocks.field_150350_a.func_176223_P());
            }
        } else if (this.master) {
            this.fillCenter(Blocks.field_150350_a.func_176223_P());
            this.master = false;
        }
    }

    public void onBreak() {
        if (!this.inventory.func_70301_a(0).func_190926_b()) {
            if (!this.field_145850_b.field_72995_K) {
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)this.inventory.func_70301_a(0));
            }
            this.inventory.func_70299_a(0, ItemStack.field_190927_a);
        }
        this.checkAndUpdate();
    }

    public void fillCenter(IBlockState state) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                BlockPos pos = this.func_174877_v().func_177982_a(-i - 1, 0, j);
                this.field_145850_b.func_175656_a(pos, state);
            }
        }
    }

    public String[] layout() {
        return new String[]{" fff ", "f   f", "f   f", "f   f", " fff "};
    }

    public boolean isValidShape() {
        String[] layout = this.layout();
        for (int x = 0; x < layout.length; ++x) {
            String row = layout[x];
            for (int z = 0; z < row.length(); ++z) {
                char cha = row.charAt(z);
                BlockPos checkPos = this.func_174877_v().func_177982_a(-x, 0, z - 1);
                IBlockState state = this.field_145850_b.func_180495_p(checkPos);
                if (cha != 'f' || state.func_177230_c() == FTBOdyssey.ftbFrame) continue;
                return false;
            }
        }
        this.master = true;
        return true;
    }

    public List<BlockPos> getFrameLocations() {
        String[] layout = this.layout();
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (int x = 0; x < layout.length; ++x) {
            String row = layout[x];
            for (int z = 0; z < row.length(); ++z) {
                char cha = row.charAt(z);
                BlockPos checkPos = this.func_174877_v().func_177982_a(-x, 0, z - 1);
                if (cha != 'f') continue;
                list.add(checkPos);
            }
        }
        return list;
    }

    public List<TileFTBPortalFrame> getFrames() {
        return this.getFrameLocations().stream().map(pos -> (TileFTBPortalFrame)this.field_145850_b.func_175625_s(pos)).collect(Collectors.toList());
    }
}

