/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.odysseyWorld.blocks;

import com.feed_the_beast.odysseyWorld.FTBOdyssey;
import com.feed_the_beast.odysseyWorld.FTBOdysseyConfig;
import com.feed_the_beast.odysseyWorld.blocks.tiles.TileFTBPortalFrame;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import reborncore.common.util.ItemUtils;

public class BlockFTBPortalFrame
extends BlockContainer {
    public BlockFTBPortalFrame() {
        super(Material.field_151567_E);
        this.func_149663_c("ftb_odyssey.portal_frame");
        this.func_149711_c(1.0f);
        this.func_149752_b(1.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        hand = EnumHand.MAIN_HAND;
        TileFTBPortalFrame tile = (TileFTBPortalFrame)worldIn.func_175625_s(pos);
        if (tile == null) {
            return false;
        }
        if (!playerIn.func_184586_b(hand).func_190926_b() && playerIn.func_184586_b(hand).func_77973_b() == Item.func_150898_a((Block)FTBOdyssey.ftbFrame)) {
            return false;
        }
        if (!tile.inventory.func_70301_a(0).func_190926_b()) {
            boolean emptyHand = playerIn.func_184586_b(hand).func_190926_b();
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)tile.inventory.func_70301_a(0));
            tile.inventory.func_70299_a(0, ItemStack.field_190927_a);
            if (emptyHand) {
                return true;
            }
        }
        if (!playerIn.func_184586_b(hand).func_190926_b()) {
            ItemStack stack = playerIn.func_184586_b(hand);
            if (!FTBOdysseyConfig.portalFrameItems.isEmpty() && !this.isInWhiteList(stack, tile)) {
                return true;
            }
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(1);
            tile.inventory.func_70299_a(0, copy);
            stack.func_190918_g(1);
        }
        return true;
    }

    public boolean isInWhiteList(ItemStack input, TileFTBPortalFrame frame) {
        ItemStack stack = input.func_77946_l();
        stack.func_77964_b(0);
        stack.func_190920_e(1);
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o("cooldown");
        }
        if (FTBOdysseyConfig.portalFrameItems.size() == 12) {
            Optional<TileFTBPortalFrame> portalFrame = this.findMasterBlock(frame.func_145831_w(), frame.func_174877_v());
            if (portalFrame.isPresent()) {
                boolean inOther = portalFrame.get().getFrames().stream().map(frame1 -> frame1.inventory.func_70301_a(0)).anyMatch(itemStack -> ItemUtils.isItemEqual((ItemStack)itemStack, (ItemStack)stack, (boolean)true, (boolean)true, (boolean)false));
                boolean inConfig = false;
                for (String string : FTBOdysseyConfig.portalFrameItems) {
                    if (!string.equals(stack.serializeNBT().toString())) continue;
                    inConfig = true;
                }
                if (!inConfig) {
                    return false;
                }
                return !inOther;
            }
            return false;
        }
        for (String string : FTBOdysseyConfig.portalFrameItems) {
            if (!string.equals(stack.serializeNBT().toString())) continue;
            return true;
        }
        return false;
    }

    public Optional<TileFTBPortalFrame> findMasterBlock(World world, BlockPos start) {
        for (int i = -5; i < 5; ++i) {
            for (int j = -5; j < 5; ++j) {
                TileFTBPortalFrame portalFrame;
                BlockPos pos = start.func_177982_a(i, 0, j);
                TileEntity tileEntity = world.func_175625_s(pos);
                if (!(tileEntity instanceof TileFTBPortalFrame) || !(portalFrame = (TileFTBPortalFrame)tileEntity).isValidShape() || !portalFrame.getFrameLocations().contains(start)) continue;
                return Optional.of(portalFrame);
            }
        }
        return Optional.empty();
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (worldIn.func_175625_s(pos) instanceof TileFTBPortalFrame) {
            TileFTBPortalFrame frame = (TileFTBPortalFrame)worldIn.func_175625_s(pos);
            frame.onBreak();
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT_MIPPED || layer == BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileFTBPortalFrame();
    }
}

