/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.element;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.shadowfacts.shadowmc.ui.UIDimensions;
import net.shadowfacts.shadowmc.ui.UIElement;
import net.shadowfacts.shadowmc.ui.style.UIAttribute;
import net.shadowfacts.shadowmc.ui.style.UIHorizontalLayoutMode;
import net.shadowfacts.shadowmc.ui.style.UILayoutMode;
import net.shadowfacts.shadowmc.ui.style.UIVerticalLayoutMode;
import net.shadowfacts.shadowmc.ui.style.stylesheet.Rule;

public abstract class UIElementBase
implements UIElement {
    protected final Minecraft mc = Minecraft.func_71410_x();
    private final Map<UIAttribute, Object> style = new HashMap<UIAttribute, Object>();
    protected int x;
    protected int y;
    protected UIDimensions dimensions;
    private UIElement parent;
    private Runnable invalidationHandler = () -> this.parent.invalidateLayout();
    private final String type;
    private String id;
    private Set<String> classes = new LinkedHashSet<String>();

    public UIElementBase(String type, String id, String ... classes) {
        this.type = type;
        this.id = id;
        Collections.addAll(this.classes, classes);
    }

    @Override
    public abstract UIDimensions getMinDimensions();

    @Override
    public UIDimensions getMaxDimensions() {
        return UIDimensions.max();
    }

    @Override
    public abstract UIDimensions getPreferredDimensions();

    @Override
    public void invalidateLayout() {
        this.invalidationHandler.run();
    }

    @Override
    public void layout(int minX, int maxX, int minY, int maxY) {
        UILayoutMode layoutMode = this.getStyle(UIAttribute.LAYOUT);
        switch (layoutMode) {
            case MIN: {
                this.dimensions = this.getMinDimensions();
                break;
            }
            default: {
                this.dimensions = this.getPreferredDimensions();
                break;
            }
            case MAX: {
                this.dimensions = this.getMaxDimensions();
            }
        }
        UIHorizontalLayoutMode horizontalLayoutMode = this.getStyle(UIAttribute.HORIZONTAL_LAYOUT);
        switch (horizontalLayoutMode) {
            case LEFT: {
                this.x = minX;
                break;
            }
            default: {
                this.x = maxX / 2 - this.dimensions.width / 2;
                break;
            }
            case RIGHT: {
                this.x = maxX - this.dimensions.width;
            }
        }
        UIVerticalLayoutMode verticalLayoutMode = this.getStyle(UIAttribute.VERTICAL_LAYOUT);
        switch (verticalLayoutMode) {
            case TOP: {
                this.y = minY;
                break;
            }
            default: {
                this.y = maxY / 2 - this.dimensions.height / 2;
                break;
            }
            case BOTTOM: {
                this.y = maxY - this.dimensions.height;
            }
        }
    }

    @Override
    public abstract void draw(int var1, int var2);

    @Override
    public <T> void setStyle(UIAttribute<T> attr, T val) {
        this.style.put(attr, val);
    }

    @Override
    public <T> T getStyle(UIAttribute<T> attr) {
        Object val = this.style.get(attr);
        return (T)(val != null ? val : attr.getDefaultVal());
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    @Override
    public void addClass(String clazz) {
        this.classes.add(clazz);
    }

    @Override
    public void applyRule(Rule<?> rule) {
        if (!this.style.containsKey(rule.attr) || rule.important) {
            this.style.put(rule.attr, rule.value);
        }
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public UIDimensions getDimensions() {
        return this.dimensions;
    }

    @Override
    public void setDimensions(UIDimensions dimensions) {
        this.dimensions = dimensions;
    }

    @Override
    public UIElement getParent() {
        return this.parent;
    }

    @Override
    public void setParent(UIElement parent) {
        this.parent = parent;
    }

    @Override
    public void setInvalidationHandler(Runnable invalidationHandler) {
        this.invalidationHandler = invalidationHandler;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Set<String> getClasses() {
        return this.classes;
    }

    @Override
    public void setClasses(Set<String> classes) {
        this.classes = classes;
    }
}

