/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.money.integration;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigLong;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.ISingleLongValueTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskData;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskType;
import com.feed_the_beast.ftbquests.quest.task.SimpleQuestTaskData;
import com.feed_the_beast.mods.money.FTBMoney;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MoneyTask
extends QuestTask
implements ISingleLongValueTask {
    public static QuestTaskType TYPE;
    public long value = 1L;

    public MoneyTask(Quest quest) {
        super(quest);
    }

    public QuestTaskType getType() {
        return TYPE;
    }

    public long getMaxProgress() {
        return this.value;
    }

    public String getMaxProgressString() {
        return FTBMoney.moneyString(this.value);
    }

    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74772_a("value", this.value);
    }

    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.value = nbt.func_74763_f("value");
    }

    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarLong(this.value);
    }

    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.value = data.readVarLong();
    }

    public ConfigLong getDefaultValue() {
        return new ConfigLong(this.value, 1L, Long.MAX_VALUE);
    }

    public void setValue(long v) {
        this.value = v;
    }

    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("value", () -> this.value, v -> {
            this.value = v;
        }, 1L, 1L, Long.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.task.ftbquests.ftb_money", new Object[0]));
    }

    public ITextComponent getAltDisplayName() {
        return FTBMoney.moneyComponent(this.value);
    }

    public QuestTaskData createData(ITeamData data) {
        return new Data(this, data);
    }

    @SideOnly(value=Side.CLIENT)
    public void addMouseOverText(List<String> list, @Nullable QuestTaskData data) {
        list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbmoney.balance", (Object[])new Object[0]) + ": " + TextFormatting.GOLD + FTBMoney.moneyString(FTBMoney.getMoney((EntityPlayer)Minecraft.func_71410_x().field_71439_g)));
    }

    public static class Data
    extends SimpleQuestTaskData<MoneyTask> {
        private Data(MoneyTask task, ITeamData data) {
            super((QuestTask)task, data);
        }

        public String getProgressString() {
            return FTBMoney.moneyString(this.progress);
        }

        public boolean submitTask(EntityPlayerMP player, Collection<ItemStack> itemsToCheck, boolean simulate) {
            long money = FTBMoney.getMoney((EntityPlayer)player);
            long add = Math.min(money, ((MoneyTask)this.task).value - this.progress);
            if (add > 0L) {
                if (!simulate) {
                    FTBMoney.setMoney((EntityPlayer)player, money - add);
                    this.progress += add;
                    this.sync();
                }
                return true;
            }
            return false;
        }
    }
}

