/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.money.gui;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigInt;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiEditConfig;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiEditConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.mods.money.FTBMoney;
import com.feed_the_beast.mods.money.FTBMoneyClientConfig;
import com.feed_the_beast.mods.money.gui.GuiShop;
import com.feed_the_beast.mods.money.net.MessageBuy;
import com.feed_the_beast.mods.money.net.MessageEditShopEntry;
import com.feed_the_beast.mods.money.shop.ShopEntry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class ButtonShopEntry
extends Button {
    public static final Comparator<ButtonShopEntry> COMPARATOR = (o1, o2) -> FTBMoneyClientConfig.general.sort.comparator.compare(o1.entry, o2.entry);
    public final ShopEntry entry;
    public final int locked;

    public ButtonShopEntry(Panel panel, ShopEntry e) {
        super(panel, e.stack.func_77953_t().field_77937_e + e.stack.func_82833_r(), ItemIcon.getItemIcon((ItemStack)e.stack));
        this.entry = e;
        QuestObject lock = ClientQuestFile.INSTANCE.get(this.entry.lock);
        this.locked = this.entry.lock == 0 || lock != null && lock.isComplete((ITeamData)ClientQuestFile.INSTANCE.self) ? (this.entry.disabledServer && !Minecraft.func_71410_x().func_71356_B() ? 1 : 0) : 2;
        this.setWidth(Math.max(panel.getGui().getTheme().getStringWidth(this.title), panel.getGui().getTheme().getStringWidth(FTBMoney.moneyString(this.entry.buy))) + 32);
        this.setHeight(24);
    }

    public void onClicked(MouseButton button) {
        GuiHelper.playClickSound();
        GuiShop gui = (GuiShop)this.getGui();
        if (button.isLeft()) {
            if (this.locked == 0 || this.entry.tab.shop.file.canEdit()) {
                new GuiEditConfigValue("count", (ConfigValue)new ConfigInt(1, 1, (int)Math.min(1024L, this.entry.buy <= 0L ? 1024L : FTBMoney.getMoney((EntityPlayer)Minecraft.func_71410_x().field_71439_g) / this.entry.buy)), (value, set) -> {
                    gui.openGui();
                    if (set) {
                        new MessageBuy(this.entry, value.getInt()).sendToServer();
                    }
                }).openGui();
            }
        } else if (button.isRight() && this.entry.tab.shop.file.canEdit()) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.edit", (Object[])new Object[0]), GuiIcons.SETTINGS, () -> {
                ConfigGroup group = ConfigGroup.newGroup((String)"ftbmoney").setDisplayName((ITextComponent)new TextComponentTranslation("sidebar_button.ftbmoney.shop", new Object[0]));
                ConfigGroup g = group.getGroup("shop").getGroup("entry");
                this.entry.getConfig(g);
                new GuiEditConfig(group, (g1, sender) -> new MessageEditShopEntry(this.entry, false).sendToServer()).openGui();
                gui.refreshWidgets();
            }));
            contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"selectServer.delete", (Object[])new Object[0]), GuiIcons.REMOVE, () -> gui.openYesNo(I18n.func_135052_a((String)"delete_item", (Object[])new Object[]{this.entry.stack.func_82833_r()}), "", () -> {
                new MessageEditShopEntry(this.entry, true).sendToServer();
                this.entry.tab.entries.remove(this.entry);
                gui.refreshWidgets();
            })));
            gui.openContextMenu(contextMenu);
        }
    }

    public WidgetType getWidgetType() {
        if (this.locked > 0 && !this.entry.tab.shop.file.canEdit()) {
            return WidgetType.DISABLED;
        }
        return super.getWidgetType();
    }

    public void addMouseOverText(List<String> list) {
        if (this.locked == 2) {
            list.add("Locked!");
            QuestObject object = ClientQuestFile.INSTANCE.get(this.entry.lock);
            if (object != null) {
                list.add("Requires: " + object.getObjectType().getColor() + object.getDisplayName().func_150254_d());
            }
        }
        if (this.locked < 2 || this.entry.tab.shop.file.canEdit()) {
            if (this.entry.disabledServer && !Minecraft.func_71410_x().func_71356_B()) {
                list.add(TextFormatting.RED + I18n.func_135052_a((String)"ftbmoney.shop.entry.disabled_server", (Object[])new Object[0]));
            }
            GuiHelper.addStackTooltip((ItemStack)this.entry.stack, list);
        }
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        this.drawBackground(theme, x, y, w, h);
        if (this.locked == 2 && !this.entry.tab.shop.file.canEdit()) {
            GuiIcons.LOCK.draw(x + 4, y + 4, 16, 16);
            theme.drawString("???", x + 24, y + 3, theme.getContentColor(this.getWidgetType()), 2);
            theme.drawString(TextFormatting.GOLD + "\u0398 " + TextFormatting.OBFUSCATED + "000,000,000", x + 24, y + 13, Color4I.WHITE, 2);
            return;
        }
        String t = this.title;
        int mw = w - 24;
        if (theme.getStringWidth(t) > mw) {
            t = theme.trimStringToWidth(t, mw);
        }
        this.drawIcon(theme, x + 4, y + 4, 16, 16);
        theme.drawString(t, x + 24, y + 3, theme.getContentColor(this.getWidgetType()), 2);
        theme.drawString(TextFormatting.GOLD + FTBMoney.moneyString(this.entry.buy), x + 24, y + 13, Color4I.WHITE, 2);
    }

    @Nullable
    public Object getJEIFocus() {
        return this.locked < 2 ? this.entry.stack : null;
    }
}

