/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.projectex.item;

import moze_intel.projecte.api.item.IItemEmc;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.items.KleinStar;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemMagnumStar
extends Item
implements IItemEmc {
    public static final long[] STAR_EMC = new long[12];
    public final KleinStar.EnumKleinTier tier;

    public ItemMagnumStar(KleinStar.EnumKleinTier t) {
        this.tier = t;
        this.func_77625_d(1);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getStoredEmc(stack) > 0.0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double emc = this.getStoredEmc(stack);
        return emc == 0.0 ? 1.0 : 1.0 - emc / this.getMaximumEmc(stack);
    }

    public double addEmc(ItemStack stack, double toAdd) {
        double add = Math.min(this.getMaximumEmc(stack) - this.getStoredEmc(stack), toAdd);
        ItemPE.addEmcToStack((ItemStack)stack, (double)add);
        return add;
    }

    public double extractEmc(ItemStack stack, double toRemove) {
        double sub = Math.min(this.getStoredEmc(stack), toRemove);
        ItemPE.removeEmc((ItemStack)stack, (double)sub);
        return sub;
    }

    public double getStoredEmc(ItemStack stack) {
        return ItemPE.getEmc((ItemStack)stack);
    }

    public double getMaximumEmc(ItemStack stack) {
        return STAR_EMC[this.tier.ordinal()];
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    static {
        long emc = 204800000L;
        for (int i = 0; i < STAR_EMC.length; ++i) {
            ItemMagnumStar.STAR_EMC[i] = emc;
            emc *= 4L;
        }
    }
}

