/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.projectex.gui;

import com.latmod.mods.projectex.ProjectEXUtils;
import com.latmod.mods.projectex.client.ProjectEXClientConfig;
import com.latmod.mods.projectex.gui.ButtonBurnItem;
import com.latmod.mods.projectex.gui.ButtonCreateItem;
import com.latmod.mods.projectex.gui.ButtonLearnItem;
import com.latmod.mods.projectex.gui.ButtonSmall;
import com.latmod.mods.projectex.gui.ButtonUnlearnItem;
import com.latmod.mods.projectex.gui.ContainerTableBase;
import com.latmod.mods.projectex.integration.jei.ProjectEXJEIIntegration;
import com.latmod.mods.projectex.net.MessageCreateItemButton;
import com.latmod.mods.projectex.net.ProjectEXNetHandler;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class GuiTableBase
extends GuiContainer
implements ContainerTableBase.KnowledgeUpdate {
    public static String staticSearch = "";
    public static int staticPage = 0;
    public ContainerTableBase table;
    public GuiTextField searchField;
    public final List<ItemStack> validItems;
    public final List<ButtonCreateItem> itemButtons;

    public GuiTableBase(ContainerTableBase c) {
        super((Container)c);
        this.table = c;
        this.table.knowledgeUpdate = this;
        this.field_146999_f = 176;
        this.field_147000_g = 217;
        this.validItems = new ArrayList<ItemStack>();
        this.itemButtons = new ArrayList<ButtonCreateItem>();
        this.updateValidItemList();
    }

    private String trim(String s) {
        return TextFormatting.func_110646_a((String)s.trim()).toLowerCase();
    }

    public void updateValidItemList() {
        this.validItems.clear();
        String s = this.trim(staticSearch);
        boolean mod = s.startsWith("@");
        if (mod) {
            s = s.substring(1);
        }
        for (ItemStack stack : this.table.playerData.getKnowledge()) {
            if (!this.table.isItemValid(stack) || !(s.isEmpty() || mod ? stack.func_77973_b().getRegistryName().func_110624_b().startsWith(s) : this.trim(stack.func_82833_r()).contains(s))) continue;
            this.validItems.add(ProjectEXUtils.fixOutput(stack));
        }
        Collections.reverse(this.validItems);
        this.updateCurrentItemList();
    }

    public void updateCurrentItemList() {
        for (int i = 0; i < this.itemButtons.size(); ++i) {
            int index = i + staticPage * this.itemButtons.size();
            this.itemButtons.get((int)i).type = index >= 0 && index < this.validItems.size() ? this.validItems.get(index) : ItemStack.field_190927_a;
        }
    }

    public abstract Rectangle getTextBox();

    public abstract void addButtons();

    public abstract ResourceLocation getTexture();

    public void func_73866_w_() {
        this.itemButtons.clear();
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        Rectangle tb = this.getTextBox();
        this.searchField = new GuiTextField(0, this.field_146289_q, tb.x, tb.y, tb.width, tb.height);
        this.searchField.func_146193_g(-1);
        this.searchField.func_146204_h(-1);
        this.searchField.func_146185_a(false);
        this.searchField.func_146203_f(35);
        this.searchField.func_146180_a(staticSearch);
        this.searchField.func_146195_b(ProjectEXClientConfig.general.search_type.autoselected);
        this.addButtons();
        this.updateValidItemList();
    }

    protected <T extends GuiButton> T func_189646_b(T button) {
        if (button instanceof ButtonCreateItem) {
            this.itemButtons.add((ButtonCreateItem)button);
        }
        return (T)super.func_189646_b(button);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        this.searchField.func_146194_f();
        for (GuiButton button : this.field_146292_n) {
            if (!button.func_146115_a()) continue;
            if (button instanceof ButtonLearnItem) {
                this.drawHoveringText(Collections.singletonList(I18n.func_135052_a((String)"tile.projectex.stone_table.learn", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                continue;
            }
            if (button instanceof ButtonUnlearnItem) {
                this.drawHoveringText(Collections.singletonList(I18n.func_135052_a((String)"tile.projectex.stone_table.unlearn", (Object[])new Object[0])), mouseX, mouseY, this.field_146289_q);
                continue;
            }
            if (button instanceof ButtonCreateItem) {
                if (((ButtonCreateItem)button).type.func_190926_b()) continue;
                this.func_146285_a(((ButtonCreateItem)button).type, mouseX, mouseY);
                continue;
            }
            if (!(button instanceof ButtonSmall) || button.field_146126_j.isEmpty()) continue;
            this.drawHoveringText(Collections.singletonList(button.field_146126_j), mouseX, mouseY, this.field_146289_q);
        }
        if (!staticSearch.equals(this.searchField.func_146179_b())) {
            staticSearch = this.searchField.func_146179_b();
            staticPage = 0;
            this.updateValidItemList();
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button instanceof ButtonBurnItem) {
            this.clickGuiSlot(ItemStack.field_190927_a, GuiTableBase.func_146272_n() ? 4 : 1);
        } else if (button instanceof ButtonCreateItem) {
            this.clickGuiSlot(((ButtonCreateItem)button).type, GuiTableBase.func_146272_n() ? 2 : 3);
        }
        if (button instanceof ButtonLearnItem) {
            this.clickGuiSlot(ItemStack.field_190927_a, 5);
        }
        if (button instanceof ButtonUnlearnItem) {
            this.clickGuiSlot(ItemStack.field_190927_a, 6);
        } else if (button.field_146127_k == 1) {
            this.changePage(false);
        } else if (button.field_146127_k == 2) {
            this.changePage(true);
        }
    }

    private void clickGuiSlot(ItemStack stack, int mode) {
        if (this.table.clickGuiSlot(stack, mode)) {
            ProjectEXNetHandler.NET.sendToServer((IMessage)new MessageCreateItemButton(stack, mode));
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 1 && mouseX >= this.searchField.field_146209_f && mouseX < this.searchField.field_146209_f + this.searchField.field_146218_h && mouseY >= this.searchField.field_146210_g && mouseY < this.searchField.field_146210_g + this.searchField.field_146219_i) {
            this.searchField.func_146180_a("");
            this.searchField.func_146195_b(true);
        } else if (this.searchField.func_146192_a(mouseX, mouseY, mouseButton) && !this.table.player.field_71071_by.func_70445_o().func_190926_b()) {
            this.searchField.func_146180_a(this.trim(this.table.player.field_71071_by.func_70445_o().func_82833_r()));
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.searchField.func_146201_a(typedChar, keyCode)) {
            if (ProjectEXClientConfig.general.search_type.jeiSync && Loader.isModLoaded((String)"jei")) {
                this.syncJEITextbox();
            }
            return;
        }
        if (!(this.searchField.func_146206_l() || typedChar != '\t' && typedChar != ' ')) {
            this.searchField.func_146195_b(true);
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    private void syncJEITextbox() {
        if (ProjectEXJEIIntegration.RUNTIME != null) {
            ProjectEXJEIIntegration.RUNTIME.getIngredientFilter().setFilterText(this.searchField.func_146179_b());
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            this.changePage(i < 0);
        }
    }

    public void changePage(boolean next) {
        if (next) {
            if (staticPage < MathHelper.func_76123_f((float)((float)this.validItems.size() / (float)this.itemButtons.size())) - 1) {
                ++staticPage;
                this.updateCurrentItemList();
            }
        } else if (staticPage > 0) {
            --staticPage;
            this.updateCurrentItemList();
        }
    }

    @Override
    public void updateKnowledge() {
        staticPage = 0;
        staticSearch = "";
        this.searchField.func_146180_a("");
        this.updateValidItemList();
    }

    public List<GuiButton> getButtons() {
        return this.field_146292_n;
    }
}

