/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.projectex.gui;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import com.latmod.mods.projectex.ProjectEXUtils;
import com.latmod.mods.projectex.gui.ContainerTableBase;
import com.latmod.mods.projectex.gui.InventoryCraftingArcaneTablet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import moze_intel.projecte.api.ProjectEAPI;
import moze_intel.projecte.config.ProjectEConfig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ContainerArcaneTablet
extends ContainerTableBase {
    private static final int[] ROTATION_SLOTS = new int[]{0, 1, 2, 5, 8, 7, 6, 3};
    public final InventoryCrafting craftMatrix = new InventoryCraftingArcaneTablet(this, 3, 3, (IItemHandlerModifiable)this.playerData.getInputAndLocks());
    public final InventoryCraftResult craftResult = new InventoryCraftResult();
    public boolean skipRefill = false;

    public ContainerArcaneTablet(EntityPlayer p) {
        super(p);
        this.func_75146_a((Slot)new SlotCrafting(this.player, this.craftMatrix, (IInventory)this.craftResult, 0, -23, 75){

            protected void func_75208_c(ItemStack stack) {
                super.func_75208_c(stack);
                if (ProjectEXUtils.addKnowledge(ContainerArcaneTablet.this.player, ContainerArcaneTablet.this.playerData, ProjectEXUtils.fixOutput(stack)) == 2 && ContainerArcaneTablet.this.knowledgeUpdate != null) {
                    ContainerArcaneTablet.this.knowledgeUpdate.updateKnowledge();
                }
            }

            public ItemStack func_190901_a(EntityPlayer player, ItemStack stack) {
                if (ContainerArcaneTablet.this.skipRefill) {
                    return super.func_190901_a(player, stack);
                }
                ItemStack[] prevItems = new ItemStack[ContainerArcaneTablet.this.craftMatrix.func_70302_i_()];
                for (int i = 0; i < prevItems.length; ++i) {
                    prevItems[i] = ContainerArcaneTablet.this.craftMatrix.func_70301_a(i);
                    if (prevItems[i].func_190926_b()) continue;
                    prevItems[i] = ItemHandlerHelper.copyStackWithSize((ItemStack)prevItems[i], (int)1);
                }
                ItemStack is = super.func_190901_a(player, stack);
                for (int i = 0; i < prevItems.length; ++i) {
                    if (prevItems[i].func_190926_b() || !ContainerArcaneTablet.this.craftMatrix.func_70301_a(i).func_190926_b()) continue;
                    ContainerArcaneTablet.this.transferFromTablet(i, new ItemStack[]{prevItems[i]});
                }
                return is;
            }
        });
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, x + y * 3, -59 + x * 18, 17 + y * 18));
            }
        }
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, i1 + k * 9 + 9, 8 + i1 * 18, 135 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, l, 8 + l * 18, 193){

                public boolean func_82869_a(EntityPlayer player) {
                    return this.getSlotIndex() != player.field_71071_by.field_70461_c;
                }
            });
        }
        this.func_192389_a(this.player.field_70170_p, this.player, this.craftMatrix, this.craftResult);
    }

    public void func_75130_a(IInventory inventory) {
        this.func_192389_a(this.player.field_70170_p, this.player, this.craftMatrix, this.craftResult);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer player, int index) {
        if (index == 0) {
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot != null && slot.func_75216_d()) {
                ItemStack stack = slot.func_75211_c();
                ItemStack oldStack = stack.func_77946_l();
                stack.func_77973_b().func_77622_d(stack, player.field_70170_p, player);
                if (!this.func_75135_a(stack, 10, 46, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stack, oldStack);
                if (stack.func_190926_b()) {
                    slot.func_75215_d(ItemStack.field_190927_a);
                } else {
                    slot.func_75218_e();
                }
                if (stack.func_190916_E() == oldStack.func_190916_E()) {
                    return ItemStack.field_190927_a;
                }
                player.func_71019_a(slot.func_190901_a(player, stack), false);
                return oldStack;
            }
            return ItemStack.field_190927_a;
        }
        return super.func_82846_b(player, index);
    }

    public ItemStack func_184996_a(int slot, int dragType, ClickType clickType, EntityPlayer player) {
        if (clickType == ClickType.QUICK_MOVE) {
            this.skipRefill = true;
        }
        ItemStack stack = super.func_184996_a(slot, dragType, clickType, player);
        if (clickType == ClickType.QUICK_MOVE) {
            this.skipRefill = false;
        }
        return stack;
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.craftResult && super.func_94530_a(stack, slot);
    }

    public void onRecipeTransfer(ItemStack[][] recipe, boolean transferAll) {
        this.clearCraftingMatrix();
        int max = Math.min(recipe.length, this.craftMatrix.func_70302_i_());
        this.transferItems(recipe, max);
        if (transferAll) {
            for (int i = 0; i < 63; ++i) {
                this.transferItems(recipe, max);
            }
        }
        this.func_192389_a(this.player.field_70170_p, this.player, this.craftMatrix, this.craftResult);
        this.func_75142_b();
    }

    private void transferItems(ItemStack[][] recipe, int max) {
        int i;
        for (i = 0; i < max; ++i) {
            if (recipe[i] != null && recipe[i].length > 0 && !this.transferFromInventory(i, recipe[i], false) && !this.transferFromInventory(i, recipe[i], true)) continue;
        }
        for (i = 0; i < max; ++i) {
            if (recipe[i] != null && recipe[i].length > 0 && !this.transferFromTablet(i, recipe[i])) continue;
        }
    }

    private boolean transferFromTablet(int i, ItemStack[] possibilities) {
        if (possibilities.length > 1) {
            Arrays.sort(possibilities, Comparator.comparingLong(o -> ProjectEAPI.getEMCProxy().getValue(o)));
        }
        for (ItemStack stack : possibilities) {
            long value;
            ItemStack stack1 = ProjectEXUtils.fixOutput(stack);
            if (!this.playerData.hasKnowledge(stack1) || (value = ProjectEAPI.getEMCProxy().getValue(stack1)) <= 0L || !(this.playerData.getEmc() >= (double)value)) continue;
            ItemStack slotItem = this.craftMatrix.func_70301_a(i);
            if (slotItem.func_190926_b()) {
                this.craftMatrix.func_70299_a(i, stack1);
            } else {
                if (slotItem.func_190916_E() >= slotItem.func_77976_d() || slotItem.func_77973_b() != stack1.func_77973_b() || slotItem.func_77960_j() != stack1.func_77960_j() || !Objects.equals(slotItem.func_77973_b().getNBTShareTag(slotItem), stack1.func_77973_b().getNBTShareTag(stack1))) continue;
                slotItem.func_190917_f(1);
            }
            this.playerData.setEmc(this.playerData.getEmc() - (double)value);
            return true;
        }
        return false;
    }

    private boolean transferFromInventory(int i, ItemStack[] possibilities, boolean ignoreNBT) {
        for (ItemStack possibility : possibilities) {
            int meta = possibility.func_77973_b().func_77645_m() ? -1 : possibility.func_77960_j();
            for (int j = 0; j < this.player.field_71071_by.func_70302_i_(); ++j) {
                ItemStack stack = this.player.field_71071_by.func_70301_a(j);
                if (possibility.func_77973_b() != stack.func_77973_b() || meta != -1 && possibility.func_77960_j() != meta || meta != -1 && !ignoreNBT && !Objects.equals(possibility.func_77973_b().getNBTShareTag(possibility), stack.func_77973_b().getNBTShareTag(stack))) continue;
                ItemStack slotItem = this.craftMatrix.func_70301_a(i);
                if (slotItem.func_190926_b()) {
                    this.craftMatrix.func_70299_a(i, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                } else {
                    if (slotItem.func_190916_E() >= slotItem.func_77976_d() || slotItem.func_77973_b() != stack.func_77973_b() || slotItem.func_77960_j() != stack.func_77960_j() || !Objects.equals(slotItem.func_77973_b().getNBTShareTag(slotItem), stack.func_77973_b().getNBTShareTag(stack))) continue;
                    slotItem.func_190917_f(1);
                }
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    this.player.field_71071_by.func_70299_a(j, ItemStack.field_190927_a);
                }
                return true;
            }
        }
        return false;
    }

    public void clearCraftingMatrix() {
        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            int k;
            ItemStack stack = this.craftMatrix.func_70304_b(i);
            if (stack.func_190926_b()) continue;
            if (ProjectEConfig.difficulty.covalenceLoss >= 1.0 && ProjectEAPI.getEMCProxy().hasValue(stack) && (k = ProjectEXUtils.addKnowledge(this.player, this.playerData, ProjectEXUtils.fixOutput(stack))) > 0) {
                this.playerData.setEmc(this.playerData.getEmc() + (double)(ProjectEAPI.getEMCProxy().getValue(stack) * (long)stack.func_190916_E()));
                if (k <= 1 || this.knowledgeUpdate == null) continue;
                this.knowledgeUpdate.updateKnowledge();
                continue;
            }
            this.player.field_71071_by.func_191975_a(this.player.field_70170_p, stack);
        }
        this.func_192389_a(this.player.field_70170_p, this.player, this.craftMatrix, this.craftResult);
    }

    public void rotateCraftingMatrix(boolean cw) {
        int i;
        ItemStack[] stacks = new ItemStack[ROTATION_SLOTS.length];
        if (cw) {
            for (i = 0; i < ROTATION_SLOTS.length; ++i) {
                int j = i - 1;
                if (j < 0) {
                    j = ROTATION_SLOTS.length - 1;
                }
                stacks[i] = this.craftMatrix.func_70301_a(ROTATION_SLOTS[j % ROTATION_SLOTS.length]);
            }
        } else {
            for (i = 0; i < ROTATION_SLOTS.length; ++i) {
                stacks[i] = this.craftMatrix.func_70301_a(ROTATION_SLOTS[(i + 1) % ROTATION_SLOTS.length]);
            }
        }
        for (i = 0; i < ROTATION_SLOTS.length; ++i) {
            this.craftMatrix.func_70299_a(ROTATION_SLOTS[i], stacks[i]);
        }
        this.func_192389_a(this.player.field_70170_p, this.player, this.craftMatrix, this.craftResult);
        this.func_75142_b();
    }

    public void balanceCraftingMatrix() {
        ArrayListMultimap map = ArrayListMultimap.create();
        HashMultiset itemCount = HashMultiset.create();
        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            ItemStack stack = this.craftMatrix.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77976_d() <= 1) continue;
            NBTTagCompound key = stack.serializeNBT();
            key.func_82580_o("Count");
            map.put((Object)key, (Object)stack);
            itemCount.add((Object)key, stack.func_190916_E());
        }
        for (NBTTagCompound key : map.keySet()) {
            List list = map.get((Object)key);
            int totalCount = itemCount.count((Object)key);
            int countPerStack = totalCount / list.size();
            int restCount = totalCount % list.size();
            for (ItemStack stack : list) {
                stack.func_190920_e(countPerStack);
            }
            int idx = 0;
            while (restCount > 0) {
                ItemStack stack;
                stack = (ItemStack)list.get(idx);
                if (stack.func_190916_E() < stack.func_77976_d()) {
                    stack.func_190917_f(1);
                    --restCount;
                }
                if (++idx < list.size()) continue;
                idx = 0;
            }
        }
        this.func_192389_a(this.player.field_70170_p, this.player, this.craftMatrix, this.craftResult);
        this.func_75142_b();
    }

    public void spreadCraftingMatrix() {
        boolean emptyBiggestSlot;
        do {
            ItemStack biggestStack = null;
            int biggestSize = 1;
            for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
                ItemStack stack = this.craftMatrix.func_70301_a(i);
                if (stack.func_190926_b() || stack.func_190916_E() <= biggestSize) continue;
                biggestStack = stack;
                biggestSize = stack.func_190916_E();
            }
            if (biggestStack == null) {
                return;
            }
            emptyBiggestSlot = false;
            for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
                ItemStack stack = this.craftMatrix.func_70301_a(i);
                if (!stack.func_190926_b()) continue;
                if (biggestStack.func_190916_E() > 1) {
                    this.craftMatrix.func_70299_a(i, biggestStack.func_77979_a(1));
                    continue;
                }
                emptyBiggestSlot = true;
            }
        } while (emptyBiggestSlot);
        this.balanceCraftingMatrix();
    }

    public boolean func_75140_a(EntityPlayer player, int id) {
        switch (id) {
            case 40: {
                this.clearCraftingMatrix();
                return true;
            }
            case 41: {
                this.rotateCraftingMatrix(true);
                return true;
            }
            case 42: {
                this.rotateCraftingMatrix(false);
                return true;
            }
            case 43: {
                this.balanceCraftingMatrix();
                return true;
            }
            case 44: {
                this.spreadCraftingMatrix();
                return true;
            }
        }
        return super.func_75140_a(player, id);
    }
}

