/**
 * @type {[
 *   barrel_id: string,
 *   biome_tag: string,
 *   pools: [
 *     pool_name: string,
 *     weight: number,
 *     entries: [itemID: string, weight: number, [min: number, max: number]]
 *   ]
 * ]}
 */
const loot = [
  {
    barrel_id: "ftbstuff:blocks/white_barrel",
    biome_tag: "#ftb:below_ocean",
    pools: [
      {
        pool_name: "below_the_waves",
        weight: 70,
        entries: [
          ["justdirethings:upgrade_lawnmower", 5, [1, 1]],
          ["ironchest:gold_to_diamond_chest_upgrade", 7, [1, 1]],
          ["functionalstorage:gold_upgrade", 9, [1, 1]],
          ["minecraft:wind_charge", 5, [1, 1]],
          ["functionalstorage:diamond_upgrade", 7, [1, 1]],
          ["justdirethings:upgrade_treefeller", 8, [1, 1]],
          ["bhc:red_heart_canister", 9, [1, 1]],
          ["pneumaticcraft:speed_upgrade", 6, [1, 1]],
          ["sophisticatedbackpacks:crafting_upgrade", 5, [1, 1]],
          ["sophisticatedbackpacks:feeding_upgrade", 5, [1, 1]],
          ["sophisticatedbackpacks:smithing_upgrade", 4, [1, 1]],
          ["sophisticatedbackpacks:void_upgrade", 6, [1, 1]],
          ["sophisticatedbackpacks:advanced_compacting_upgrade", 6, [1, 1]],
          [
            'compactmachines:new_machine[compactmachines:machine_color="#43D6CD",compactmachines:room_template="compactmachines:giant"]',
            5,
            [1, 1],
          ],
          ["enderio:conduit_facade", 4, [1, 1]],
          ["enderio:extraction_speed_upgrade_1", 6, [1, 1]],
          ["mysticalagriculture:inferium_fishing_rod", 5, [1, 1]],
          ["mysticalagriculture:inferium_farmland", 6, [1, 1]],
          ["mysticalagriculture:inferium_essence", 8, [4, 8]],
          ["minecraft:slime_ball", 3, [1, 1]],
          ["cataclysm:sticky_gloves", 4, [1, 1]],
          ["enderio:impulse_hopper", 5, [1, 1]],
          ["farmersdelight:rice", 4, [1, 1]],
          ["constructionstick:iron_stick", 3, [1, 1]],
        ],
      },
    ],
  },
  {
    barrel_id: "ftbstuff:blocks/white_barrel",
    biome_tag: "#ftb:above_ocean",
    pools: [
      {
        pool_name: "rafts",
        weight: 70,
        entries: [
          ["framedblocks:framed_screwdriver", 5, [1, 1]],
          ["immersiveengineering:ersatz_leather", 5, [1, 1]],
          ["immersiveengineering:hammer", 7, [1, 1]],
          ["immersiveengineering:wirecutter", 5, [1, 1]],
          ["immersiveengineering:revolver", 5, [1, 1]],
          ["obsidianboat:obsidian_boat", 5, [1, 1]],
          ["immersiveengineering:bullet_armor_piercing", 6, [1, 1]],
          ["immersiveengineering:wirecoil_structure_steel", 5, [1, 1]],
          ["immersiveengineering:skyhook", 4, [1, 1]],
          ["immersiveengineering:earmuffs", 3, [1, 1]],
          ["ars_nouveau:source_berry_roll", 5, [1, 1]],
          ["minecraft:ominous_bottle[ominous_bottle_amplifier=1]", 6, [1, 1]],
          ["minecraft:experience_bottle", 10, [3, 4]],
          ["supplementaries:jar", 5, [1, 1]],
          ["pneumaticcraft:drill_bit_compressed_iron", 5, [1, 1]],
          ["ftb:kelp_goo", 10, [2, 3]],
          ["integrateddynamics:crystalized_menril_chunk", 8, [4, 6]],
          ["minecraft:oak_log", 13, [4, 8]],
        ],
      },
    ],
  },
  {
    barrel_id: "ftbstuff:blocks/crate",
    biome_tag: "#ftb:above_ocean",
    pools: [
      {
        pool_name: "rafts",
        weight: 10,
        entries: [
          ["sushigocrafting:tobiko_crab_cheese_california", 4, [1, 1]],
          ["sushigocrafting:crab_maki", 4, [1, 1]],
          ["sushigocrafting:salmon_gunkan", 4, [1, 1]],
          ["sushigocrafting:cutting_board", 3, [1, 1]],
          ["sushigocrafting:roller", 3, [1, 1]],
          ["sushigocrafting:sesame_seeds", 6, [2, 3]],
          ["sushigocrafting:wasabi_root", 6, [2, 3]],
          ["sushigocrafting:soy_bean", 6, [2, 3]],
          ["sushigocrafting:soy_seeds", 5, [2, 4]],
          ["minecraft:kelp", 6, [2, 4]],
          ["minecraft:carrot", 3, [1, 1]],
          ["minecraft:bamboo", 7, [4, 8]],
          ["minecraft:dirt", 3, [1, 4]],
          ["minecraft:potato", 3, [1, 1]],
          ["minecraft:flint", 7, [4, 8]],
          ["minecraft:stick", 6, [3, 8]],
          ["minecraft:leather", 5, [3, 4]],
          ["minecraft:string", 6, [3, 6]],
          ["sophisticatedbackpacks:jukebox_upgrade", 3, [1, 1]],
          ["minecraft:potato", 7, [4, 8]],
          ["jags:grass_seed", 4, [1, 2]],
          ["actuallyadditions:canola_seeds", 6, [2, 3]],
          ["minecraft:prismarine_crystals", 3, [1, 1]],
          ["minecraft:prismarine_shard", 3, [1, 1]],
          ["justdirethings:coal_t1", 3, [1, 1]],
          ["mysticalagriculture:dirt_seeds", 3, [1, 1]],
          [createEnchantedBookString("lure", 1), 3, [1, 1]],
          [createEnchantedBookString("lure", 2), 2, [1, 1]],
          [createEnchantedBookString("lure", 3), 1, [1, 1]],
          [createEnchantedBookString("luck_of_the_sea", 1), 3, [1, 1]],
          [createEnchantedBookString("luck_of_the_sea", 2), 2, [1, 1]],
          [createEnchantedBookString("luck_of_the_sea", 3), 1, [1, 1]],
          ['minecraft:potion[potion_contents={potion:"minecraft:luck"}]', 5, [1, 1]],
          ["mysticalagriculture:fish_seeds", 5, [1, 1]],
          ["sushigocrafting:cucumber_seeds", 5, [1, 1]],
        ],
      },
    ],
  },
  {
    barrel_id: "ftbstuff:blocks/crate",
    biome_tag: "#ftb:below_ocean",
    pools: [
      {
        pool_name: "below_the_waves",
        weight: 70,
        entries: [
          ["pneumaticcraft:manometer[pneumaticcraft:air=30000]", 3, [1, 1]],
          ["pneumaticcraft:tube_junction", 3, [1, 1]],
          ["pneumaticcraft:universal_sensor", 3, [1, 1]],
          ["pneumaticcraft:amadron_tablet[pneumaticcraft:air=30000]", 3, [1, 1]],
          ["pneumaticcraft:bandage", 3, [1, 1]],
          ["buildinggadgets2:gadget_destruction[buildinggadgets2:forge_energy=2000000]", 4, [1, 1]],
          ["ae2:cell_component_1k", 4, [1, 1]],
          ["enderio:yeta_wrench", 4, [1, 1]],
          ["enderio:electromagnet[enderio:energy=100000]", 4, [1, 1]],
          ["minecraft:kelp", 6, [4, 8]],
          ["minecraft:carrot", 5, [3, 6]],
          ["minecraft:bamboo", 6, [4, 6]],
          ["minecraft:dirt", 4, [3, 4]],
          ["minecraft:potato", 6, [5, 6]],
          ["minecraft:flint", 5, [4, 7]],
          ["minecraft:stick", 4, [2, 4]],
          ["minecraft:leather", 5, [4, 7]],
          ["minecraft:string", 6, [5, 6]],
          ["mysticalagriculture:inferium_upgrade", 3, [1, 1]],
          ["modularrouters:modular_router", 3, [1, 1]],
          ["modularrouters:breaker_module", 3, [1, 1]],
          ["modularrouters:fluid_module", 3, [1, 1]],
          ["modularrouters:stack_augment", 3, [1, 1]],
          ["modularrouters:fast_pickup_augment", 3, [1, 1]],
          ["modularrouters:range_up_augment", 3, [1, 1]],
          ["laserio:laser_node", 3, [1, 1]],
          ["laserio:overclocker_card", 3, [1, 1]],
          ["laserio:card_item", 3, [1, 1]],
          ["laserio:logic_chip_raw", 3, [1, 1]],
          ["laserio:logic_chip", 3, [1, 1]],
          ["gag:fishing_dynamite", 3, [1, 1]],
          ["justdirethings:coal_t3", 3, [1, 1]],
          ["ae2:fluix_upgrade_smithing_template", 3, [1, 1]],
          [
            'compactmachines:new_machine[compactmachines:room_template="compactmachines:large",compactmachines:machine_color="#211B2E"]',
            3,
            [1, 1],
          ],
          ["pneumaticcraft:logistics_core", 3, [1, 1]],
          ["pneumaticcraft:glycerol", 3, [1, 1]],
          ["pneumaticcraft:transfer_gadget", 3, [1, 1]],
        ],
      },
    ],
  },
  {
    barrel_id: "ftbstuff:blocks/golden_barrel",
    biome_tag: "#ftb:above_ocean",
    pools: [
      {
        pool_name: "rafts",
        weight: 10,
        entries: [
          ["justdirethings:ferricore_chestplate", 2, [1, 1]],
          ["justdirethings:ferricore_boots", 2, [1, 1]],
          ["justdirethings:ferricore_leggings", 2, [1, 1]],
          ["justdirethings:ferricore_helmet", 2, [1, 1]],
          ["minecraft:sea_pickle", 92, [1, 1]],
        ],
      },
    ],
  },
  {
    barrel_id: "ftbstuff:blocks/golden_barrel",
    biome_tag: "#ftb:below_ocean",
    pools: [
      {
        pool_name: "below_the_waves",
        weight: 10,
        entries: [
          ["laserio:laser_node", 5, [1, 1]],
          ["laserio:card_item", 5, [1, 1]],
          ["laserio:card_fluid", 4, [1, 1]],
          ["laserio:card_energy", 4, [1, 1]],
          ["laserio:card_redstone", 4, [1, 1]],
          ["laserio:overclocker_card", 5, [1, 1]],
          ["laserio:laser_wrench", 3, [1, 1]],
          ["simplylight:illuminant_block_on", 3, [1, 1]],
          ["simplylight:illuminant_slab", 3, [1, 1]],
          ["enderio:octadic_capacitor", 3, [1, 1]],
          ["enderio:double_layer_capacitor", 3, [1, 1]],
          ["enderstorage:ender_chest", 4, [1, 1]],
          ["constructionstick:diamond_stick", 3, [1, 1]],
          ["constructionstick:template_angel", 3, [1, 1]],
          ["constructionstick:template_battery", 3, [1, 1]],
          ["enderio:extraction_speed_upgrade_2", 3, [1, 1]],
          ["enderio:experience_rod", 4, [1, 1]],
          ["functionalstorage:storage_controller", 4, [1, 1]],
          ["enderio:dark_steel_sword", 4, [1, 1]],
          ["enderio:advanced_filter", 3, [1, 1]],
          ["enderio:staff_of_travelling[enderio:energy=100000]", 3, [1, 1]],
        ],
      },
    ],
  },
  {
    barrel_id: "ftbstuff:blocks/green_barrel",
    biome_tag: "#ftb:above_ocean",
    pools: [
      {
        pool_name: "rafts",
        weight: 10,
        entries: [
          ["minecraft:ochre_froglight", 2, [3, 4]],
          ["ftbmaterials:copper_wire", 8, [3, 4]],
          ["rainshield:rain_shield", 1, [1, 1]],
          ["trashcans:liquid_trash_can", 1, [1, 1]],
          ["chipped:chisel", 2, [1, 1]],
          ["utilitarian:redstone_clock", 3, [1, 1]],
          ["pickletweaks:flint_pickaxe", 3, [1, 1]],
          ["xtonesreworked:xtone_tile", 3, [6, 8]],
          ["simplemagnets:advancedmagnet", 1, [1, 1]],
          ["rechiseled:chisel", 2, [1, 1]],
          ["trashcans:item_trash_can", 1, [1, 1]],
          ["minecraft:verdant_froglight", 2, [3, 4]],
          ["minecraft:green_concrete_powder", 3, [3, 6]],
          ["pickletweaks:flint_hoe", 3, [1, 1]],
          ["minecraft:dirt", 3, [2, 4]],
          ["enderio:clear_glass", 3, [4, 8]],
          ["minecraft:pearlescent_froglight", 2, [3, 4]],
          ["minecraft:waxed_oxidized_copper_door", 2, [1, 1]],
          ["minecraft:green_glazed_terracotta", 3, [6, 8]],
          ["trashcans:energy_trash_can", 1, [1, 1]],
          ["sophisticatedbackpacks:advanced_refill_upgrade", 1, [1, 1]],
          ["sophisticatedbackpacks:advanced_jukebox_upgrade", 1, [1, 1]],
          ["bibliocraft:white_oak_display_case", 3, [1, 1]],
          ["bibliocraft:birch_table", 3, [1, 1]],
          ["bibliocraft:tape_measure", 3, [1, 1]],
          ["hpm:largemast", 2, [1, 1]],
          ["hpm:largehull", 2, [1, 1]],
          ["framedblocks:framed_screwdriver", 3, [1, 1]],
          ["immersiveengineering:ersatz_leather", 3, [1, 1]],
          ["immersiveengineering:hammer", 1, [1, 1]],
          ["immersiveengineering:wirecutter", 1, [1, 1]],
          ["immersiveengineering:revolver", 1, [1, 1]],
          ["immersiveengineering:bullet_armor_piercing", 1, [1, 1]],
          ["immersiveengineering:wirecoil_structure_steel", 1, [6, 10]],
          ["immersiveengineering:skyhook", 1, [1, 1]],
          ["immersiveengineering:earmuffs", 3, [1, 1]],
          ["ars_nouveau:source_berry_roll", 2, [1, 1]],
          ["minecraft:ominous_bottle[ominous_bottle_amplifier=1]", 2, [1, 1]],
          ["minecraft:experience_bottle", 2, [2, 4]],
          ["supplementaries:jar", 3, [1, 1]],
          ["pneumaticcraft:drill_bit_compressed_iron", 3, [1, 1]],
          ["ftb:kelp_goo", 3, [1, 2]],
          ["integrateddynamics:crystalized_menril_chunk", 3, [1, 6]],
          ["minecraft:oak_log", 3, [1, 8]],
        ],
      },
    ],
  },
  {
    barrel_id: "ftbstuff:blocks/green_barrel",
    biome_tag: "#ftb:below_ocean",
    pools: [
      {
        pool_name: "deep_ocean",
        weight: 10,
        entries: [
          ["rftoolspower:dimensionalcell_advanced", 4, [1, 3]],
          ["oceansdelight:cooked_guardian_tail", 3, [1, 2]],
          ["oceansdelight:guardian_soup", 3, [1, 2]],
          ["oceansdelight:seagrass_salad", 3, [1, 2]],
          ["oceansdelight:cooked_stuffed_cod", 2, [1, 1]],
          ["ftbmaterials:steel_ingot", 5, [8, 12]],
          ["oritech:machine_core_4", 3, [1, 2]],
          ["laserio:overclocker_node", 3, [4, 6]],
          ["laserio:laser_connector_advanced", 2, [1, 2]],
          ["mekanism:upgrade_chemical", 3, [1, 3]],
          ["mekanism:upgrade_muffling", 3, [1, 4]],
          ["mekanism:upgrade_energy", 3, [1, 5]],
          ["mekanism:upgrade_speed", 3, [1, 6]],
          ["mekanism:ingot_refined_glowstone", 2, [1, 4]],
          ["mekanism:ingot_refined_obsidian", 2, [1, 5]],
          ["mekanism:alloy_infused", 3, [1, 3]],
          ['hostilenetworks:data_model[hostilenetworks:data_model="hostilenetworks:elder_guardian"]', 2, [1, 1]],
          ['hostilenetworks:data_model[hostilenetworks:data_model="hostilenetworks:evoker"]', 2, [1, 1]],
          ["mekanism:basic_induction_cell", 3, [4, 8]],
          ["pneumaticcraft:capacitor", 3, [4, 8]],
          ["mekanism:ultimate_bin", 2, [1, 1]],
          ["enderio:octadic_capacitor", 3, [2, 3]],
          ["advanced_ae:adv_pattern_provider_capacity_upgrade", 2, [1, 1]],
          ["enderio:zombie_electrode", 2, [1, 1]],
          ["ftbmaterials:electrum_ingot", 4, [16, 18]],
          ["mysticalagriculture:osmium_seeds", 2, [1, 4]],
          ["mysticalagriculture:pulsating_alloy_seeds", 2, [1, 4]],
          ["mysticalagriculture:uranium_seeds", 2, [1, 4]],
          ["mysticalagriculture:experience_seeds", 2, [1, 4]],
          ["mysticalagriculture:lapis_lazuli_seeds", 2, [1, 4]],
          ["oritech:machine_yield_addon", 3, [1, 2]],
          ["oritech:machine_speed_addon", 3, [1, 2]],
          ["oritech:machine_hunter_addon", 3, [1, 2]],
          ["bigreactors:benitoite_crystal", 3, [3, 4]],
          ["bigreactors:anglesite_crystal", 3, [3, 4]],
          ["bigreactors:reinforced_reactorfuelrod", 3, [3, 3]],
          ["justdirethings:celestigem", 4, [4, 5]],
          ["bigreactors:reinforced_turbinecasing", 4, [6, 8]],
          ["bigreactors:reinforced_turbineglass", 3, [3, 4]],
          ["bigreactors:reinforced_turbinerotorbearing", 3, [2, 3]],
          ["bigreactors:reinforced_reactorcasing", 4, [6, 10]],
          ["bigreactors:reinforced_reactorglass", 4, [3, 8]],
          ["oritech:duratium_ingot", 3, [3, 4]],
          ["oritech:adamant_ingot", 4, [4, 5]],
          ["mekanism:alloy_reinforced", 4, [4, 9]],
          ["minecraft:ender_pearl", 6, [12, 16]],
          ["mekanism:thermal_evaporation_block", 6, [12, 18]],
          ["minecraft:sculk", 6, [16, 32]],
          ["pneumaticcraft:thermostat_module", 2, [1, 1]],
          ["immersiveengineering:thermoelectric_generator", 2, [1, 1]],
          ["enderio:z_logic_controller", 2, [1, 1]],
          ["minecraft:diamond", 5, [8, 12]],
          ["ae2:cell_component_64k", 2, [1, 1]],
          ["rftoolsbase:dimensionalshard", 5, [6, 12]],
          ["minecraft:netherite_ingot", 3, [1, 4]],
          ["irons_jewelry:moonstone", 2, [1, 4]],
          ["irons_jewelry:topaz", 2, [1, 4]],
        ],
      },
    ],
  },
  {
    barrel_id: "ftbstuff:blocks/blue_barrel",
    biome_tag: "#ftb:above_ocean",
    pools: [
      {
        pool_name: "rafts",
        weight: 10,
        entries: [
          ["farmersdelight:stuffed_pumpkin_block", 3, [1, 1]],
          ["farmersdelight:stuffed_potato", 3, [1, 1]],
          ["functionalstorage:gold_upgrade", 2, [1, 1]],
          ["farmersdelight:dumplings", 3, [1, 1]],
          ["functionalstorage:copper_upgrade", 2, [1, 1]],
          ["farmersdelight:roasted_mutton_chops", 3, [1, 1]],
          ["farmersdelight:hamburger", 3, [1, 1]],
          ["bhc:red_heart_canister", 2, [1, 1]],
          ["sophisticatedbackpacks:compacting_upgrade", 3, [1, 1]],
          ["farmersdelight:vegetable_noodles", 3, [1, 1]],
          ["farmersdelight:mutton_wrap", 3, [1, 1]],
          ["ftbstuff:gold_hammer", 2, [1, 1]],
          ["farmersdelight:kelp_roll", 3, [1, 1]],
          ["sophisticatedbackpacks:restock_upgrade", 2, [1, 1]],
          ["ironchest:iron_chest", 3, [1, 1]],
          ["farmersdelight:bacon_sandwich", 3, [1, 1]],
          ["functionalstorage:oak_1", 3, [1, 1]],
          ["pickletweaks:flint_shovel", 2, [1, 1]],
          ["supplementaries:faucet", 3, [1, 1]],
          ["cataclysm:sandstorm_in_a_bottle", 1, [1, 1]],
          ["mysticalagriculture:fire_seeds", 1, [1, 1]],
          ["mysticalagriculture:earth_seeds", 1, [1, 1]],
          ["mysticalagriculture:air_seeds", 1, [1, 1]],
          ["mysticalagriculture:water_seeds", 1, [1, 1]],
          ["farmersdelight:tomato_seeds", 3, [1, 1]],
          ["ars_nouveau:magebloom_crop", 3, [1, 1]],
          ["actuallyadditions:coffee_beans", 3, [1, 1]],
          ["integrateddynamics:cable", 3, [1, 1]],
          ["ftbstuff:compressed_sand_3", 2, [1, 1]],
          ["rusticdelight:chocolate_coffee", 2, [1, 4]],
          ["rusticdelight:honey_coffee", 2, [1, 4]],
          ["rusticdelight:milk_coffee", 2, [1, 4]],
          ["integrateddynamics:menril_log_filled", 2, [1, 1]],
          ["sophisticatedbackpacks:jukebox_upgrade", 3, [1, 1]],
          ["supplementaries:music_disc_heave_ho", 2, [1, 1]],
          ["minecraft:music_disc_mellohi", 2, [1, 1]],
          ["minecraft:music_disc_chirp", 2, [1, 1]],
          ["minecraft:music_disc_otherside", 1, [1, 1]],
          ["ars_nouveau:music_disc_thistle_the_sound_of_glass", 1, [1, 1]],
          ["minecraft:music_disc_relic", 1, [1, 1]],
          ["ars_nouveau:music_disc_aria_biblio", 1, [1, 1]],
          ["minecraft:music_disc_5", 1, [1, 1]],
          ["mekanism:basic_mechanical_pipe", 3, [1, 1]],
          ["mekanism:basic_logistical_transporter", 3, [1, 1]],
          ["mekanism:configurator", 3, [1, 1]],
          ["pneumaticcraft:logistics_configurator[pneumaticcraft:air=30000]", 2, [1, 1]],
          ["mob_grinding_utils:solid_xp_baby", 2, [1, 1]],
          ["oritech:wrench", 3, [1, 1]],
          ["oritech:exo_helmet", 2, [1, 1]],
          ["oritech:fluid_pipe", 3, [1, 1]],
          ["oritech:item_pipe", 3, [1, 1]],
          ["ae2:fluix_axe", 2, [1, 1]],
          ["enderio:pulsating_alloy_nugget", 3, [1, 1]],
          ["pneumaticcraft:compressed_stone", 3, [1, 1]],
          ["ftbstuff:compressed_dirt_3", 3, [1, 1]],
        ],
      },
    ],
  },
  {
    barrel_id: "ftbstuff:blocks/blue_barrel",
    biome_tag: "#ftb:below_ocean",
    pools: [
      {
        pool_name: "deep_ocean",
        weight: 10,
        entries: [
          ["mekanism:advanced_tier_installer", 4, [1, 2]],
          ["mysticalagriculture:tertium_upgrade", 3, [1, 1]],
          ["mysticalagriculture:imperium_upgrade", 3, [1, 1]],
          ["oritech:machine_frame_block", 5, [1, 3]],
          ["mysticalagradditions:tertium_apple", 3, [1, 2]],
          ["oritech:resource_node_platinum", 2, [1, 1]],
          ["ae2:molecular_assembler", 4, [1, 1]],
          ["ae2:export_bus", 5, [1, 2]],
          ["ae2:import_bus", 5, [1, 2]],
          ["mysticalagriculture:emerald_seeds", 2, [1, 1]],
          ["mysticalagriculture:wither_skeleton_seeds", 3, [1, 1]],
          ["mysticalagriculture:platinum_seeds", 2, [1, 1]],
          ["irons_jewelry:peridot", 3, [1, 1]],
          ["mysticalagriculture:end_steel_seeds", 3, [1, 1]],
          ["rftoolsbase:dimensionalshard", 6, [5, 8]],
          ["oritech:machine_core_3", 4, [1, 1]],
          ["oritech:machine_core_4", 4, [1, 1]],
          ["oritech:machine_extender", 3, [1, 1]],
          ["oritech:machine_speed_addon", 3, [1, 3]],
          ["oritech:machine_fluid_addon", 3, [1, 1]],
          ["oritech:machine_yield_addon", 3, [1, 1]],
          ["oritech:machine_efficiency_addon", 3, [1, 1]],
          ["mekanism:teleportation_core", 2, [1, 1]],
          ["mekanism:teleporter_frame", 2, [3, 6]],
          ["minecraft:echo_shard", 6, [4, 8]],
          ["ae2:flawless_budding_quartz", 1, [1, 1]],
          ["minecraft:budding_amethyst", 1, [1, 1]],
          ["mysticalagradditions:prudentium_apple", 3, [1, 1]],
          ["oritech:processing_unit", 2, [1, 1]],
          ["oritech:motor", 2, [1, 3]],
          ["bhc:red_heart_patch", 2, [1, 1]],
          [
            'compactmachines:new_machine[compactmachines:machine_color="#FBF236",compactmachines:room_template="compactmachines:normal"]',
            1,
            [1, 1],
          ],
          ["mekanism:basic_tier_installer", 3, [1, 1]],
          ["mekanism:ultimate_tier_installer", 2, [1, 1]],
          ["mekanism:elite_tier_installer", 2, [1, 1]],
          ["minecraft:sculk", 4, [4, 8]],
          ["minecraft:netherite_ingot", 2, [1, 1]],
          ["irons_jewelry:ruby", 3, [1, 1]],
          ["irons_jewelry:sapphire", 3, [1, 1]],
          ["farmersdelight:honey_glazed_ham_block", 3, [1, 1]],
          ["farmersdelight:bone_broth", 3, [1, 1]],
          ["farmersdelight:squid_ink_pasta", 3, [1, 1]],
          ["farmersdelight:vegetable_noodles", 3, [1, 1]],
          ["mysticalagriculture:diamond_seeds", 2, [1, 1]],
          ["ae2:cell_component_16k", 3, [1, 1]],
          ["minecraft:ender_pearl", 5, [5, 6]],
          ["minecraft:diamond", 5, [2, 4]],
          ["ftbmaterials:platinum_ingot", 3, [2, 4]],
          ["occultism:iesnium_ingot", 2, [3, 6]],
        ],
      },
    ],
  },
  {
    barrel_id: "ftbstuff:blocks/small_crate",
    biome_tag: "#ftb:above_ocean",
    pools: [
      {
        pool_name: "rafts",
        weight: 10,
        entries: [
          ["minecraft:bamboo", 8, [1, 5]],
          ["minecraft:kelp", 7, [1, 6]],
          ["minecraft:carrot", 6, [1, 4]],
          ["minecraft:sugar_cane", 8, [1, 8]],
          ["minecraft:seagrass", 10, [1, 10]],
          ["minecraft:potato", 5, [1, 2]],
          ["minecraft:leather", 6, [3, 4]],
          ["minecraft:gravel", 5, [2, 3]],
          ["minecraft:string", 6, [4, 6]],
          ["minecraft:flint", 6, [3, 6]],
          ["minecraft:cobblestone", 7, [4, 8]],
          ["minecraft:charcoal", 6, [6, 9]],
          ["minecraft:torch", 6, [2, 6]],
          ["minecraft:white_wool", 6, [4, 9]],
          ["minecraft:ink_sac", 6, [3, 5]],
          ["minecraft:sandstone", 6, [4, 8]],
          ["minecraft:suspicious_sand", 3, [1, 1]],
        ],
      },
    ],
  },
  {
    barrel_id: "ftbstuff:blocks/small_crate",
    biome_tag: "#ftb:below_ocean",
    pools: [
      {
        pool_name: "below_the_waves",
        weight: 10,
        entries: [
          ["sushigocrafting:crab_cheese_california", 3, [1, 1]],
          ["minecraft:red_mushroom", 3, [1, 1]],
          ["immersiveengineering:hemp_fiber", 6, [4, 8]],
          ["minecraft:poisonous_potato", 5, [2, 4]],
          ["farmersdelight:wild_potatoes", 5, [2, 5]],
          ["minecraft:spider_eye", 4, [1, 4]],
          ["minecraft:rotten_flesh", 5, [3, 4]],
          ["minecraft:tropical_fish", 6, [3, 4]],
          ["mysticalagriculture:fish_essence", 7, [4, 12]],
          ["minecraft:white_concrete", 6, [6, 12]],
          ["minecraft:kelp", 8, [8, 9]],
          ["ftbmaterials:invar_dust", 4, [1, 2]],
          ["ftbmaterials:bronze_dust", 4, [1, 2]],
          ["minecraft:glowstone_dust", 4, [1, 2]],
          ["minecraft:redstone", 4, [1, 2]],
          ["pneumaticcraft:air_grate_module", 3, [1, 1]],
          ["pneumaticcraft:pressure_gauge_module", 3, [1, 1]],
          ["pneumaticcraft:pressure_tube", 3, [1, 1]],
          ["immersiveengineering:concrete", 7, [12, 16]],
          ["minecraft:black_concrete", 7, [12, 16]],
          ["oceansdelight:seagrass_salad", 3, [1, 1]],
          ["minecraft:turtle_egg", 2, [1, 1]],
          ["farmersdelight:kelp_roll_slice", 3, [1, 1]],
          ["farmersdelight:kelp_roll", 3, [1, 1]],
          ["sushigocrafting:salmon_gunkan", 3, [1, 1]],
          ["occultism:iesnium_pickaxe", 2, [1, 1]],
          ["minecraft:mycelium", 5, [2, 4]],
          ["minecraft:dirt", 7, [6, 12]],
          ["minecraft:bamboo", 8, [8, 12]],
          ["sushigocrafting:avocado", 3, [1, 4]],
          ["sushigocrafting:avocado_sapling", 2, [1, 1]],
          ["sushigocrafting:nori_sheets", 3, [1, 1]],
          ["sushigocrafting:salmon_maki", 3, [1, 1]],
          ["sushigocrafting:salmon_nigiri", 3, [1, 1]],
          ["sushigocrafting:crab_california", 3, [1, 1]],
          ["sushigocrafting:salmon_temaki", 3, [1, 1]],
          ["rusticdelight:cotton_seeds_bag", 3, [1, 1]],
          ["rusticdelight:bell_pepper_seeds_bag", 3, [1, 1]],
          ["ars_nouveau:magebloom_crop", 3, [1, 1]],
          ["mysticalagriculture:coral_seeds", 3, [1, 1]],
          ["mysticalagriculture:amethyst_seeds", 3, [1, 1]],
          ["actuallyadditions:lens", 3, [1, 1]],
          ["minecraft:ender_pearl", 5, [3, 4]],
          ["minecraft:stone", 6, [4, 8]],
          ["minecraft:brown_mushroom", 3, [1, 1]],
          ["minecraft:book", 4, [1, 4]],
          ["mininggadgets:upgrade_fortune_2", 2, [1, 1]],
          ['hostilenetworks:data_model[hostilenetworks:data_model="hostilenetworks:drowned"]', 2, [1, 1]],
          ['hostilenetworks:data_model[hostilenetworks:data_model="hostilenetworks:blaze"]', 2, [1, 1]],
          ["aquatic_frontiers:aquatic_frontiers_theme", 2, [1, 1]],
          ["minecraft:iron_ingot", 5, [4, 8]],
          ["ftbstuff:cast_iron_ingot", 6, [6, 12]],
          ["pneumaticcraft:ingot_iron_compressed", 2, [1, 1]],
          ["minecraft:tnt", 2, [1, 1]],
          ["minecraft:obsidian", 5, [4, 8]],
          ["mysticalagriculture:seed_reprocessor", 2, [1, 1]],
          ["ae2:fluix_crystal", 2, [1, 1]],
          ["ae2:certus_quartz_dust", 6, [12, 14]],
          ["occultism:storage_stabilizer_tier1", 2, [1, 1]],
          ["pocketstorage:psu_2", 2, [1, 1]],
          ['hostilenetworks:data_model[hostilenetworks:data_model="hostilenetworks:glow_squid"]', 2, [1, 1]],
        ],
      },
    ],
  },
  {
    barrel_id: "ftbstuff:blocks/red_barrel",
    biome_tag: "#ftb:nether",
    pools: [
      {
        pool_name: "nether",
        weight: 100,
        entries: [
          ["sophisticatedbackpacks:crafting_upgrade", 5, [1, 1]],
          ["enderstorage:ender_tank", 5, [1, 1]],
          ["sophisticatedbackpacks:feeding_upgrade", 5, [1, 1]],
          ["justdirethings:creaturecatcher", 5, [1, 1]],
          ["mekanism:qio_drive_array", 5, [1, 1]],
          ["enderstorage:ender_chest", 5, [1, 1]],
          ["fulleng:conversion_monitor", 5, [1, 1]],
          ["fulleng:storage_monitor", 5, [1, 1]],
          ["ae2:crafting_accelerator", 5, [1, 1]],
          ["minecraft:basalt", 7, [16, 24]],
          ["minecraft:chiseled_quartz_block", 6, [8, 12]],
          ["minecraft:crying_obsidian", 6, [12, 18]],
          ["minecraft:netherrack", 9, [24, 32]],
          ["minecraft:soul_sand", 7, [12, 18]],
          ["minecraft:sponge", 4, [3, 5]],
          ["sophisticatedbackpacks:void_upgrade", 4, [1, 1]],
          ["minecraft:soul_soil", 7, [12, 18]],
          ["minecraft:magma_block", 5, [4, 8]],
          ["constructionstick:netherite_stick", 3, [1, 1]],
          ["immersiveengineering:furnace_heater", 3, [1, 1]],
          ["mysticalagriculture:prudentium_farmland", 3, [1, 1]],
          ["justdirethings:goosoil_tier2", 3, [1, 1]],
          ["mekanism:advanced_fluid_tank", 3, [1, 1]],
          ["oritech:machine_core_2", 3, [1, 1]],
          ["ae2:sky_stone_block", 3, [1, 1]],
          ["minecraft:diamond_block", 2, [1, 1]],
          ["minecraft:emerald_block", 2, [1, 1]],
          ["replication:replica_block", 2, [1, 1]],
          ["minecraft:redstone_block", 6, [3, 4]],
          ["justdirethings:ferricore_block", 3, [1, 1]],
          ["mysticalagriculture:inferium_block", 3, [1, 1]],
          ["occultism:raw_iesnium_block", 3, [1, 1]],
          ["pneumaticcraft:compressed_iron_block", 3, [1, 1]],
          ["minecraft:netherrack", 8, [4, 8]],
          ["minecraft:blackstone", 8, [12, 16]],
          ["ftbmaterials:dimensional_shard_block", 3, [1, 1]],
        ],
      },
    ],
  },
  {
    barrel_id: "ftbstuff:blocks/purple_barrel",
    biome_tag: "#ftb:nether",
    pools: [
      {
        pool_name: "nether",
        weight: 70,
        entries: [
          ["sophisticatedbackpacks:advanced_void_upgrade", 5, [1, 1]],
          ["modularrouters:modular_router", 5, [1, 1]],
          ["starbunclemania:source_fluid_bucket", 5, [1, 1]],
          ["bhc:yellow_heart_canister", 5, [1, 1]],
          ["occultism:iesnium_ingot", 5, [1, 1]],
          ["enderio:dark_steel_ingot", 5, [1, 1]],
          ["minecraft:soul_lantern", 4, [1, 1]],
          ["minecraft:chain", 4, [1, 2]],
          ["minecraft:gold_ingot", 4, [1, 4]],
          ["bhc:wither_bone", 4, [1, 1]],
          ["minecraft:enchanted_golden_apple", 2, [1, 1]],
          ["minecraft:golden_apple", 3, [1, 1]],
          ["functionalstorage:diamond_upgrade", 4, [1, 1]],
          ["minecraft:ender_pearl", 4, [2, 3]],
          ["mysticalagriculture:wither_skeleton_essence", 4, [1, 1]],
          ["minecraft:nether_wart", 4, [4, 8]],
          ["minecraft:nether_brick", 4, [12, 18]],
          ["mysticalagriculture:nether_essence", 4, [15, 16]],
          ["mysticalagriculture:nether_quartz_essence", 4, [8, 12]],
          ["ftbstuff:netherite_auto_hammer", 3, [1, 1]],
          ["rftoolsbase:dimensionalshard", 3, [1, 1]],
          ["minecraft:diamond", 3, [1, 1]],
          ["fluxnetworks:flux_dust", 4, [4, 8]],
          ["minecraft:crimson_fungus", 3, [1, 1]],
          ["minecraft:warped_fungus", 3, [1, 1]],
          ["pneumaticcraft:flippers_upgrade", 3, [1, 1]],
          ["enderio:extraction_speed_upgrade_3", 3, [1, 1]],
          ["constructionstick:template_unbreakable", 3, [1, 1]],
          ["enderio:basic_capacitor", 3, [1, 1]],
          ["minecraft:flint_and_steel", 3, [1, 1]],
          ["sophisticatedbackpacks:advanced_magnet_upgrade", 3, [1, 1]], //
          ["minecraft:blaze_rod", 3, [1, 1]],
          ["actuallyadditions:black_quartz", 2, [1, 1]],
          ["ftbstuff:netherite_hammer", 2, [1, 1]],
          ["minecraft:ender_eye", 2, [1, 1]],
          ["enderstorage:ender_pouch", 2, [1, 1]],
          ["irons_jewelry:garnet", 2, [1, 1]],
          ["irons_jewelry:onyx", 2, [1, 1]],
          ["irons_jewelry:ruby", 2, [1, 1]],
          ["irons_jewelry:sapphire", 2, [1, 1]],
          ["irons_jewelry:topaz", 2, [1, 1]],
          ["irons_jewelry:moonstone", 2, [1, 1]],
          ["irons_jewelry:peridot", 2, [1, 1]],
          ["ftbmaterials:steel_ingot", 2, [1, 1]],
          ["ftbstuff:netherite_cobblestone_generator", 2, [1, 1]],
          ["mysticalagriculture:tertium_farmland", 2, [1, 1]],
          ["mob_grinding_utils:rotten_egg", 2, [1, 1]],
          ["minecraft:ghast_tear", 2, [1, 1]],
          ["mekanism:qio_drive_base", 2, [1, 1]],
        ],
      },
    ],
  },
  {
    barrel_id: "ftbstuff:blocks/black_barrel",
    biome_tag: "#ftb:rift",
    pools: [
      {
        pool_name: "the_rift",
        weight: 50,
        entries: [
          ["cataclysm:amethyst_crab_shell", 40, [2, 4]],
          ["cataclysm:blessed_amethyst_crab_meat", 40, [2, 4]],
          ["cataclysm:amethyst_crab_meat", 40, [2, 4]],
          ["cataclysm:ancient_metal_ingot", 30, [2, 4]],
          ["cataclysm:witherite_ingot", 30, [2, 4]],
          ["minecraft:ender_eye", 35, [8, 16]],
          ["cataclysm:koboleton_bone", 35, [4, 5]],
          ["bigreactors:reinforced_reactorglass", 25, [6, 8]],
          ["bigreactors:reinforced_reactorfuelrod", 25, [6, 8]],
          ["minecraft:experience_bottle", 50, [5, 12]],
          ["justdirethings:time_crystal", 60, [3, 4]],
          ["justdirethings:portal_fluid_catalyst", 20, [4, 5]],
          ["justdirethings:celestigem", 20, [3, 5]],
          ["ftbmaterials:platinum_ingot", 25, [3, 5]],
          ["minecraft:ender_pearl", 35, [6, 8]],
          ["justdirethings:ferricore_ingot", 20, [12, 24]],
          ["justdirethings:blazegold_ingot", 20, [8, 16]],
          ["irons_jewelry:onyx", 15, [1, 5]],
          ["irons_jewelry:ruby", 15, [1, 5]],
          ["irons_jewelry:sapphire", 15, [1, 5]],
          ["irons_jewelry:garnet", 15, [1, 5]],
          ["irons_jewelry:peridot", 15, [1, 5]],
          ["justdirethings:goosoil_tier4", 10, [1, 2]],
          ["powah:ender_core", 15, [3, 5]],
          ["enderio:ender_resonator", 15, [3, 4]],
          ["mekanism:elite_control_circuit", 15, [2, 3]],
          ["mekanism:advanced_control_circuit", 15, [2, 4]],
          ["justdirethings:upgrade_nightvision", 10, [1, 1]],
          ["justdirethings:upgrade_swimspeed", 10, [1, 1]],
          ["justdirethings:upgrade_waterbreathing", 10, [1, 1]],
          ["justdirethings:upgrade_deathprotection", 10, [1, 1]],
          ["mekanism:advanced_tier_installer", 15, [2, 3]],
          ["mekanism:basic_tier_installer", 15, [3, 5]],
          ["mekanism:upgrade_energy", 10, [6, 12]],
          ["mekanism:upgrade_speed", 10, [4, 8]],
          ["oritech:adamant_ingot", 10, [4, 5]],
          ["mininggadgets:upgrade_battery_3", 10, [1, 1]],
          ["mininggadgets:upgrade_range_3", 10, [1, 1]],
          ["mininggadgets:upgrade_efficiency_5", 10, [1, 1]],
          ["ftbstuff:creative_subzero_temperature_source", 5, [1, 1]],
          ["ftbstuff:creative_high_temperature_source", 5, [1, 1]],
          ["mekanism:pellet_antimatter", 5, [1, 3]],
          ["cataclysm:black_steel_ingot", 10, [1, 3]],
          ["cataclysm:ignitium_ingot", 10, [1, 4]],
          ["cataclysm:cursium_ingot", 10, [1, 4]],
          ["cataclysm:music_disc_maledictus", 5, [1, 1]],
          ["cataclysm:music_disc_ancient_remnant", 5, [1, 1]],
          ["cataclysm:music_disc_the_leviathan", 5, [1, 1]],
          ["cataclysm:abyss_eye", 5, [1, 1]],
          ["mysticalagriculture:tertium_essence", 10, [6, 8]],
          ["mysticalagriculture:imperium_essence", 10, [10, 12]],
          ["ars_nouveau:ring_of_lesser_discount", 5, [1, 1]],
          ["ars_nouveau:jump_ring", 5, [1, 1]],
          ["minecraft:shulker_box", 10, [1, 2]],
          ["enderio:end_steel_ingot", 10, [1, 4]],
          ["sophisticatedbackpacks:stack_upgrade_tier_2", 5, [1, 1]],
          ["mysticalagriculture:imperium_upgrade", 5, [1, 1]],
          ["mysticalagriculture:supremium_upgrade", 5, [1, 1]],
          ["functionalstorage:netherite_upgrade", 5, [1, 1]],
          ["minecraft:dragon_breath", 5, [3, 5]],
          ["ae2:engineering_processor", 5, [6, 7]],
          ["ae2:calculation_processor", 5, [5, 6]],
          ["ae2:logic_processor", 5, [5, 6]],
          ["mininggadgets:upgrade_size_3", 5, [1, 1]],
          ["oritech:flux_gate", 5, [1, 1]],
          ["oritech:processing_unit", 5, [1, 1]],
          ["oritech:banana", 5, [1, 1]],
          ["oritech:machine_core_5", 5, [1, 1]],
          ["cataclysm:crystallized_coral", 5, [1, 1]],
          ["minecraft:elytra", 5, [1, 1]],
          ["mininggadgets:upgrade_fortune_3", 5, [1, 1]],
          ["cataclysm:music_disc_ender_guardian", 5, [1, 1]],
          ["cataclysm:music_disc_netherite_monstrosity", 5, [1, 1]],
          ["cataclysm:music_disc_the_harbinger", 5, [1, 1]],
          ["irons_jewelry:moonstone", 5, [1, 1]],
          ["cataclysm:coral_chunk", 5, [1, 1]],
          ["cataclysm:abyssal_sacrifice", 5, [1, 1]],
          ["cataclysm:void_core", 5, [1, 1]],
          ["mekanism:electrolytic_core", 5, [1, 1]],
          ["minecraft:netherite_ingot", 5, [5, 7]],
          ["cataclysm:music_disc_ignis", 5, [1, 1]],
          ['minecraft:potion[potion_contents={potion:"apothic_attributes:extra_long_flying"}]', 5, [1, 1]],
        ],
      },
    ],
  },
  {
    barrel_id: "ftbstuff:blocks/pulsating_crate",
    biome_tag: "#ftb:rift",
    pools: [
      {
        pool_name: "the_rift",
        weight: 50,
        entries: [
          ["minecraft:shulker_shell", 20, [5, 8]],
          ["mysticalagriculture:haste_iii_augment", 5, [1, 1]],
          ["oritech:dubios_container", 25, [1, 1]],
          ["megacells:cell_component_16m", 10, [1, 1]],
          ["oritech:machine_core_7", 15, [1, 1]],
          ["ae2:creative_energy_cell", 3, [1, 1]],
          ["oritech:uranium_gem", 20, [1, 1]],
          ["mysticalagriculture:awakened_supremium_upgrade", 10, [1, 1]],
          ["ars_nouveau:creative_source_jar", 5, [1, 1]],
          ["minecraft:nether_star", 50, [3, 4]],
          ["ars_nouveau:source_gem", 40, [1, 1]],
          ["ars_nouveau:ring_of_greater_discount", 15, [1, 1]],
          ["cataclysm:cursium_ingot", 8, [1, 1]],
          ["mysticalagriculture:creative_soulium_dagger", 2, [1, 1]],
          ["powah:magmator_nitro", 10, [1, 1]],
          ["minecraft:dragon_egg", 10, [1, 1]],
          ["extendedcrafting:ender_alternator", 12, [1, 1]],
          ["ars_nouveau:amulet_of_mana_boost", 18, [1, 1]],
          ["mysticalagriculture:cyanite_seeds", 22, [1, 1]],
          ["ars_nouveau:shapers_focus", 20, [1, 1]],
          ["mysticalagriculture:health_boost_v_augment", 8, [1, 1]],
          ["mysticalagriculture:imperium_essence", 15, [1, 1]],
          ["mininggadgets:upgrade_battery_creative", 3, [1, 1]],
          ["oritech:super_ai_chip", 8, [1, 1]],
          ["cataclysm:ignitium_ingot", 10, [1, 1]],
          ["mysticalagriculture:supremium_axe", 12, [1, 1]],
          ["ars_nouveau:amulet_of_mana_regen", 15, [1, 1]],
          ["occultism:afrit_essence", 10, [2, 6]],
          ["enderio:sentient_ender", 18, [2, 3]],
          ["mekanism:teleportation_core", 14, [4, 8]],
          ["mysticalagriculture:supremium_essence", 15, [1, 1]],
          ["mysticalagriculture:attack_aoe_iii_augment", 10, [1, 1]],
          ["constructionstick:template_unbreakable", 5, [1, 1]],
          ["mysticalagriculture:supremium_bow", 8, [1, 1]],
          ["mekanism:ultimate_tier_installer", 7, [1, 1]],
          ["occultism:satchel", 18, [1, 1]],
          ["mysticalagriculture:supremium_pickaxe", 10, [1, 1]],
          ["megacells:cell_component_1m", 20, [1, 1]],
          ["mysticalagriculture:luck_iii_augment", 12, [1, 1]],
          ["justdirethings:eclipsealloy_ingot", 6, [4, 6]],
          ["bigreactors:reinforced_turbinecreativesteamgenerator", 5, [1, 1]],
          ["cataclysm:blessed_amethyst_crab_meat", 5, [1, 1]],
          ["mekanism:elite_tier_installer", 12, [1, 1]],
          ["mysticalagriculture:end_steel_seeds", 20, [2, 4]],
          ["mysticalagriculture:mining_aoe_iv_augment", 7, [1, 1]],
          ["megacells:bulk_cell_component", 15, [1, 1]],
          ["powah:thermo_generator_nitro", 8, [1, 1]],
          ["mysticalagriculture:supremium_shovel", 10, [1, 1]],
          ["bhc:blue_heart_canister", 20, [1, 1]],
          ["mysticalagriculture:platinum_seeds", 15, [2, 3]],
          ["mysticalagriculture:wither_resistance_augment", 10, [1, 1]],
          ["minecraft:ender_eye", 30, [4, 8]],
          ["ars_nouveau:creative_spell_book", 3, [1, 1]],
          ["oritech:duratium_ingot", 18, [1, 1]],
          ["oritech:big_solar_panel_block", 12, [1, 1]],
          ["mysticalagriculture:vibrant_alloy_seeds", 10, [1, 1]],
          ["oritech:prometheum_ingot", 12, [1, 1]],
          ["enderio:vibrant_photovoltaic_module", 8, [1, 1]],
          ["cataclysm:netherite_effigy", 4, [1, 1]],
          ["powah:furnator_nitro", 10, [1, 1]],
          ["bigreactors:reinforced_reactorcreativewatergenerator", 2, [1, 1]],
          ["mysticalagriculture:strength_iii_augment", 14, [1, 1]],
          ["cataclysm:remnant_skull", 8, [1, 1]],
          ["cataclysm:ancient_metal_ingot", 6, [1, 1]],
          ["mysticalagriculture:supremium_sword", 10, [1, 1]],
          ["justdirethings:totem_of_death_recall", 4, [1, 1]],
          ["minecraft:ender_pearl", 35, [6, 9]],
          ["cataclysm:abyssal_egg", 10, [1, 1]],
          ["mysticalagriculture:nether_star_seeds", 8, [1, 1]],
          ["mekanism:ultimate_control_circuit", 10, [2, 3]],
          [
            'hostilenetworks:data_model[hostilenetworks:data_model="hostilenetworks:shulker",hostilenetworks:data=1500]',
            1,
            [1, 1],
          ],
          ["justdirethings:time_wand[justdirethings:forge_energy=100000]", 5, [1, 1]],
        ],
      },
    ],
  },
];

LootJS.lootTables((event) => {
  loot.forEach((barrelType) => {
    const { barrel_id, pools, biome_tag } = barrelType;

    pools.forEach((pool) => {
      const { pool_name, entries } = pool;

      event.create(`${barrel_id}_${pool_name}_${biome_tag.split(":")[1]}`).createPool((poolName) => {
        entries.forEach(([itemID, entryWeight, [min, max]]) => {
          // console.log("Adding loot entry" + itemID, entryWeight, min, max);
          poolName
            .addEntry(LootEntry.of(itemID).setCount([min, max]).withWeight(entryWeight))
            .name(capitalizeAndReplaceUnderscores(pool.pool_name));
        });
      });
    });

    event.getLootTable(barrel_id).createPool((poolName) => {
      pools.forEach((pool) => {
        poolName.addEntry(
          LootEntry.reference(`${barrel_id}_${pool.pool_name}_${biome_tag.split(":")[1]}`)
            .withWeight(pool.weight)
            .matchBiome(biome_tag)
        );
        poolName.rolls([1, 2]);
        poolName.name(capitalizeAndReplaceUnderscores(pool.pool_name));
      });
    });
  });
});
