/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.tile;

import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.HostileConfig;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.DataModelInstance;
import dev.shadowsoffire.hostilenetworks.data.DataModelRegistry;
import dev.shadowsoffire.hostilenetworks.data.ModelTier;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.placebo.block_entity.TickingBlockEntity;
import dev.shadowsoffire.placebo.cap.InternalItemHandler;
import dev.shadowsoffire.placebo.cap.ModifiableEnergyStorage;
import dev.shadowsoffire.placebo.menu.SimpleDataSlots;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class SimChamberTileEntity
extends BlockEntity
implements TickingBlockEntity,
SimpleDataSlots.IDataAutoRegister {
    protected final SimItemHandler inventory = new SimItemHandler();
    protected final ModifiableEnergyStorage energy = new ModifiableEnergyStorage(HostileConfig.simPowerCap, HostileConfig.simPowerCap);
    protected final SimpleDataSlots data = new SimpleDataSlots();
    protected DataModelInstance currentModel = DataModelInstance.EMPTY;
    protected int runtime = 0;
    protected int predictionSuccess = 0;
    protected FailureState failState = FailureState.NONE;
    protected RedstoneState redstoneState = RedstoneState.IGNORED;

    public SimChamberTileEntity(BlockPos pos, BlockState state) {
        super(Hostile.TileEntities.SIM_CHAMBER, pos, state);
        this.data.addData(() -> this.runtime, v -> {
            this.runtime = v;
        });
        this.data.addData(() -> this.predictionSuccess, v -> {
            this.predictionSuccess = v;
        });
        this.data.addData(() -> this.failState.ordinal(), v -> {
            this.failState = FailureState.values()[v];
        });
        this.data.addData(() -> this.redstoneState.ordinal(), v -> {
            this.redstoneState = RedstoneState.values()[v];
        });
        this.data.addEnergy(this.energy);
    }

    public void registerSlots(Consumer<DataSlot> consumer) {
        this.data.register(consumer);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider regs) {
        super.saveAdditional(tag, regs);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(regs));
        tag.putInt("energy", this.energy.getEnergyStored());
        tag.putString("model", !this.currentModel.isValid() ? "null" : DataModelRegistry.INSTANCE.getKey(this.currentModel.getModel()).toString());
        tag.putInt("runtime", this.runtime);
        tag.putInt("predSuccess", this.predictionSuccess);
        tag.putInt("failState", this.failState.ordinal());
        tag.putInt("redstoneState", this.redstoneState.ordinal());
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider regs) {
        super.loadAdditional(tag, regs);
        this.inventory.deserializeNBT(regs, tag.getCompound("inventory"));
        this.energy.setEnergy(tag.getInt("energy"));
        ItemStack model = this.inventory.getStackInSlot(0);
        DataModelInstance cModel = this.getOrLoadModel(model);
        ResourceLocation modelId = ResourceLocation.parse((String)tag.getString("model"));
        if (cModel.isValid() && DataModelRegistry.INSTANCE.getKey(cModel.getModel()).equals((Object)modelId)) {
            this.currentModel = cModel;
        }
        this.runtime = tag.getInt("runtime");
        this.predictionSuccess = tag.getInt("predSuccess");
        this.failState = FailureState.values()[tag.getInt("failState")];
        this.redstoneState = RedstoneState.values()[tag.getInt("redstoneState")];
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        ItemStack model = this.inventory.getStackInSlot(0);
        if (!model.isEmpty()) {
            DataModelInstance oldModel = this.currentModel;
            this.currentModel = this.getOrLoadModel(model);
            if (oldModel != this.currentModel) {
                this.runtime = 0;
            }
            if (this.currentModel.isValid()) {
                if (!this.currentModel.getTier().canSim()) {
                    this.failState = FailureState.FAULTY;
                    this.runtime = 0;
                    return;
                }
                if (this.runtime == 0) {
                    if (this.canStartSimulation()) {
                        this.runtime = 300;
                        float accuracy = this.currentModel.getAccuracy();
                        this.predictionSuccess = (int)accuracy + (this.level.random.nextFloat() <= this.currentModel.getAccuracy() % 1.0f ? 1 : 0);
                        this.inventory.getStackInSlot(1).shrink(1);
                        this.setChanged();
                    }
                } else if (this.hasPowerFor(this.currentModel.getModel())) {
                    if (this.getRedstoneState().matches(level.hasNeighborSignal(this.worldPosition))) {
                        this.failState = FailureState.NONE;
                        if (--this.runtime == 0) {
                            ModelTier tier;
                            ItemStack stk = this.inventory.getStackInSlot(2);
                            if (stk.isEmpty()) {
                                this.inventory.setStackInSlot(2, this.currentModel.getModel().baseDrop().copy());
                            } else {
                                stk.grow(1);
                            }
                            if (this.predictionSuccess > 0) {
                                stk = this.inventory.getStackInSlot(3);
                                if (stk.isEmpty()) {
                                    this.inventory.setStackInSlot(3, this.currentModel.getPredictionDrop().copyWithCount(this.predictionSuccess));
                                } else {
                                    stk.grow(this.predictionSuccess);
                                }
                            }
                            if (!(tier = this.currentModel.getTier()).isMax() && HostileConfig.simModelUpgrade > 0) {
                                int newData = this.currentModel.getData() + 1;
                                if (HostileConfig.simModelUpgrade != 2 || newData <= this.currentModel.getNextTierData()) {
                                    this.currentModel.setData(newData);
                                }
                            }
                            DataModelItem.setIters(model, DataModelItem.getIters(model) + 1);
                            this.setChanged();
                        } else if (this.runtime != 0) {
                            this.energy.setEnergy(this.energy.getEnergyStored() - this.currentModel.getModel().simCost());
                            this.setChanged();
                        }
                    } else {
                        this.failState = FailureState.REDSTONE;
                    }
                } else {
                    this.failState = FailureState.ENERGY_MID_CYCLE;
                }
                return;
            }
        }
        this.failState = FailureState.MODEL;
        this.runtime = 0;
    }

    public boolean canStartSimulation() {
        if (!DataModelItem.matchesModelInput(this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1))) {
            this.failState = FailureState.INPUT;
            return false;
        }
        if (!this.redstoneState.matches(this.level.hasNeighborSignal(this.worldPosition))) {
            this.failState = FailureState.REDSTONE;
            return false;
        }
        DataModel model = this.currentModel.getModel();
        ItemStack nOut = this.inventory.getStackInSlot(2);
        ItemStack pOut = this.inventory.getStackInSlot(3);
        ItemStack nOutExp = model.baseDrop();
        ItemStack pOutExp = this.currentModel.getPredictionDrop();
        if (this.canStack(nOut, nOutExp) && this.canStack(pOut, pOutExp)) {
            if (this.hasPowerFor(model)) {
                this.failState = FailureState.NONE;
                return true;
            }
            this.failState = FailureState.ENERGY;
            return false;
        }
        this.failState = FailureState.OUTPUT;
        return false;
    }

    public boolean canStack(ItemStack a, ItemStack b) {
        if (a.isEmpty()) {
            return true;
        }
        return ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b) && a.getCount() < a.getMaxStackSize();
    }

    public boolean hasPowerFor(DataModel model) {
        return this.energy.getEnergyStored() >= model.simCost();
    }

    protected DataModelInstance getOrLoadModel(ItemStack stack) {
        if (this.currentModel.getSourceStack() == stack) {
            return this.currentModel;
        }
        return new DataModelInstance(stack, 0);
    }

    public SimItemHandler getInventory() {
        return this.inventory;
    }

    public IEnergyStorage getEnergy() {
        return this.energy;
    }

    public int getEnergyStored() {
        return this.energy.getEnergyStored();
    }

    public int getRuntime() {
        return this.runtime;
    }

    public boolean didPredictionSucceed() {
        return this.predictionSuccess > 0;
    }

    public FailureState getFailState() {
        return this.failState;
    }

    public void setRedstoneState(RedstoneState state) {
        this.redstoneState = state;
    }

    public RedstoneState getRedstoneState() {
        return this.redstoneState;
    }

    public class SimItemHandler
    extends InternalItemHandler {
        public SimItemHandler() {
            super(4);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return stack.getItem() instanceof DataModelItem;
            }
            if (slot == 1) {
                return DataModelItem.matchesModelInput(this.getStackInSlot(0), stack);
            }
            return true;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot > 1) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot <= 1) {
                return ItemStack.EMPTY;
            }
            return super.extractItem(slot, amount, simulate);
        }

        protected void onContentsChanged(int slot) {
            SimChamberTileEntity.this.setChanged();
        }

        public NonNullList<ItemStack> getItems() {
            return this.stacks;
        }
    }

    public static enum FailureState {
        NONE("none"),
        OUTPUT("output"),
        ENERGY("energy"),
        INPUT("input"),
        MODEL("model"),
        FAULTY("faulty"),
        ENERGY_MID_CYCLE("energy_mid_cycle"),
        REDSTONE("redstone");

        private final String name;

        private FailureState(String name) {
            this.name = name;
        }

        public String getKey() {
            return "hostilenetworks.fail." + this.name;
        }
    }

    public static enum RedstoneState {
        IGNORED("ignored", ResourceLocation.withDefaultNamespace((String)"textures/item/redstone.png")),
        OFF_WHEN_POWERED("off_when_powered", ResourceLocation.withDefaultNamespace((String)"textures/block/redstone_torch_off.png")),
        ON_WHEN_POWERED("on_when_powered", ResourceLocation.withDefaultNamespace((String)"textures/block/redstone_torch.png"));

        private final String name;
        private final ResourceLocation texture;

        private RedstoneState(String name, ResourceLocation texture) {
            this.name = name;
            this.texture = texture;
        }

        public String getKey() {
            return "hostilenetworks.gui.redstone." + this.name;
        }

        public ResourceLocation getResourceLocation() {
            return this.texture;
        }

        public boolean matches(boolean power) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 1 -> {
                    if (!power) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> power;
            };
        }

        public RedstoneState next() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> OFF_WHEN_POWERED;
                case 1 -> ON_WHEN_POWERED;
                case 2 -> IGNORED;
            };
        }
    }
}

