/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.tile;

import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.HostileConfig;
import dev.shadowsoffire.hostilenetworks.data.DataModel;
import dev.shadowsoffire.hostilenetworks.data.DataModelRegistry;
import dev.shadowsoffire.hostilenetworks.item.DataModelItem;
import dev.shadowsoffire.placebo.block_entity.TickingBlockEntity;
import dev.shadowsoffire.placebo.cap.InternalItemHandler;
import dev.shadowsoffire.placebo.cap.ModifiableEnergyStorage;
import dev.shadowsoffire.placebo.menu.SimpleDataSlots;
import dev.shadowsoffire.placebo.network.VanillaPacketDispatcher;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class LootFabTileEntity
extends BlockEntity
implements TickingBlockEntity,
SimpleDataSlots.IDataAutoRegister {
    protected final FabItemHandler inventory = new FabItemHandler();
    protected final ModifiableEnergyStorage energy = new ModifiableEnergyStorage(HostileConfig.fabPowerCap, HostileConfig.fabPowerCap);
    protected final Object2IntMap<DynamicHolder<DataModel>> savedSelections = new Object2IntOpenHashMap();
    protected final SimpleDataSlots data = new SimpleDataSlots();
    protected int runtime = 0;
    protected int currentSel = -1;

    public LootFabTileEntity(BlockPos pos, BlockState state) {
        super(Hostile.TileEntities.LOOT_FABRICATOR, pos, state);
        this.savedSelections.defaultReturnValue(-1);
        this.data.addData(() -> this.runtime, v -> {
            this.runtime = v;
        });
        this.data.addEnergy(this.energy);
    }

    public void registerSlots(Consumer<DataSlot> consumer) {
        this.data.register(consumer);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        DynamicHolder<DataModel> dm = DataModelItem.getStoredModel(this.inventory.getStackInSlot(0));
        if (dm.isBound()) {
            int selection = this.getSelectedDrop((DataModel)dm.get());
            if (this.currentSel != selection) {
                this.currentSel = selection;
                this.runtime = 0;
                return;
            }
            if (selection != -1) {
                if (this.runtime >= 60) {
                    ItemStack out = ((DataModel)dm.get()).fabDrops().get(selection).copy();
                    if (this.insertInOutput(out, true)) {
                        this.runtime = 0;
                        this.insertInOutput(out, false);
                        this.inventory.getStackInSlot(0).shrink(1);
                        this.setChanged();
                    }
                } else {
                    if (this.energy.getEnergyStored() < HostileConfig.fabPowerCost) {
                        return;
                    }
                    this.energy.setEnergy(this.energy.getEnergyStored() - HostileConfig.fabPowerCost);
                    ++this.runtime;
                    this.setChanged();
                }
            } else {
                this.runtime = 0;
            }
        } else {
            this.runtime = 0;
        }
    }

    protected boolean insertInOutput(ItemStack stack, boolean sim) {
        for (int i = 1; i < 17; ++i) {
            if (!(stack = this.inventory.insertItemInternal(i, stack, sim)).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public FabItemHandler getInventory() {
        return this.inventory;
    }

    public IEnergyStorage getEnergy() {
        return this.energy;
    }

    public void setSelection(DynamicHolder<DataModel> model, int selection) {
        if (selection == -1) {
            this.savedSelections.removeInt(model);
        } else {
            this.savedSelections.put(model, Mth.clamp((int)selection, (int)0, (int)(((DataModel)model.get()).fabDrops().size() - 1)));
        }
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((BlockEntity)this);
        this.setChanged();
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider regs) {
        super.saveAdditional(tag, regs);
        tag.put("saved_selections", (Tag)this.writeSelections(new CompoundTag()));
        tag.put("inventory", (Tag)this.inventory.serializeNBT(regs));
        tag.putInt("energy", this.energy.getEnergyStored());
        tag.putInt("runtime", this.runtime);
        tag.putInt("selection", this.currentSel);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider regs) {
        super.loadAdditional(tag, regs);
        this.readSelections(tag.getCompound("saved_selections"));
        this.inventory.deserializeNBT(regs, tag.getCompound("inventory"));
        this.energy.setEnergy(tag.getInt("energy"));
        this.runtime = tag.getInt("runtime");
        this.currentSel = tag.getInt("selection");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, (be, regs) -> ((LootFabTileEntity)((Object)be)).writeSync());
    }

    private CompoundTag writeSync() {
        CompoundTag tag = new CompoundTag();
        tag.put("saved_selections", (Tag)this.writeSelections(new CompoundTag()));
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider regs) {
        this.readSelections(pkt.getTag().getCompound("saved_selections"));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider regs) {
        CompoundTag tag = super.getUpdateTag(regs);
        tag.put("saved_selections", (Tag)this.writeSelections(new CompoundTag()));
        return tag;
    }

    private CompoundTag writeSelections(CompoundTag tag) {
        for (Object2IntMap.Entry e : this.savedSelections.object2IntEntrySet()) {
            tag.putInt(((DynamicHolder)e.getKey()).getId().toString(), e.getIntValue());
        }
        return tag;
    }

    private void readSelections(CompoundTag tag) {
        this.savedSelections.clear();
        for (String s : tag.getAllKeys()) {
            DynamicHolder dm = DataModelRegistry.INSTANCE.holder(ResourceLocation.tryParse((String)s));
            this.savedSelections.put((Object)dm, tag.getInt(s));
        }
    }

    public int getEnergyStored() {
        return this.energy.getEnergyStored();
    }

    public int getRuntime() {
        return this.runtime;
    }

    public int getSelectedDrop(DataModel model) {
        if (model == null) {
            return -1;
        }
        int index = this.savedSelections.getInt((Object)DataModelRegistry.INSTANCE.holder(model));
        if (index >= model.fabDrops().size()) {
            return -1;
        }
        return index;
    }

    public class FabItemHandler
    extends InternalItemHandler {
        public FabItemHandler() {
            super(17);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return stack.is(Hostile.Items.PREDICTION);
            }
            return true;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot > 0) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 0) {
                return ItemStack.EMPTY;
            }
            return super.extractItem(slot, amount, simulate);
        }

        protected void onContentsChanged(int slot) {
            LootFabTileEntity.this.setChanged();
        }

        public NonNullList<ItemStack> getItems() {
            return this.stacks;
        }
    }
}

