/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks;

import dev.shadowsoffire.hostilenetworks.HostileNetworks;
import dev.shadowsoffire.hostilenetworks.client.Offset;
import dev.shadowsoffire.placebo.config.Configuration;
import dev.shadowsoffire.placebo.network.PayloadProvider;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class HostileConfig {
    public static int simPowerCap;
    public static int fabPowerCap;
    public static int fabPowerCost;
    public static boolean rightClickToAttune;
    public static int simModelUpgrade;
    public static boolean killModelUpgrade;
    public static boolean continuousAccuracy;
    public static Offset deepLearnerOffset;

    public static Configuration load() {
        Configuration cfg = new Configuration("hostilenetworks");
        cfg.setTitle("Hostile Networks Config");
        cfg.setComment("All entries in this config file are synced from server to client unless noted otherwise.");
        simPowerCap = cfg.getInt("Sim Chamber Power Cap", "power", 2000000, 1, Integer.MAX_VALUE, "The maximum FE stored in the Simulation Chamber.");
        fabPowerCap = cfg.getInt("Loot Fab Power Cap", "power", 1000000, 1, Integer.MAX_VALUE, "The maximum FE stored in the Loot Fabricator.");
        fabPowerCost = cfg.getInt("Loot Fab Power Cost", "power", 256, 0, Integer.MAX_VALUE, "The FE/t cost of the Loot Fabricator.");
        rightClickToAttune = cfg.getBoolean("Right Click To Attune", "models", true, "If true, right clicking a blank data model on a mob will attune it to that mob. If disabled, you will need to provide players with a way to get attuned models!");
        simModelUpgrade = cfg.getInt("Sim Chamber Upgrades Model", "models", 1, 0, 2, "Whether the Simulation Chamber will upgrade the data on a model. (0 = No, 1 = Yes, 2 = Only up to tier boundaries)");
        killModelUpgrade = cfg.getBoolean("Killing Upgrades Model", "models", true, "Whether killing mobs will upgrade the data on a model. Note: If you disable this, be sure to add a way for players to get non-Faulty models!");
        continuousAccuracy = cfg.getBoolean("Continuous Accuracy", "models", true, "If true, the accuracy of the model increases as it gains progress towards the next tier. If false, always uses the base accuracy of the current tier.");
        cfg.setCategoryComment("client", "Client-only options, not synced");
        deepLearnerOffset = Offset.load("Deep Learner HUD", "client", Offset.AnchorPoint.TOP_LEFT, cfg);
        if (cfg.hasChanged()) {
            cfg.save();
        }
        return cfg;
    }

    record ConfigPayload(int simPowerCap, int fabPowerCap, int fabPowerCost, boolean rightClickAttune, int simModelUpgrade, boolean killModelUpgrade, boolean continuousAccuracy) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<ConfigPayload> TYPE = new CustomPacketPayload.Type(HostileNetworks.loc("config"));
        public static final StreamCodec<RegistryFriendlyByteBuf, ConfigPayload> CODEC = NeoForgeStreamCodecs.composite((StreamCodec)ByteBufCodecs.VAR_INT, ConfigPayload::simPowerCap, (StreamCodec)ByteBufCodecs.VAR_INT, ConfigPayload::fabPowerCap, (StreamCodec)ByteBufCodecs.VAR_INT, ConfigPayload::fabPowerCost, (StreamCodec)ByteBufCodecs.BOOL, ConfigPayload::rightClickAttune, (StreamCodec)ByteBufCodecs.VAR_INT, ConfigPayload::simModelUpgrade, (StreamCodec)ByteBufCodecs.BOOL, ConfigPayload::killModelUpgrade, (StreamCodec)ByteBufCodecs.BOOL, ConfigPayload::continuousAccuracy, ConfigPayload::new);

        public ConfigPayload() {
            this(simPowerCap, fabPowerCap, fabPowerCost, rightClickToAttune, simModelUpgrade, killModelUpgrade, continuousAccuracy);
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static class Provider
        implements PayloadProvider<ConfigPayload> {
            public CustomPacketPayload.Type<ConfigPayload> getType() {
                return TYPE;
            }

            public StreamCodec<? super RegistryFriendlyByteBuf, ConfigPayload> getCodec() {
                return CODEC;
            }

            public void handle(ConfigPayload msg, IPayloadContext ctx) {
                HostileConfig.simPowerCap = msg.simPowerCap;
                HostileConfig.fabPowerCap = msg.fabPowerCap;
                HostileConfig.fabPowerCost = msg.fabPowerCost;
                rightClickToAttune = msg.rightClickAttune;
                HostileConfig.simModelUpgrade = msg.simModelUpgrade;
                HostileConfig.killModelUpgrade = msg.killModelUpgrade;
                HostileConfig.continuousAccuracy = msg.continuousAccuracy;
            }

            public List<ConnectionProtocol> getSupportedProtocols() {
                return List.of(ConnectionProtocol.PLAY);
            }

            public Optional<PacketFlow> getFlow() {
                return Optional.of(PacketFlow.CLIENTBOUND);
            }

            public String getVersion() {
                return "1";
            }
        }
    }
}

