/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.worldgen.chunkgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.config.ServerConfig;
import dev.ftb.mods.ftbteambases.data.definition.BaseDefinitionProvider;
import dev.ftb.mods.ftbteambases.mixin.ChunkGeneratorAccess;
import dev.ftb.mods.ftbteambases.util.DimensionUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterLists;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class VoidChunkGenerator
extends NoiseBasedChunkGenerator
implements BaseDefinitionProvider {
    public static final MapCodec<VoidChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeSource.CODEC.fieldOf("biome_source").forGetter(ChunkGenerator::getBiomeSource), (App)NoiseGeneratorSettings.CODEC.fieldOf("settings").forGetter(NoiseBasedChunkGenerator::generatorSettings), (App)ResourceLocation.CODEC.optionalFieldOf("prebuilt_structure_id", (Object)FTBTeamBases.NO_TEMPLATE_ID).forGetter(VoidChunkGenerator::getBaseDefinitionId)).apply((Applicative)instance, instance.stable(VoidChunkGenerator::new)));
    private final ResourceLocation baseDefinitionId;

    public static VoidChunkGenerator create(RegistryAccess registryAccess, ResourceLocation prebuiltStructureId) {
        Holder.Reference preset = ((HolderLookup.RegistryLookup)registryAccess.lookup(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST).orElseThrow()).getOrThrow(MultiNoiseBiomeSourceParameterLists.OVERWORLD);
        MultiNoiseBiomeSource biomeSource = MultiNoiseBiomeSource.createFromPreset((Holder)preset);
        Holder.Reference settings = registryAccess.registryOrThrow(Registries.NOISE_SETTINGS).getHolderOrThrow(NoiseGeneratorSettings.OVERWORLD);
        VoidChunkGenerator gen = new VoidChunkGenerator((BiomeSource)biomeSource, (Holder<NoiseGeneratorSettings>)settings, prebuiltStructureId);
        if (!((ServerConfig.FeatureGeneration)((Object)ServerConfig.FEATURE_GEN.get())).shouldGenerate(true)) {
            ((ChunkGeneratorAccess)((Object)gen)).setFeaturesPerStep(List::of);
        }
        return gen;
    }

    private VoidChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings, ResourceLocation baseDefinitionId) {
        super(biomeSource, settings);
        this.baseDefinitionId = baseDefinitionId;
    }

    public ChunkGeneratorStructureState createState(HolderLookup<StructureSet> holderLookup, RandomState randomState, long seed) {
        return ChunkGeneratorStructureState.createForFlat((RandomState)randomState, (long)seed, (BiomeSource)this.biomeSource, DimensionUtils.possibleStructures(holderLookup, this.baseDefinitionId));
    }

    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    public void applyCarvers(WorldGenRegion level, long seed, RandomState random, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunk, GenerationStep.Carving step) {
    }

    public void buildSurface(WorldGenRegion level, StructureManager structureManager, RandomState random, ChunkAccess chunk) {
    }

    public void spawnOriginalMobs(WorldGenRegion level) {
    }

    public CompletableFuture<ChunkAccess> fillFromNoise(Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunkAccess) {
        return CompletableFuture.completedFuture(chunkAccess);
    }

    public int getBaseHeight(int x, int z, Heightmap.Types type, LevelHeightAccessor level, RandomState random) {
        return level.getMinBuildHeight();
    }

    public NoiseColumn getBaseColumn(int x, int z, LevelHeightAccessor height, RandomState random) {
        return new NoiseColumn(height.getMinBuildHeight(), new BlockState[0]);
    }

    @Override
    public ResourceLocation getBaseDefinitionId() {
        return this.baseDefinitionId;
    }

    public void applyBiomeDecoration(WorldGenLevel worldGenLevel, ChunkAccess chunkAccess, StructureManager structureManager) {
    }
}

