/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.worldgen.chunkgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.config.ServerConfig;
import dev.ftb.mods.ftbteambases.data.definition.BaseDefinitionProvider;
import dev.ftb.mods.ftbteambases.mixin.ChunkGeneratorAccess;
import dev.ftb.mods.ftbteambases.util.DimensionUtils;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterLists;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class CustomChunkGenerator
extends NoiseBasedChunkGenerator
implements BaseDefinitionProvider {
    public static final MapCodec<CustomChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeSource.CODEC.fieldOf("biome_source").forGetter(gen -> gen.biomeSource), (App)NoiseGeneratorSettings.CODEC.fieldOf("settings").forGetter(NoiseBasedChunkGenerator::generatorSettings), (App)ResourceLocation.CODEC.optionalFieldOf("prebuilt_structure_id", (Object)FTBTeamBases.NO_TEMPLATE_ID).forGetter(CustomChunkGenerator::getBaseDefinitionId)).apply((Applicative)instance, instance.stable(CustomChunkGenerator::new)));
    private final ResourceLocation baseTemplateId;

    public static CustomChunkGenerator create(RegistryAccess registryAccess, ResourceLocation prebuiltStructureId) {
        MultiNoiseBiomeSource biomeSource;
        Registry biomeRegistry = registryAccess.registryOrThrow(Registries.BIOME);
        if (!((String)ServerConfig.SINGLE_BIOME_ID.get()).isEmpty()) {
            ResourceKey biomeKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.parse((String)((String)ServerConfig.SINGLE_BIOME_ID.get())));
            biomeSource = new FixedBiomeSource((Holder)biomeRegistry.getHolderOrThrow(biomeKey));
        } else {
            Holder.Reference preset = ((HolderLookup.RegistryLookup)registryAccess.lookup(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST).orElseThrow()).getOrThrow(MultiNoiseBiomeSourceParameterLists.OVERWORLD);
            biomeSource = MultiNoiseBiomeSource.createFromPreset((Holder)preset);
        }
        ResourceKey noiseSettingsKey = ResourceKey.create((ResourceKey)Registries.NOISE_SETTINGS, (ResourceLocation)ResourceLocation.parse((String)((String)ServerConfig.NOISE_SETTINGS.get())));
        Holder.Reference noiseSettings = registryAccess.registryOrThrow(Registries.NOISE_SETTINGS).getHolderOrThrow(noiseSettingsKey);
        CustomChunkGenerator gen = new CustomChunkGenerator((BiomeSource)biomeSource, (Holder<NoiseGeneratorSettings>)noiseSettings, prebuiltStructureId);
        if (!((ServerConfig.FeatureGeneration)((Object)ServerConfig.FEATURE_GEN.get())).shouldGenerate(false)) {
            ((ChunkGeneratorAccess)((Object)gen)).setFeaturesPerStep(List::of);
        }
        return gen;
    }

    private CustomChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings, ResourceLocation baseTemplateId) {
        super(biomeSource, settings);
        this.baseTemplateId = baseTemplateId;
    }

    @Override
    public ResourceLocation getBaseDefinitionId() {
        return this.baseTemplateId;
    }

    public ChunkGeneratorStructureState createState(HolderLookup<StructureSet> holderLookup, RandomState randomState, long seed) {
        return ChunkGeneratorStructureState.createForFlat((RandomState)randomState, (long)seed, (BiomeSource)this.biomeSource, DimensionUtils.possibleStructures(holderLookup, this.baseTemplateId));
    }

    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }
}

