/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.worldgen.chunkgen;

import com.mojang.serialization.MapCodec;
import dev.architectury.registry.registries.DeferredRegister;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.worldgen.chunkgen.CustomChunkGenerator;
import dev.ftb.mods.ftbteambases.worldgen.chunkgen.VoidChunkGenerator;
import java.util.function.BiFunction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.chunk.ChunkGenerator;

public enum ChunkGenerators {
    MULTI_BIOME_VOID("void", VoidChunkGenerator::create, VoidChunkGenerator.CODEC),
    CUSTOM("custom", CustomChunkGenerator::create, CustomChunkGenerator.CODEC);

    public static final NameMap<ChunkGenerators> NAME_MAP;
    private final ResourceLocation id;
    private final BiFunction<RegistryAccess, ResourceLocation, ChunkGenerator> factory;
    private final MapCodec<? extends ChunkGenerator> codec;

    private ChunkGenerators(String id, BiFunction<RegistryAccess, ResourceLocation, ChunkGenerator> factory, MapCodec<? extends ChunkGenerator> codec) {
        this.id = FTBTeamBases.rl(id);
        this.factory = factory;
        this.codec = codec;
    }

    public static void register(DeferredRegister<MapCodec<? extends ChunkGenerator>> chunkGenerators) {
        for (ChunkGenerators gen : ChunkGenerators.values()) {
            chunkGenerators.register(gen.id, () -> gen.codec);
        }
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public MapCodec<? extends ChunkGenerator> getCodec() {
        return this.codec;
    }

    public ChunkGenerator makeGenerator(RegistryAccess registryAccess, ResourceLocation prebuiltStructureId) {
        return this.factory.apply(registryAccess, prebuiltStructureId);
    }

    static {
        NAME_MAP = NameMap.of((Object)((Object)MULTI_BIOME_VOID), (Object[])ChunkGenerators.values()).create();
    }
}

