/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.util.neoforge;

import com.google.common.collect.Lists;
import com.mojang.serialization.Lifecycle;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.config.ServerConfig;
import dev.ftb.mods.ftbteambases.data.definition.BaseDefinition;
import dev.ftb.mods.ftbteambases.data.definition.PrebuiltStructure;
import dev.ftb.mods.ftbteambases.net.UpdateDimensionsListMessage;
import dev.ftb.mods.ftbteambases.util.neoforge.ReflectionBuddy;
import dev.ftb.mods.ftbteambases.worldgen.chunkgen.ChunkGenerators;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.storage.DerivedLevelData;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.jetbrains.annotations.Nullable;

public class DynamicDimensionManagerImpl {
    private static final RegistrationInfo DIMENSION_REGISTRATION_INFO = new RegistrationInfo(Optional.empty(), Lifecycle.stable());

    public static ServerLevel create(MinecraftServer server, ResourceKey<Level> worldKey, BaseDefinition baseDefinition) {
        Map map = server.forgeGetWorldMap();
        ServerLevel existingLevel = (ServerLevel)map.get(worldKey);
        if (existingLevel != null) {
            return existingLevel;
        }
        RegistryAccess.Frozen registryAccess = server.registryAccess();
        ServerLevel overworld = Objects.requireNonNull(server.getLevel(Level.OVERWORLD));
        ResourceKey dimensionKey = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)worldKey.location());
        ResourceLocation dimensionTypeId = baseDefinition.dimensionSettings().dimensionType().orElse(BaseDefinition.DEFAULT_DIMENSION_TYPE);
        Holder.Reference typeHolder = registryAccess.registryOrThrow(Registries.DIMENSION_TYPE).getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)dimensionTypeId));
        ResourceLocation prebuiltStructureId = baseDefinition.constructionType().prebuilt().map(PrebuiltStructure::startStructure).orElse(FTBTeamBases.NO_TEMPLATE_ID);
        ChunkGenerator chunkGenerator = ((ChunkGenerators)((Object)ServerConfig.CHUNK_GENERATOR.get())).makeGenerator((RegistryAccess)registryAccess, prebuiltStructureId);
        LevelStem dimension = new LevelStem((Holder)typeHolder, chunkGenerator);
        ChunkProgressListener chunkProgressListener = server.progressListenerFactory.create(11);
        Executor executor = server.executor;
        LevelStorageSource.LevelStorageAccess anvilConverter = server.storageSource;
        WorldData worldData = server.getWorldData();
        DerivedLevelData derivedLevelData = new DerivedLevelData(worldData, worldData.overworldData());
        Registry dimensionRegistry = server.registryAccess().registryOrThrow(Registries.LEVEL_STEM);
        if (!(dimensionRegistry instanceof MappedRegistry)) {
            throw new IllegalStateException(String.format("Unable to register dimension %s -- dimension registry not writable", dimensionKey.location()));
        }
        MappedRegistry writableRegistry = (MappedRegistry)dimensionRegistry;
        writableRegistry.unfreeze();
        writableRegistry.register(dimensionKey, (Object)dimension, DIMENSION_REGISTRATION_INFO);
        ServerLevel newLevel = new ServerLevel(server, executor, anvilConverter, (ServerLevelData)derivedLevelData, worldKey, dimension, chunkProgressListener, worldData.isDebugWorld(), overworld.getSeed(), List.of(), false, null);
        overworld.getWorldBorder().addListener((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(newLevel.getWorldBorder()));
        map.put(worldKey, newLevel);
        server.markWorldsDirty();
        NeoForge.EVENT_BUS.post((Event)new LevelEvent.Load((LevelAccessor)newLevel));
        NetworkHelper.sendToAll((MinecraftServer)server, (CustomPacketPayload)new UpdateDimensionsListMessage(List.of(worldKey), true));
        return newLevel;
    }

    public static void destroy_Internal(MinecraftServer server, Set<ResourceKey<Level>> keysToRemove) {
        Registry oldRegistry = server.registryAccess().registryOrThrow(Registries.LEVEL_STEM);
        if (!(oldRegistry instanceof MappedRegistry)) {
            FTBTeamBases.LOGGER.warn("Cannot unload dimensions: dimension registry not an instance of MappedRegistry.");
            return;
        }
        MappedRegistry oldMappedRegistry = (MappedRegistry)oldRegistry;
        LayeredRegistryAccess<RegistryLayer> layeredRegistryAccess = ReflectionBuddy.MinecraftServerAccess.registries.apply(server);
        RegistryAccess.Frozen composite = ReflectionBuddy.LayeredRegistryAccessAccess.composite.apply(layeredRegistryAccess);
        if (!(composite instanceof RegistryAccess.ImmutableRegistryAccess)) {
            FTBTeamBases.LOGGER.warn("Cannot unload dimensions: composite registry not an instance of ImmutableRegistryAccess.");
            return;
        }
        RegistryAccess.ImmutableRegistryAccess immutableRegistryAccess = (RegistryAccess.ImmutableRegistryAccess)composite;
        HashSet<ResourceKey<Level>> removedLevelKeys = new HashSet<ResourceKey<Level>>();
        ServerLevel overworld = server.getLevel(Level.OVERWORLD);
        for (ResourceKey<Level> resourceKey : keysToRemove) {
            ServerLevel removedLevel;
            @Nullable ServerLevel levelToRemove = server.getLevel(resourceKey);
            if (levelToRemove == null || (removedLevel = (ServerLevel)server.forgeGetWorldMap().remove(resourceKey)) == null) continue;
            for (ServerPlayer player : Lists.newArrayList((Iterable)removedLevel.players())) {
                BlockPos destinationPos;
                ServerLevel destinationLevel;
                ResourceKey respawnKey = player.getRespawnDimension();
                if (keysToRemove.contains(respawnKey)) {
                    respawnKey = Level.OVERWORLD;
                    player.setRespawnPosition(respawnKey, null, 0.0f, false, false);
                }
                if (respawnKey == null) {
                    respawnKey = Level.OVERWORLD;
                }
                if ((destinationLevel = server.getLevel(respawnKey)) == null) {
                    destinationLevel = overworld;
                }
                if ((destinationPos = player.getRespawnPosition()) == null) {
                    destinationPos = destinationLevel.getSharedSpawnPos();
                }
                float respawnAngle = player.getRespawnAngle();
                player.teleportTo(destinationLevel, (double)destinationPos.getX(), (double)destinationPos.getY(), (double)destinationPos.getZ(), respawnAngle, 0.0f);
            }
            removedLevel.save(null, false, removedLevel.noSave());
            NeoForge.EVENT_BUS.post((Event)new LevelEvent.Unload((LevelAccessor)removedLevel));
            WorldBorder overworldBorder = overworld.getWorldBorder();
            WorldBorder removedWorldBorder = removedLevel.getWorldBorder();
            List<BorderChangeListener> listeners = ReflectionBuddy.WorldBorderAccess.listeners.apply(overworldBorder);
            BorderChangeListener targetListener = null;
            for (BorderChangeListener listener : listeners) {
                BorderChangeListener.DelegateBorderChangeListener delegate;
                if (!(listener instanceof BorderChangeListener.DelegateBorderChangeListener) || removedWorldBorder != ReflectionBuddy.DelegateBorderChangeListenerAccess.worldBorder.apply(delegate = (BorderChangeListener.DelegateBorderChangeListener)listener)) continue;
                targetListener = listener;
                break;
            }
            if (targetListener != null) {
                overworldBorder.removeListener(targetListener);
            }
            removedLevelKeys.add(resourceKey);
        }
        if (!removedLevelKeys.isEmpty()) {
            MappedRegistry newRegistry = new MappedRegistry(Registries.LEVEL_STEM, oldMappedRegistry.registryLifecycle());
            for (RegistryLayer[] entry : oldRegistry.entrySet()) {
                ResourceKey oldKey = (ResourceKey)entry.getKey();
                ResourceKey oldLevelKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)oldKey.location());
                LevelStem dimension = (LevelStem)entry.getValue();
                if (oldKey == null || dimension == null || removedLevelKeys.contains(oldLevelKey)) continue;
                newRegistry.register(oldKey, (Object)dimension, oldRegistry.registrationInfo(oldKey).orElse(DIMENSION_REGISTRATION_INFO));
            }
            ArrayList<RegistryAccess.Frozen> arrayList = new ArrayList<RegistryAccess.Frozen>();
            for (RegistryLayer layer : RegistryLayer.values()) {
                if (layer == RegistryLayer.DIMENSIONS) {
                    arrayList.add(new RegistryAccess.ImmutableRegistryAccess(List.of(newRegistry)).freeze());
                    continue;
                }
                arrayList.add(layeredRegistryAccess.getLayer((Object)layer));
            }
            HashMap<ResourceKey, Registry> newRegistryMap = new HashMap<ResourceKey, Registry>();
            for (RegistryAccess.Frozen registryAccess : arrayList) {
                List registries = registryAccess.registries().toList();
                for (RegistryAccess.RegistryEntry registryEntry : registries) {
                    newRegistryMap.put(registryEntry.key(), registryEntry.value());
                }
            }
            ReflectionBuddy.LayeredRegistryAccessAccess.values.set(layeredRegistryAccess, List.copyOf(arrayList));
            ReflectionBuddy.ImmutableRegistryAccessAccess.registries.set(immutableRegistryAccess, newRegistryMap);
            server.markWorldsDirty();
            NetworkHelper.sendToAll((MinecraftServer)server, (CustomPacketPayload)new UpdateDimensionsListMessage(List.copyOf(removedLevelKeys), false));
        }
    }
}

