/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.util;

import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.util.BooleanConsumer;
import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.data.construction.RelocatorTracker;
import dev.ftb.mods.ftbteambases.util.RegionCoords;
import dev.ftb.mods.ftbteambases.util.RegionFileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.TickTask;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

public class RegionFileRelocator {
    private static final int MAX_THREADS = 9;
    public static final Path PREGEN_PATH = Path.of("ftbteambases", "pregen");
    private final Map<Path, RelocationData> relocationData = new HashMap<Path, RelocationData>();
    private final CommandSourceStack source;
    private final boolean force;
    private final Path destDir;
    private final RegionStorageInfo storageInfo;
    private final int totalChunks;
    private final AtomicInteger chunkProgress;
    private final UUID relocatorId;
    @Nullable
    private final UUID playerId;
    private boolean started = false;

    public static RegionFileRelocator create(CommandSourceStack source, String templateId, ResourceKey<Level> dimensionKey, RelocatorTracker.Ticker ticker, XZ regionOffset, boolean force) throws IOException {
        return RelocatorTracker.INSTANCE.add(new RegionFileRelocator(source, templateId, dimensionKey, regionOffset, force), ticker);
    }

    public RegionFileRelocator(CommandSourceStack source, String templateId, ResourceKey<Level> dimensionKey, XZ regionOffset, boolean force) throws IOException {
        this.source = source;
        this.force = force;
        Path pregenPath = RegionFileUtil.getPregenPath(templateId, source.getServer(), "region");
        this.destDir = RegionFileUtil.getPathForDimension(source.getServer(), dimensionKey, "region");
        this.storageInfo = new RegionStorageInfo(source.getServer().storageSource.getLevelId(), dimensionKey, "region");
        try (Stream<Path> s = Files.walk(pregenPath, new FileVisitOption[0]).filter(f -> f.getFileName().toString().endsWith(".mca"));){
            s.forEach(file -> RegionFileUtil.getRegionCoords(file).ifPresent(oldRegionPos -> this.relocationData.put((Path)file, new RelocationData((RegionCoords)oldRegionPos, regionOffset))));
        }
        this.totalChunks = this.relocationData.size() * 1024;
        this.chunkProgress = new AtomicInteger(0);
        this.relocatorId = UUID.randomUUID();
        this.playerId = source.getPlayer() == null ? null : source.getPlayer().getUUID();
    }

    public CommandSourceStack getSource() {
        return this.source;
    }

    public UUID getRelocatorId() {
        return this.relocatorId;
    }

    @Nullable
    public UUID getPlayerId() {
        return this.playerId;
    }

    public float getProgress() {
        return this.totalChunks > 0 ? this.chunkProgress.floatValue() / (float)this.totalChunks : 0.0f;
    }

    public boolean isStarted() {
        return this.started;
    }

    public Map<Path, RelocationData> getRelocationData() {
        return this.relocationData;
    }

    public void start(BooleanConsumer onCompleted) {
        if (this.started) {
            throw new IllegalStateException("relocator already started!");
        }
        Path workDir = this.destDir.resolve("worktmp-" + Thread.currentThread().getId());
        try {
            if (!this.force) {
                this.relocationData.values().forEach(data -> {
                    Path destFile = this.destDir.resolve(data.orig.offsetBy(data.regionOffset).filename());
                    if (Files.exists(destFile, new LinkOption[0])) {
                        throw new IllegalStateException("won't overwrite dest MCA file " + String.valueOf(destFile));
                    }
                });
            }
            this.started = true;
            Files.createDirectories(workDir, new FileAttribute[0]);
            FTBTeamBases.LOGGER.debug("created work dir {}", (Object)workDir);
            CompletableFuture.supplyAsync(() -> this.runRelocation(workDir)).thenAccept(result -> {
                FTBTeamBases.LOGGER.debug("finished relocation!");
                try {
                    FileUtils.deleteDirectory((File)workDir.toFile());
                }
                catch (IOException e) {
                    RegionFileRelocator.logError(e, "Can't delete work dir: {}", e.getMessage());
                }
                RelocatorTracker.INSTANCE.remove(this);
                this.source.getServer().tell((Runnable)new TickTask(this.source.getServer().getTickCount() + 1, () -> onCompleted.accept(result.booleanValue())));
            });
        }
        catch (IOException e) {
            RegionFileRelocator.logError(e, "can't create work dir: {}", e.getMessage());
        }
    }

    private boolean runRelocation(Path workDir) {
        ArrayList futures = new ArrayList();
        ExecutorService executor = Executors.newFixedThreadPool(9);
        this.relocationData.forEach((srcFile, data) -> futures.add(CompletableFuture.supplyAsync(() -> this.relocateOneRegion((Path)srcFile, workDir, (RelocationData)data), executor)));
        CompletionStage allRegionsFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> futures.stream().map(CompletableFuture::join).toList());
        try {
            return ((List)((CompletableFuture)allRegionsFuture).get()).stream().allMatch(x -> x);
        }
        catch (InterruptedException | ExecutionException e) {
            RegionFileRelocator.logError(e, "unexpected concurrency problem: {}", e.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean relocateOneRegion(Path fromFile, Path workDir, RelocationData data) {
        RegionCoords newCoords = data.orig.offsetBy(data.regionOffset);
        Path workFile = workDir.resolve(newCoords.filename());
        Path destFile = this.destDir.resolve(newCoords.filename());
        FTBTeamBases.LOGGER.debug("starting relocation for {} -> {}", (Object)fromFile, (Object)workFile);
        if (!this.force && Files.exists(destFile, new LinkOption[0])) {
            FTBTeamBases.LOGGER.error("Not overwriting region file: {}", (Object)destFile);
            return false;
        }
        try (RegionFileStorage storage = new RegionFileStorage(this.storageInfo, workDir, true);){
            Files.copy(fromFile, workFile, new CopyOption[0]);
            FTBTeamBases.LOGGER.debug("copied {} to {}", (Object)fromFile, (Object)workFile);
            if (!this.updateRegionChunkData(storage, newCoords, data.regionOffset.x(), data.regionOffset.z())) return false;
            Files.move(workFile, destFile, StandardCopyOption.REPLACE_EXISTING);
            FTBTeamBases.LOGGER.debug("moved {} to {}", (Object)workFile, (Object)destFile);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            RegionFileRelocator.logError(e, "IO exception caught: {}", e.getMessage());
        }
        return false;
    }

    private boolean updateRegionChunkData(RegionFileStorage storage, RegionCoords r, int xOff, int zOff) {
        if (xOff == 0 && zOff == 0) {
            return true;
        }
        for (int cx = 0; cx < 32; ++cx) {
            for (int cz = 0; cz < 32; ++cz) {
                ChunkPos newChunkPos = new ChunkPos(r.x() * 32 + cx, r.z() * 32 + cz);
                try {
                    CompoundTag chunkData = storage.read(newChunkPos);
                    if (chunkData != null) {
                        chunkData.putInt("xPos", newChunkPos.x);
                        chunkData.putInt("zPos", newChunkPos.z);
                        CompoundTag s = chunkData.getCompound("structures").getCompound("References");
                        for (String key : s.getAllKeys()) {
                            Tag tag2 = s.get(key);
                            if (!(tag2 instanceof LongArrayTag)) continue;
                            LongArrayTag a = (LongArrayTag)tag2;
                            ListTag l2 = new ListTag();
                            a.forEach(tag -> {
                                ChunkPos oldChunkPos = new ChunkPos(tag.getAsLong());
                                l2.add((Object)LongTag.valueOf((long)new ChunkPos(oldChunkPos.x + xOff * 32, oldChunkPos.z + zOff * 32).toLong()));
                            });
                            s.put(key, (Tag)l2);
                        }
                        chunkData.getList("block_entities", 10).forEach(tag -> {
                            if (tag instanceof CompoundTag) {
                                CompoundTag c = (CompoundTag)tag;
                                RegionFileRelocator.updateIfPresent(c, "x", xOff);
                                RegionFileRelocator.updateIfPresent(c, "z", zOff);
                                RegionFileRelocator.updateIfPresent(c, "posX", xOff);
                                RegionFileRelocator.updateIfPresent(c, "posZ", zOff);
                                RegionFileRelocator.updateIfPresent(c.getCompound("FlowerPos"), "X", xOff);
                                RegionFileRelocator.updateIfPresent(c.getCompound("FlowerPos"), "Z", zOff);
                                RegionFileRelocator.updateIfPresent(c.getCompound("ExitPortal"), "X", xOff);
                                RegionFileRelocator.updateIfPresent(c.getCompound("ExitPortal"), "Z", zOff);
                            }
                        });
                        List.of("block_ticks", "fluid_ticks").forEach(what -> chunkData.getList(what, 10).forEach(tag -> {
                            if (tag instanceof CompoundTag) {
                                CompoundTag c = (CompoundTag)tag;
                                RegionFileRelocator.updateIfPresent(c, "x", xOff);
                                RegionFileRelocator.updateIfPresent(c, "z", zOff);
                            }
                        }));
                        storage.write(newChunkPos, chunkData);
                    }
                    this.chunkProgress.getAndIncrement();
                    continue;
                }
                catch (IOException e) {
                    RegionFileRelocator.logError(e, "Can't update chunk pos data for region {}: {}", r, e.getMessage());
                    return false;
                }
            }
        }
        FTBTeamBases.LOGGER.debug("updated chunk NBT for region {}", (Object)r);
        return true;
    }

    private static void updateIfPresent(CompoundTag tag, String key, int offset) {
        if (tag.contains(key, 3)) {
            tag.putInt(key, tag.getInt(key) + offset * 512);
        }
    }

    private static void logError(Exception e, String msg, Object ... args) {
        FTBTeamBases.LOGGER.error("{}: " + msg, (Object)e.getClass().getSimpleName(), (Object)args);
    }

    public record RelocationData(RegionCoords orig, XZ regionOffset) {
    }
}

