/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftbteambases.util.RegionCoords;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;

public record RegionExtents(RegionCoords start, RegionCoords end) {
    public static final Codec<RegionExtents> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)RegionCoords.CODEC.fieldOf("start").forGetter(RegionExtents::start), (App)RegionCoords.CODEC.fieldOf("end").forGetter(RegionExtents::end)).apply((Applicative)inst, RegionExtents::new));

    public XZ getSize() {
        return XZ.of((int)(this.end.x() - this.start.x() + 1), (int)(this.end.z() - this.start.z() + 1));
    }

    @Override
    public String toString() {
        return this.start.toString() + " -> " + this.end.toString();
    }

    public String asBlockPosString() {
        XZ s = XZ.of((int)(this.start.x() * 512), (int)(this.start.z() * 512));
        XZ e = XZ.of((int)(this.end.x() * 512 + 511), (int)(this.end.z() * 512 + 511));
        return String.valueOf(s) + " -> " + String.valueOf(e);
    }

    public Collection<Path> files(Path parentDir) {
        ArrayList<Path> res = new ArrayList<Path>();
        for (int x = this.start.x(); x <= this.end.x(); ++x) {
            for (int z = this.start.z(); z <= this.end.z(); ++z) {
                res.add(parentDir.resolve(String.format("r.%d.%d.mca", x, z)));
            }
        }
        return res;
    }
}

