/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.util;

import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.config.ServerConfig;
import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import dev.ftb.mods.ftbteambases.mixin.NetherPortalBlockAccess;
import dev.ftb.mods.ftbteambases.util.DimensionUtils;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class NetherPortalPlacement {
    public static DimensionTransition getTeamEntryPoint(ServerLevel serverLevel, Entity entity, BlockPos srcPos) {
        if (!(entity instanceof ServerPlayer)) {
            return null;
        }
        ServerPlayer serverPlayer = (ServerPlayer)entity;
        Team team = FTBTeamsAPI.api().getManager().getTeamForPlayer(serverPlayer).orElse(null);
        if (team == null) {
            return null;
        }
        BaseInstanceManager mgr = BaseInstanceManager.get(serverPlayer.server);
        if (DimensionUtils.isTeamDimension((Level)serverLevel) || srcPos == null) {
            ServerLevel netherLevel = serverLevel.getServer().getLevel(Level.NETHER);
            if (netherLevel != null) {
                BlockPos basePos = NetherPortalPlacement.getTeamNetherBasePos(serverPlayer, team);
                WorldBorder worldborder = netherLevel.getWorldBorder();
                BlockPos destPos = worldborder.clampToBounds((double)basePos.getX(), (double)basePos.getY(), (double)basePos.getZ());
                if (srcPos != null) {
                    mgr.setPlayerNetherPortalLoc(serverPlayer, srcPos);
                }
                BlockPos srcPos1 = srcPos == null ? entity.blockPosition() : srcPos;
                return ((NetherPortalBlockAccess)Blocks.NETHER_PORTAL).invokeGetExitPortal(netherLevel, (Entity)serverPlayer, srcPos1, destPos, true, worldborder);
            }
        } else if (serverLevel.dimension().equals(ServerLevel.NETHER)) {
            return mgr.getBaseForPlayer(serverPlayer).map(base -> {
                ResourceKey<Level> teamDim = base.dimension();
                ServerLevel newLevel = serverLevel.getServer().getLevel(teamDim);
                if (newLevel != null) {
                    BlockPos portalPos = mgr.getPlayerNetherPortalLoc(serverPlayer).orElse(base.spawnPos());
                    return new DimensionTransition(newLevel, Vec3.atBottomCenterOf((Vec3i)portalPos), serverPlayer.getDeltaMovement(), serverPlayer.getYRot(), serverPlayer.getXRot(), DimensionTransition.PLAY_PORTAL_SOUND);
                }
                return null;
            }).orElse(null);
        }
        return null;
    }

    private static BlockPos getTeamNetherBasePos(ServerPlayer serverPlayer, @Nullable Team team) {
        int max;
        UUID id = team == null ? NetherPortalPlacement.getPlayerTeamId(serverPlayer.getUUID()) : team.getId();
        Random rand = new Random(id.getLeastSignificantBits() ^ id.getMostSignificantBits());
        double angle = rand.nextDouble(Math.PI * 2);
        int min = (Integer)ServerConfig.MIN_DIST_FROM_ORIGIN.get();
        if (min >= (max = ((Integer)ServerConfig.MAX_DIST_FROM_ORIGIN.get()).intValue())) {
            FTBTeamBases.LOGGER.warn("invalid min-max distance in config for nether portal placement, defaulting to 1000-25000");
            min = 1000;
            max = 25000;
        }
        int dist = min + rand.nextInt(max - min);
        return BlockPos.containing((double)(Math.cos(angle) * (double)dist), (double)ServerConfig.getNetherPortalYPos((Player)serverPlayer), (double)(Math.sin(angle) * (double)dist));
    }

    private static UUID getPlayerTeamId(UUID playerId) {
        return FTBTeamsAPI.api().getManager().getTeamForPlayerID(playerId).map(Team::getTeamId).orElse(playerId);
    }
}

