/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.util;

import com.google.common.collect.ImmutableSet;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.ftb.mods.ftbteambases.data.definition.BaseDefinition;
import dev.ftb.mods.ftbteambases.util.neoforge.DynamicDimensionManagerImpl;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class DynamicDimensionManager {
    private static final Set<ResourceKey<Level>> VANILLA_WORLDS = ImmutableSet.of((Object)Level.OVERWORLD, (Object)Level.NETHER, (Object)Level.END);
    private static Set<ResourceKey<Level>> pendingLevelsToUnregister = new HashSet<ResourceKey<Level>>();

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ServerLevel create(MinecraftServer server, ResourceKey<Level> key, BaseDefinition baseDefinition) {
        void var2_2;
        void var1_1;
        return DynamicDimensionManagerImpl.create(server, (ResourceKey<Level>)var1_1, (BaseDefinition)var2_2);
    }

    public static void markDimensionForUnregistration(MinecraftServer server, ResourceKey<Level> levelToRemove) {
        if (!VANILLA_WORLDS.contains(levelToRemove)) {
            pendingLevelsToUnregister.add(levelToRemove);
        }
    }

    public static Set<ResourceKey<Level>> getWorldsPendingUnregistration() {
        return Collections.unmodifiableSet(pendingLevelsToUnregister);
    }

    public static void unregisterScheduledDimensions(MinecraftServer server) {
        if (!pendingLevelsToUnregister.isEmpty()) {
            Set<ResourceKey<Level>> keysToRemove = pendingLevelsToUnregister;
            pendingLevelsToUnregister = new HashSet<ResourceKey<Level>>();
            DynamicDimensionManager.destroy_Internal(server, keysToRemove);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void destroy_Internal(MinecraftServer server, Set<ResourceKey<Level>> keysToRemove) {
        void var1_1;
        DynamicDimensionManagerImpl.destroy_Internal(server, (Set<ResourceKey<Level>>)var1_1);
    }
}

