/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.util;

import com.google.common.collect.ImmutableList;
import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.config.ServerConfig;
import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import dev.ftb.mods.ftbteambases.data.bases.LiveBaseDetails;
import dev.ftb.mods.ftbteambases.data.definition.BaseDefinition;
import dev.ftb.mods.ftbteambases.data.definition.BaseDefinitionManager;
import dev.ftb.mods.ftbteambases.worldgen.chunkgen.VoidChunkGenerator;
import dev.ftb.mods.ftbteambases.worldgen.processor.WaterLoggingFixProcessor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DimensionUtils {
    private static final BlockIgnoreProcessor IGNORE_PROCESSOR = new BlockIgnoreProcessor((List)ImmutableList.of((Object)Blocks.STRUCTURE_VOID, (Object)Blocks.STRUCTURE_BLOCK));
    public static final String PRIVATE_DIM_PREFIX = "private_for_";

    public static Optional<BlockPos> locateSpawn(StructureTemplate template) {
        StructurePlaceSettings placeSettings = DimensionUtils.makePlacementSettings(template);
        for (StructureTemplate.StructureBlockInfo info : template.filterBlocks(BlockPos.ZERO, placeSettings, Blocks.STRUCTURE_BLOCK)) {
            if (info.nbt() == null || StructureMode.valueOf((String)info.nbt().getString("mode")) != StructureMode.DATA) continue;
            FTBTeamBases.LOGGER.info("Found data block at [{}] with data [{}]", (Object)info.pos(), (Object)info.nbt().getString("metadata"));
            if (!info.nbt().getString("metadata").equalsIgnoreCase("spawn_point")) continue;
            return Optional.of(info.pos());
        }
        return Optional.empty();
    }

    public static StructurePlaceSettings makePlacementSettings(StructureTemplate template, boolean includeEntities) {
        Vec3i size = template.getSize();
        StructurePlaceSettings settings = new StructurePlaceSettings();
        settings.setIgnoreEntities(!includeEntities);
        settings.addProcessor((StructureProcessor)IGNORE_PROCESSOR);
        settings.addProcessor((StructureProcessor)WaterLoggingFixProcessor.INSTANCE);
        settings.setRotationPivot(new BlockPos(size.getX() / 2, size.getY() / 2, size.getZ() / 2));
        settings.setRotation(Rotation.NONE);
        return settings;
    }

    public static StructurePlaceSettings makePlacementSettings(StructureTemplate template) {
        return DimensionUtils.makePlacementSettings(template, (Boolean)ServerConfig.ENTITIES_IN_START_STRUCTURE.get());
    }

    public static boolean isTeamDimension(Level level) {
        return level.dimension().location().getNamespace().equals("ftbteambases");
    }

    public static boolean isPrivateTeamDimension(ResourceLocation id) {
        return id.getNamespace().equals("ftbteambases") && id.getPath().startsWith(PRIVATE_DIM_PREFIX);
    }

    public static boolean isPortalDimension(Level level) {
        return (Boolean)ServerConfig.ALLOW_NETHER_PORTALS.get() != false && DimensionUtils.isTeamDimension(level);
    }

    public static boolean isVoidChunkGen(ChunkGenerator chunkGenerator) {
        return chunkGenerator instanceof VoidChunkGenerator;
    }

    public static void clearPlayerInventory(ServerPlayer serverPlayer) {
        serverPlayer.getInventory().clearOrCountMatchingItems(arg -> true, -1, (Container)serverPlayer.inventoryMenu.getCraftSlots());
        serverPlayer.containerMenu.broadcastChanges();
        serverPlayer.inventoryMenu.slotsChanged((Container)serverPlayer.getInventory());
    }

    @NotNull
    public static Stream<Holder<StructureSet>> possibleStructures(HolderLookup<StructureSet> holderLookup, ResourceLocation baseTemplateId) {
        return BaseDefinitionManager.getServerInstance().getBaseDefinition(baseTemplateId).map(baseTemplate -> baseTemplate.constructionType().prebuilt().map(prebuilt -> {
            ResourceLocation setId = prebuilt.structureSetId().orElse(BaseDefinition.DEFAULT_STRUCTURE_SET);
            return holderLookup.getOrThrow(TagKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)setId)).stream();
        }).orElse(Stream.of(new Holder[0]))).orElse(Stream.of(new Holder[0]));
    }

    public static boolean teleport(ServerPlayer player, ResourceKey<Level> key, @Nullable BlockPos destPos) {
        return DimensionUtils.teleport(player, key, destPos, player.getYRot());
    }

    public static boolean teleport(ServerPlayer player, ResourceKey<Level> key, @Nullable BlockPos destPos, float yRot) {
        ServerLevel level = player.server.getLevel(key);
        if (level != null) {
            if (key.equals(ServerConfig.lobbyDimension().orElse((ResourceKey<Level>)Level.OVERWORLD))) {
                BlockPos lobbySpawnPos = BaseInstanceManager.get(player.server).getLobbySpawnPos();
                BlockPos pos = Objects.requireNonNullElse(destPos, lobbySpawnPos);
                DimensionUtils.doTeleport(player, level, pos, yRot);
            } else {
                Vec3 vec;
                if (destPos == null) {
                    vec = new Vec3(0.5, 1.1, 0.5);
                    BlockPos respawnPosition = player.getRespawnPosition();
                    if (player.getRespawnDimension().equals(key) && respawnPosition != null) {
                        vec = vec.add(new Vec3((double)respawnPosition.getX(), (double)respawnPosition.getY(), (double)respawnPosition.getZ()));
                    } else {
                        BlockPos levelSharedSpawn = BaseInstanceManager.get(player.server).getBaseForPlayer(player).map(LiveBaseDetails::spawnPos).orElse(BlockPos.ZERO);
                        vec = vec.add(new Vec3((double)levelSharedSpawn.getX(), (double)levelSharedSpawn.getY(), (double)levelSharedSpawn.getZ()));
                    }
                } else {
                    vec = Vec3.atCenterOf((Vec3i)destPos);
                }
                DimensionUtils.doTeleport(player, level, BlockPos.containing((double)vec.x, (double)vec.y, (double)vec.z), yRot);
            }
            return true;
        }
        FTBTeamBases.LOGGER.error("Failed to teleport {} to {} (bad level key)", (Object)player.getScoreboardName(), (Object)key.location());
        return false;
    }

    private static void doTeleport(ServerPlayer player, ServerLevel level, BlockPos pos, float yRot) {
        ChunkPos chunkpos = new ChunkPos(pos);
        level.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, chunkpos, 1, (Object)player.getId());
        player.stopRiding();
        player.teleportTo(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.01, (double)pos.getZ() + 0.5, yRot, player.getXRot());
        FTBTeamBases.LOGGER.debug("teleported {} to {} in {}", (Object)player.getGameProfile().getName(), (Object)pos, (Object)level.dimension().location());
    }
}

