/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.client.FTBTeamBasesClient;
import dev.ftb.mods.ftbteambases.mixin.LevelAccess;
import dev.ftb.mods.ftbteambases.mixin.PersistentEntitySectionManagerAccess;
import dev.ftb.mods.ftbteambases.mixin.ServerLevelAccess;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;

public record OpenVisitScreenMessage(Map<ResourceLocation, List<BaseData>> dimensionData) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OpenVisitScreenMessage> TYPE = new CustomPacketPayload.Type(FTBTeamBases.rl("open_visit_screen"));
    public static final StreamCodec<FriendlyByteBuf, OpenVisitScreenMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::newHashMap, (StreamCodec)ResourceLocation.STREAM_CODEC, (StreamCodec)BaseData.STREAM_CODEC.apply(ByteBufCodecs.list())), OpenVisitScreenMessage::dimensionData, OpenVisitScreenMessage::new);

    public static void handle(OpenVisitScreenMessage message, NetworkManager.PacketContext context) {
        FTBTeamBasesClient.openVisitScreen(message.dimensionData);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public record BaseData(String teamName, double tickTime, boolean archived, int blockEntities, int entities, int loadedChunks) {
        public static final StreamCodec<FriendlyByteBuf, BaseData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, BaseData::teamName, (StreamCodec)ByteBufCodecs.DOUBLE, BaseData::tickTime, (StreamCodec)ByteBufCodecs.BOOL, BaseData::archived, (StreamCodec)ByteBufCodecs.INT, BaseData::blockEntities, (StreamCodec)ByteBufCodecs.INT, BaseData::entities, (StreamCodec)ByteBufCodecs.INT, BaseData::loadedChunks, BaseData::new);

        public static BaseData create(ServerLevel level, String teamName, double tickTime, boolean archived) {
            int beCount = ((LevelAccess)level).getBlockEntityTickers().size();
            PersistentEntitySectionManager<Entity> m = ((ServerLevelAccess)level).getEntityManager();
            int eCount = ((PersistentEntitySectionManagerAccess)m).getKnownUuids().size();
            int lcCount = level.getChunkSource().getLoadedChunksCount();
            return new BaseData(teamName, tickTime, archived, beCount, eCount, lcCount);
        }
    }
}

