/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.mixin;

import dev.ftb.mods.ftbteambases.config.ServerConfig;
import dev.ftb.mods.ftbteambases.util.NetherPortalPlacement;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.portal.DimensionTransition;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Debug(export=true)
@Mixin(value={NetherPortalBlock.class})
public abstract class NetherPortalBlockMixin {
    @Inject(method={"getPortalDestination(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/portal/DimensionTransition;"}, at={@At(value="HEAD")}, cancellable=true)
    public void onGetPortalDestination(ServerLevel serverLevel, Entity entity, BlockPos blockPos, CallbackInfoReturnable<DimensionTransition> cir) {
        DimensionTransition transition;
        if (((Boolean)ServerConfig.TEAM_SPECIFIC_NETHER_ENTRY_POINT.get()).booleanValue() && (transition = NetherPortalPlacement.getTeamEntryPoint(serverLevel, entity, blockPos)) != null) {
            cir.setReturnValue((Object)transition);
        }
    }

    @ModifyVariable(method={"getExitPortal(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;ZLnet/minecraft/world/level/border/WorldBorder;)Lnet/minecraft/world/level/portal/DimensionTransition;"}, at=@At(value="HEAD"), argsOnly=true, index=4)
    private BlockPos modifyExitPos(BlockPos exitPos) {
        return (Boolean)ServerConfig.TEAM_SPECIFIC_NETHER_ENTRY_POINT.get() == false && (Boolean)ServerConfig.USE_CUSTOM_PORTAL_Y_POS.get() != false ? new BlockPos(exitPos.getX(), ((Integer)ServerConfig.CUSTOM_PORTAL_Y_POS.get()).intValue(), exitPos.getZ()) : exitPos;
    }
}

