/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.data.definition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public record DisplaySettings(String description, String author, Optional<ResourceLocation> previewImage, int displayOrder, boolean devMode) {
    public static final Codec<DisplaySettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("description").forGetter(DisplaySettings::description), (App)Codec.STRING.optionalFieldOf("author", (Object)"FTB Team").forGetter(DisplaySettings::author), (App)ResourceLocation.CODEC.optionalFieldOf("preview_image").forGetter(DisplaySettings::previewImage), (App)Codec.INT.optionalFieldOf("display_order", (Object)0).forGetter(DisplaySettings::displayOrder), (App)Codec.BOOL.optionalFieldOf("dev_mode", (Object)false).forGetter(DisplaySettings::devMode)).apply((Applicative)builder, DisplaySettings::new));
    public static final StreamCodec<FriendlyByteBuf, DisplaySettings> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, DisplaySettings::description, (StreamCodec)ByteBufCodecs.STRING_UTF8, DisplaySettings::author, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC), DisplaySettings::previewImage, (StreamCodec)ByteBufCodecs.VAR_INT, DisplaySettings::displayOrder, (StreamCodec)ByteBufCodecs.BOOL, DisplaySettings::devMode, DisplaySettings::new);

    public boolean descriptionMatches(String desc) {
        return desc.isEmpty() || this.description.toLowerCase().contains(desc.toLowerCase());
    }
}

