/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.data.definition;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import dev.ftb.mods.ftbteambases.data.definition.INetworkWritable;
import dev.ftb.mods.ftbteambases.data.definition.JigsawParams;
import dev.ftb.mods.ftbteambases.data.definition.PrebuiltStructure;
import dev.ftb.mods.ftbteambases.data.definition.Pregen;
import dev.ftb.mods.ftbteambases.data.definition.SingleStructure;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;

public record ConstructionType(Optional<PrebuiltStructure> prebuilt, Optional<Pregen> pregen, Optional<JigsawParams> jigsaw, Optional<SingleStructure> singleStructure) {
    public static final Codec<ConstructionType> CODEC = Codec.xor(PrebuiltStructure.CODEC, (Codec)Codec.xor(Pregen.CODEC, (Codec)Codec.xor(JigsawParams.CODEC, SingleStructure.CODEC))).xmap(ConstructionType::merge, ConstructionType::split);
    public static final StreamCodec<RegistryFriendlyByteBuf, ConstructionType> STREAM_CODEC = StreamCodec.of((buf, object) -> {
        if (object.prebuilt.isPresent()) {
            TypeID.PREBUILT.write(object.prebuilt.get(), (RegistryFriendlyByteBuf)buf);
        } else if (object.pregen.isPresent()) {
            TypeID.PREGEN.write(object.pregen.get(), (RegistryFriendlyByteBuf)buf);
        } else if (object.jigsaw.isPresent()) {
            TypeID.JIGSAW.write(object.jigsaw.get(), (RegistryFriendlyByteBuf)buf);
        } else if (object.singleStructure.isPresent()) {
            TypeID.SINGLE.write(object.singleStructure.get(), (RegistryFriendlyByteBuf)buf);
        } else {
            throw new IllegalStateException("none of prebuilt/pregen/jigsaw/single-structure present!");
        }
    }, buf -> switch (((TypeID)buf.readEnum(TypeID.class)).ordinal()) {
        default -> throw new MatchException(null, null);
        case 0 -> ConstructionType.ofPrebuilt((PrebuiltStructure)PrebuiltStructure.STREAM_CODEC.decode(buf));
        case 1 -> ConstructionType.ofPregen((Pregen)Pregen.STREAM_CODEC.decode(buf));
        case 2 -> ConstructionType.ofJigsaw((JigsawParams)JigsawParams.STREAM_CODEC.decode(buf));
        case 3 -> ConstructionType.ofSingleStructure((SingleStructure)SingleStructure.STREAM_CODEC.decode(buf));
    });

    private static ConstructionType merge(Either<PrebuiltStructure, Either<Pregen, Either<JigsawParams, SingleStructure>>> either) {
        return (ConstructionType)either.map(ConstructionType::ofPrebuilt, other -> (ConstructionType)other.map(ConstructionType::ofPregen, other2 -> (ConstructionType)other2.map(ConstructionType::ofJigsaw, ConstructionType::ofSingleStructure)));
    }

    @NotNull
    private static Either<PrebuiltStructure, Either<Pregen, Either<JigsawParams, SingleStructure>>> split(ConstructionType type) {
        if (type.prebuilt.isPresent()) {
            return Either.left((Object)type.prebuilt.get());
        }
        if (type.pregen.isPresent()) {
            return Either.right((Object)Either.left((Object)type.pregen.get()));
        }
        if (type.jigsaw.isPresent()) {
            return Either.right((Object)Either.right((Object)Either.left((Object)type.jigsaw.get())));
        }
        if (type.singleStructure.isPresent()) {
            return Either.right((Object)Either.right((Object)Either.right((Object)type.singleStructure.get())));
        }
        throw new IllegalStateException("none of prebuilt/pregen/jigsaw/single-structure are present!");
    }

    public static ConstructionType ofPrebuilt(PrebuiltStructure prebuiltStructure) {
        return new ConstructionType(Optional.of(prebuiltStructure), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static ConstructionType ofPregen(Pregen pregen) {
        return new ConstructionType(Optional.empty(), Optional.of(pregen), Optional.empty(), Optional.empty());
    }

    public static ConstructionType ofJigsaw(JigsawParams jigsawParams) {
        return new ConstructionType(Optional.empty(), Optional.empty(), Optional.of(jigsawParams), Optional.empty());
    }

    public static ConstructionType ofSingleStructure(SingleStructure singleStructure) {
        return new ConstructionType(Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(singleStructure));
    }

    static enum TypeID {
        PREBUILT,
        PREGEN,
        JIGSAW,
        SINGLE;


        public <T extends INetworkWritable<T>> void write(T obj, RegistryFriendlyByteBuf buf) {
            buf.writeEnum((Enum)this);
            obj.streamCodec().encode((Object)buf, obj);
        }
    }
}

