/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.data.construction;

import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.util.BooleanConsumer;
import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.data.bases.LiveBaseDetails;
import dev.ftb.mods.ftbteambases.data.definition.BaseDefinition;
import dev.ftb.mods.ftbteambases.util.RegionExtents;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;

public interface ConstructionWorker {
    public void startConstruction(BooleanConsumer var1);

    public RegionExtents getRegionExtents();

    public ResourceKey<Level> getDimension();

    public void tick();

    default public XZ getSpawnXZ() {
        RegionExtents extents = this.getRegionExtents();
        int x = Mth.lerpInt((float)0.5f, (int)(extents.start().x() * 512), (int)(extents.end().x() * 512 + 511));
        int z = Mth.lerpInt((float)0.5f, (int)(extents.start().z() * 512), (int)(extents.end().z() * 512 + 511));
        return XZ.of((int)x, (int)z);
    }

    default public BlockPos getInitialSpawnPos(Level destLevel, BaseDefinition baseDefinition) {
        BlockPos offset = baseDefinition.spawnOffset();
        XZ spawnXZ = this.getSpawnXZ().offset(offset.getX(), offset.getZ());
        destLevel.getChunk(spawnXZ.x() >> 4, spawnXZ.z() >> 4);
        int yPos = destLevel.getHeight(Heightmap.Types.WORLD_SURFACE, spawnXZ.x(), spawnXZ.z());
        if (yPos > destLevel.getMinBuildHeight()) {
            return new BlockPos(spawnXZ.x(), yPos, spawnXZ.z()).above(offset.getY());
        }
        return ConstructionWorker.findSafeSpawn(destLevel, baseDefinition, spawnXZ);
    }

    @NotNull
    private static BlockPos findSafeSpawn(Level destLevel, BaseDefinition baseDefinition, XZ spawnXZ) {
        BlockPos start = new BlockPos(spawnXZ.x() - 8, 0, spawnXZ.z() - 8);
        for (BlockPos.MutableBlockPos pos : BlockPos.spiralAround((BlockPos)start, (int)16, (Direction)Direction.EAST, (Direction)Direction.SOUTH)) {
            int y = destLevel.getHeight(Heightmap.Types.WORLD_SURFACE, pos.getX(), pos.getZ());
            if (y <= destLevel.getMinBuildHeight()) continue;
            return new BlockPos(pos.getX(), y + 1, pos.getZ());
        }
        BlockPos fallbackPos = new BlockPos(spawnXZ.x(), 64, spawnXZ.z());
        FTBTeamBases.LOGGER.warn("can't find safe player spawn for base {}, creating emergency block at {}", (Object)baseDefinition.id(), (Object)fallbackPos);
        destLevel.setBlock(fallbackPos, Blocks.STONE.defaultBlockState(), 3);
        return fallbackPos.above();
    }

    default public LiveBaseDetails makeLiveBaseDetails(Level destLevel, BaseDefinition baseDefinition) {
        return new LiveBaseDetails(this.getRegionExtents(), this.getDimension(), this.getInitialSpawnPos(destLevel, baseDefinition));
    }

    public static ResourceKey<Level> makePrivateDimensionKeyFor(String playerName) {
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)FTBTeamBases.rl("private_for_" + playerName + "_" + new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date())));
    }
}

