/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.data.bases;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.utils.GameInstance;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.command.CommandUtils;
import dev.ftb.mods.ftbteambases.config.ServerConfig;
import dev.ftb.mods.ftbteambases.data.bases.ArchivedBaseDetails;
import dev.ftb.mods.ftbteambases.data.bases.LiveBaseDetails;
import dev.ftb.mods.ftbteambases.data.definition.BaseDefinition;
import dev.ftb.mods.ftbteambases.data.purging.PurgeManager;
import dev.ftb.mods.ftbteambases.events.BaseArchivedEvent;
import dev.ftb.mods.ftbteambases.util.DimensionUtils;
import dev.ftb.mods.ftbteambases.util.NetherPortalPlacement;
import dev.ftb.mods.ftbteambases.util.RegionCoords;
import dev.ftb.mods.ftbteambases.util.RegionFileUtil;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BaseInstanceManager
extends SavedData {
    private static final int MAX_REGION_X = 2000;
    private static final String SAVE_NAME = "ftbteambases_bases";
    private static final Codec<Map<UUID, LiveBaseDetails>> LIVE_BASES_CODEC = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, LiveBaseDetails.CODEC).xmap(HashMap::new, Map::copyOf);
    private static final Codec<Map<ResourceLocation, RegionCoords>> GEN_POS_CODEC = Codec.unboundedMap((Codec)ResourceLocation.CODEC, RegionCoords.CODEC).xmap(HashMap::new, Map::copyOf);
    private static final Codec<Map<ResourceLocation, Integer>> Z_OFF_CODEC = Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.INT).xmap(HashMap::new, Map::copyOf);
    private static final Codec<Map<String, ArchivedBaseDetails>> ARCHIVED_BASES_CODEC = Codec.unboundedMap((Codec)Codec.STRING, ArchivedBaseDetails.CODEC).xmap(HashMap::new, Map::copyOf);
    private static final Codec<Map<UUID, BlockPos>> NETHER_PORTAL_POS_CODEC = Codec.unboundedMap((Codec)UUIDUtil.STRING_CODEC, (Codec)BlockPos.CODEC).xmap(HashMap::new, Map::copyOf);
    private static final Codec<Set<UUID>> KNOWN_PLAYERS_CODEC = UUIDUtil.CODEC.listOf().xmap(HashSet::new, List::copyOf);
    private static final Codec<BaseInstanceManager> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LIVE_BASES_CODEC.fieldOf("bases").forGetter(mgr -> mgr.liveBases), (App)GEN_POS_CODEC.fieldOf("gen_pos").forGetter(mgr -> mgr.storedGenPos), (App)Z_OFF_CODEC.fieldOf("z_offset").forGetter(mgr -> mgr.storedZoffset), (App)ARCHIVED_BASES_CODEC.fieldOf("archived_bases").forGetter(mgr -> mgr.archivedBases), (App)Codec.INT.fieldOf("next_archive_id").forGetter(mgr -> mgr.nextArchiveId), (App)Codec.BOOL.fieldOf("is_lobby_created").forGetter(mgr -> mgr.isLobbyCreated), (App)BlockPos.CODEC.fieldOf("lobby_spawn_pos").forGetter(mgr -> mgr.lobbySpawnPos), (App)NETHER_PORTAL_POS_CODEC.fieldOf("nether_portal_pos").forGetter(mgr -> mgr.playerNetherPortalLocs), (App)KNOWN_PLAYERS_CODEC.fieldOf("known_players").forGetter(mgr -> mgr.knownPlayers)).apply((Applicative)inst, BaseInstanceManager::new));
    private final Map<UUID, LiveBaseDetails> liveBases;
    private final Map<String, ArchivedBaseDetails> archivedBases;
    private final Map<ResourceLocation, RegionCoords> storedGenPos;
    private final Map<ResourceLocation, Integer> storedZoffset;
    private final Map<UUID, BlockPos> playerNetherPortalLocs;
    private final Set<UUID> knownPlayers;
    private boolean isLobbyCreated;
    private BlockPos lobbySpawnPos;
    private int nextArchiveId;

    private BaseInstanceManager(Map<UUID, LiveBaseDetails> liveBases, Map<ResourceLocation, RegionCoords> genPos, Map<ResourceLocation, Integer> zOffsets, Map<String, ArchivedBaseDetails> archivedBases, int nextArchiveId, boolean isLobbyCreated, BlockPos lobbySpawnPos, Map<UUID, BlockPos> netherPortalPos, Set<UUID> knownPlayers) {
        this.liveBases = liveBases;
        this.storedGenPos = genPos;
        this.storedZoffset = zOffsets;
        this.archivedBases = archivedBases;
        this.nextArchiveId = nextArchiveId;
        this.isLobbyCreated = isLobbyCreated;
        this.lobbySpawnPos = lobbySpawnPos;
        this.playerNetherPortalLocs = netherPortalPos;
        this.knownPlayers = knownPlayers;
    }

    private static BaseInstanceManager createNew() {
        return new BaseInstanceManager(new HashMap<UUID, LiveBaseDetails>(), new HashMap<ResourceLocation, RegionCoords>(), new HashMap<ResourceLocation, Integer>(), new HashMap<String, ArchivedBaseDetails>(), 0, false, BlockPos.ZERO, new HashMap<UUID, BlockPos>(), new HashSet<UUID>());
    }

    public static BaseInstanceManager get() {
        return BaseInstanceManager.get(Objects.requireNonNull(GameInstance.getServer()));
    }

    public static BaseInstanceManager get(MinecraftServer server) {
        DimensionDataStorage dataStorage = Objects.requireNonNull(server.getLevel(Level.OVERWORLD)).getDataStorage();
        return (BaseInstanceManager)dataStorage.computeIfAbsent(BaseInstanceManager.factory(), SAVE_NAME);
    }

    private static SavedData.Factory<BaseInstanceManager> factory() {
        return new SavedData.Factory(BaseInstanceManager::createNew, BaseInstanceManager::load, null);
    }

    public RegionCoords nextGenerationPos(MinecraftServer server, BaseDefinition baseDefinition, ResourceLocation dim, XZ size) {
        RegionCoords genPos;
        if (baseDefinition.dimensionSettings().privateDimension()) {
            return new RegionCoords(0, 0);
        }
        while (this.anyMCAFilesPresent(server, dim, genPos = this.getNextRegionCoords(dim, size), size)) {
        }
        return genPos;
    }

    public void addNewBase(UUID ownerId, LiveBaseDetails liveBaseDetails) {
        this.liveBases.put(ownerId, liveBaseDetails);
        this.setDirty();
    }

    @NotNull
    private RegionCoords getNextRegionCoords(ResourceLocation dimensionId, XZ baseSize) {
        RegionCoords genPos = this.storedGenPos.computeIfAbsent(dimensionId, k -> new RegionCoords(0, 0));
        int zOffset = Math.max(this.storedZoffset.computeIfAbsent(dimensionId, k -> baseSize.z()), baseSize.z());
        this.storedZoffset.put(dimensionId, zOffset);
        int separation = (Integer)ServerConfig.BASE_SEPARATION.get();
        RegionCoords nextPos = genPos.offsetBy(baseSize.x() + separation, 0);
        if (nextPos.x() > 2000) {
            nextPos = new RegionCoords(0, nextPos.z() + zOffset + separation);
        }
        this.storedGenPos.put(dimensionId, nextPos);
        this.setDirty();
        return genPos;
    }

    private boolean anyMCAFilesPresent(MinecraftServer server, ResourceLocation dim, RegionCoords genPos, XZ size) {
        Path path = RegionFileUtil.getPathForDimension(server, (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dim), "region");
        for (int x = 0; x < size.x(); ++x) {
            for (int z = 0; z < size.z(); ++z) {
                if (!Files.exists(path.resolve(genPos.offsetBy(x, z).filename()), new LinkOption[0])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean teleportToBaseSpawn(ServerPlayer player, UUID baseId) {
        return this.teleportToBaseSpawn(player, baseId, false);
    }

    public boolean teleportToBaseSpawn(ServerPlayer player, UUID baseId, boolean setRespawnPoint) {
        ServerLevel level;
        LiveBaseDetails base = this.liveBases.get(baseId);
        if (base != null && (level = player.getServer().getLevel(base.dimension())) != null) {
            Vec3 vec = Vec3.atCenterOf((Vec3i)base.spawnPos());
            player.getServer().executeIfPossible(() -> player.teleportTo(level, vec.x, vec.y, vec.z, player.getYRot(), player.getXRot()));
            if (setRespawnPoint) {
                player.setRespawnPosition(base.dimension(), base.spawnPos(), 0.0f, true, false);
            }
            return true;
        }
        return false;
    }

    public boolean teleportToNether(ServerPlayer player) throws CommandSyntaxException {
        if (!((Boolean)ServerConfig.TEAM_SPECIFIC_NETHER_ENTRY_POINT.get()).booleanValue()) {
            throw CommandUtils.NOT_TEAM_NETHER.create();
        }
        ServerLevel nether = player.getServer().getLevel(Level.NETHER);
        if (nether == null) {
            throw CommandUtils.DIM_MISSING.create((Object)Level.NETHER.location().toString());
        }
        DimensionTransition transition = NetherPortalPlacement.getTeamEntryPoint(nether, (Entity)player, null);
        if (transition == null) {
            return false;
        }
        BlockPos pos = BlockPos.containing((double)transition.pos().x(), (double)transition.pos().y(), (double)transition.pos().z());
        ChunkPos chunkpos = new ChunkPos(pos);
        nether.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, chunkpos, 1, (Object)player.getId());
        player.stopRiding();
        if (player.isSleeping()) {
            player.stopSleepInBed(true, true);
        }
        player.teleportTo(nether, transition.pos().x(), transition.pos().y() + 0.01, transition.pos().z(), player.getYRot(), player.getXRot());
        player.setPortalCooldown();
        return true;
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        return (CompoundTag)Util.make((Object)new CompoundTag(), tag -> tag.put("manager", (Tag)CODEC.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this).resultOrPartial(err -> FTBTeamBases.LOGGER.error("failed to serialize base instance data: {}", err)).orElse(new CompoundTag())));
    }

    private static BaseInstanceManager load(CompoundTag tag, HolderLookup.Provider provider) {
        BaseInstanceManager res = CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.getCompound("manager")).resultOrPartial(err -> FTBTeamBases.LOGGER.error("failed to deserialize base instance data: {}", err)).orElse(BaseInstanceManager.createNew());
        PurgeManager.INSTANCE.cleanUpPurgedArchives(res);
        return res;
    }

    public Optional<LiveBaseDetails> getBaseForPlayer(ServerPlayer player) {
        return FTBTeamsAPI.api().getManager().getTeamForPlayer(player).map(team -> this.liveBases.get(team.getTeamId()));
    }

    public Optional<LiveBaseDetails> getBaseForTeam(Team team) {
        return this.getBaseForTeamId(team.getTeamId());
    }

    public Optional<LiveBaseDetails> getBaseForTeamId(UUID id) {
        return Optional.ofNullable(this.liveBases.get(id));
    }

    public boolean teleportToLobby(ServerPlayer serverPlayer) {
        ResourceKey<Level> destLevel = ServerConfig.lobbyDimension().orElse((ResourceKey<Level>)Level.OVERWORLD);
        return DimensionUtils.teleport(serverPlayer, destLevel, this.lobbySpawnPos, ((Double)ServerConfig.LOBBY_PLAYER_YAW.get()).floatValue());
    }

    public void deleteAndArchive(MinecraftServer server, Team team) {
        LiveBaseDetails base = this.liveBases.remove(team.getTeamId());
        if (base != null) {
            Object name = server.getProfileCache().get(team.getOwner()).map(GameProfile::getName).orElse("unknown");
            name = (String)name + "-" + this.nextArchiveId;
            this.archivedBases.put((String)name, new ArchivedBaseDetails((String)name, base.extents(), base.dimension(), base.spawnPos(), team.getOwner(), Util.getEpochMillis()));
            ++this.nextArchiveId;
            this.setDirty();
            ((BaseArchivedEvent)BaseArchivedEvent.ARCHIVED.invoker()).deleted(this, team);
        }
    }

    public Map<UUID, LiveBaseDetails> allLiveBases() {
        return Collections.unmodifiableMap(this.liveBases);
    }

    public Collection<ArchivedBaseDetails> getArchivedBases() {
        return Collections.unmodifiableCollection(this.archivedBases.values());
    }

    public Collection<ArchivedBaseDetails> getArchivedBasesFor(UUID owner) {
        return this.archivedBases.values().stream().filter(b -> b.ownerId().equals(owner)).toList();
    }

    public Optional<ArchivedBaseDetails> getArchivedBase(String archiveId) {
        return Optional.ofNullable(this.archivedBases.get(archiveId));
    }

    public void removeArchivedBase(String archiveId) {
        if (this.archivedBases.remove(archiveId) != null) {
            this.setDirty();
        }
    }

    public void unarchiveBase(MinecraftServer server, ArchivedBaseDetails base) throws CommandSyntaxException {
        Team team = (Team)FTBTeamsAPI.api().getManager().getTeamForPlayerID(base.ownerId()).orElseThrow(() -> TeamArgument.TEAM_NOT_FOUND.create((Object)base.ownerId()));
        if (team.isPlayerTeam()) {
            Team newParty = team.createParty("", null);
            this.addNewBase(newParty.getId(), base.makeLiveBaseDetails());
            this.archivedBases.remove(base.archiveId());
            ServerPlayer player = server.getPlayerList().getPlayer(base.ownerId());
            if (player != null) {
                BaseInstanceManager.get(server).teleportToBaseSpawn(player, newParty.getId());
                player.displayClientMessage((Component)Component.translatable((String)"ftbteambases.message.restored_yours"), false);
            }
        } else {
            String ownerName = server.getProfileCache().get(base.ownerId()).map(GameProfile::getName).orElse(base.ownerId().toString());
            throw CommandUtils.PLAYER_IN_PARTY.create((Object)ownerName);
        }
        PurgeManager.INSTANCE.removePending(List.of(base));
    }

    public void teleportToArchivedBase(ServerPlayer player, String archiveName) {
        ServerLevel level;
        ArchivedBaseDetails base = this.archivedBases.get(archiveName);
        if (base != null && (level = player.getServer().getLevel(base.dimension())) != null) {
            Vec3 vec = Vec3.atCenterOf((Vec3i)base.spawnPos());
            player.getServer().executeIfPossible(() -> player.teleportTo(level, vec.x, vec.y, vec.z, player.getYRot(), player.getXRot()));
        }
    }

    public boolean isLobbyCreated() {
        return this.isLobbyCreated;
    }

    public void setLobbyCreated(boolean lobbyCreated) {
        this.isLobbyCreated = lobbyCreated;
        this.setDirty();
    }

    public BlockPos getLobbySpawnPos() {
        return this.lobbySpawnPos;
    }

    public void setLobbySpawnPos(BlockPos lobbySpawnPos) {
        this.lobbySpawnPos = lobbySpawnPos;
        this.setDirty();
    }

    public void setPlayerNetherPortalLoc(ServerPlayer player, BlockPos portalPos) {
        if (portalPos == null) {
            if (this.playerNetherPortalLocs.remove(player.getUUID()) != null) {
                this.setDirty();
            }
        } else {
            this.playerNetherPortalLocs.put(player.getUUID(), portalPos);
            this.setDirty();
        }
    }

    public Optional<BlockPos> getPlayerNetherPortalLoc(ServerPlayer player) {
        return Optional.ofNullable(this.playerNetherPortalLocs.get(player.getUUID()));
    }

    public void addKnownPlayer(ServerPlayer player) {
        if (this.knownPlayers.add(player.getUUID())) {
            this.setDirty();
        }
    }

    public boolean isPlayerKnown(ServerPlayer player) {
        return this.knownPlayers.contains(player.getUUID());
    }
}

