/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.config;

import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.DoubleValue;
import dev.ftb.mods.ftblibrary.snbt.config.EnumValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntArrayValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.snbt.config.StringValue;
import dev.ftb.mods.ftbteambases.FTBTeamBases;
import dev.ftb.mods.ftbteambases.worldgen.chunkgen.ChunkGenerators;
import java.util.Optional;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;

public interface ServerConfig {
    public static final NameMap<GameType> GAME_TYPE_NAME_MAP = NameMap.of((Object)GameType.ADVENTURE, (Object[])GameType.values()).create();
    public static final SNBTConfig CONFIG = SNBTConfig.create((String)"ftbteambases-server");
    public static final SNBTConfig GENERAL = CONFIG.addGroup("general");
    public static final BooleanValue CLEAR_PLAYER_INV_ON_JOIN = (BooleanValue)GENERAL.addBoolean("clear_player_inv_on_join", false).comment(new String[]{"When set to true, the player's inventory will be cleared when joining a team"});
    public static final BooleanValue HEAL_PLAYER_ON_JOIN = (BooleanValue)GENERAL.addBoolean("heal_player_on_join", true).comment(new String[]{"When set to true, the player will be healed (and fully fed) when joining a team"});
    public static final BooleanValue CLEAR_PLAYER_INV_ON_LEAVE = (BooleanValue)GENERAL.addBoolean("clear_player_inv_on_leave", true).comment(new String[]{"When set to true, the player's inventory will be cleared when leaving a team"});
    public static final BooleanValue TEAM_NETHER_ENTRY_POINT = (BooleanValue)GENERAL.addBoolean("team_nether_entry_point", true).comment(new String[]{"If true, then players going to the Nether via Nether Portal will be sent to a team-specific position in the Nether"});
    public static final IntValue BASE_SEPARATION = (IntValue)GENERAL.addInt("base_separation", 4, 0, 16).comment(new String[]{"Base separation (in 512-block regions) when allocating regions for new bases in shared dimensions; the amount of clear space between the edges of two adjacent bases"});
    public static final IntValue HOME_CMD_PERMISSION_LEVEL = (IntValue)GENERAL.addInt("home_cmd_permission_level", 0, 0, 4).comment(new String[]{"Permission level required to use the '/ftbteambases home' command; 0 = player, 2 = admin, 4 = server op"});
    public static final SNBTConfig LOBBY = CONFIG.addGroup("lobby");
    public static final StringValue LOBBY_STRUCTURE_LOCATION = (StringValue)LOBBY.addString("lobby_structure_location", FTBTeamBases.rl("lobby").toString()).comment(new String[]{"Resource location of the structure NBT for the overworld lobby"});
    public static final IntValue LOBBY_Y_POS = (IntValue)LOBBY.addInt("lobby_y_pos", 0, -64, 256).comment(new String[]{"Y position at which the lobby structure will be pasted into the level. Note: too near world min/max build height may result in parts of the structure being cut off - beware."});
    public static final EnumValue<GameType> LOBBY_GAME_MODE = (EnumValue)LOBBY.addEnum("lobby_game_mode", GAME_TYPE_NAME_MAP).comment(new String[]{"The default game mode given to players when in the lobby. Note that admin-mode players are free to change this."});
    public static final IntArrayValue LOBBY_SPAWN = (IntArrayValue)LOBBY.addIntArray("lobby_spawn_pos", new int[]{0, 0, 0}).comment(new String[]{"Position at which new players spawn. Only used if the lobby structure comes from a pregenerated region!"});
    public static final StringValue LOBBY_DIMENSION = (StringValue)LOBBY.addString("lobby_dimension", "minecraft:overworld").comment(new String[]{"Dimension ID of the level in which the lobby is created. This *must* be a static pre-existing dimension, not a dynamically created one! New players will be automatically teleported to this dimension the first time they connect to the server. This setting should be defined in default config so the server has it before any levels are created - do NOT modify this on existing worlds!"});
    public static final DoubleValue LOBBY_PLAYER_YAW = (DoubleValue)LOBBY.addDouble("lobby_player_yaw", 0.0, 0.0, 360.0).comment(new String[]{"Player Y-axis rotation when initially spawning in, or returning to, the lobby. (0 = south, 90 = west, 180 = north, 270 = east)"});
    public static final SNBTConfig WORLDGEN = CONFIG.addGroup("worldgen");
    public static final EnumValue<ChunkGenerators> CHUNK_GENERATOR = (EnumValue)WORLDGEN.addEnum("chunk_generator", ChunkGenerators.NAME_MAP).comment(new String[]{"The chunk generator to use. SIMPLE_VOID (void dim, one biome), MULTI_BIOME_VOID (void dim, overworld-like biome distribution) and CUSTOM (full worldgen, customisable biome source & noise settings)"});
    public static final StringValue SINGLE_BIOME_ID = (StringValue)WORLDGEN.addString("single_biome_id", "").comment(new String[]{"Only used by the CUSTOM and SIMPLE_VOID generators; if non-empty (e.g. 'minecraft:the_void'), the dimension will generate with only this biome. If empty, CUSTOM generator will use an overworld-like biome distribution, and SIMPLE_VOID will use 'minecraft:the_void'"});
    public static final EnumValue<FeatureGeneration> FEATURE_GEN = (EnumValue)WORLDGEN.addEnum("feature_gen", FeatureGeneration.NAME_MAP).comment(new String[]{"DEFAULT: generate features in non-void worlds, don't generate in void worlds; NEVER: never generate; ALWAYS: always generate"});
    public static final StringValue NOISE_SETTINGS = (StringValue)WORLDGEN.addString("noise_settings", "minecraft:overworld").comment(new String[]{"Only used by the CUSTOM generator; resource location for the noise settings to use."});
    public static final BooleanValue ENTITIES_IN_START_STRUCTURE = (BooleanValue)WORLDGEN.addBoolean("entities_in_start_structure", true).comment(new String[]{"If true, then any entities saved in the starting structure NBT will be included when the structure is generated"});
    public static final SNBTConfig NETHER = CONFIG.addGroup("nether");
    public static final BooleanValue ALLOW_NETHER_PORTALS = (BooleanValue)NETHER.addBoolean("allow_nether_portals", true).comment(new String[]{"When set to true, nether portals may be constructed in team dimensions"});
    public static final BooleanValue TEAM_SPECIFIC_NETHER_ENTRY_POINT = (BooleanValue)NETHER.addBoolean("team_specific_nether_entry_point", true).comment(new String[]{"If true, then players going to the Nether via Nether Portal will be sent to a random (but deterministic for the team) position in the Nether"});
    public static final IntValue MIN_DIST_FROM_ORIGIN = (IntValue)NETHER.addInt("min_dist_from_origin", 1000, 0, Integer.MAX_VALUE).comment(new String[]{"When 'team_specific_nether_entry_point' is true, this is the minimum distance from XZ=(0,0) this spot can be"});
    public static final IntValue MAX_DIST_FROM_ORIGIN = (IntValue)NETHER.addInt("max_dist_from_origin", 25000, 1000, Integer.MAX_VALUE).comment(new String[]{"When 'team_specific_nether_entry_point' is true, this is the maximum distance from XZ=(0,0) this spot can be. Must be greater than 'min_dist_from_origin'."});
    public static final BooleanValue USE_CUSTOM_PORTAL_Y_POS = (BooleanValue)NETHER.addBoolean("use_custom_portal_y", false).comment(new String[]{"If true, use the value 'portal_y_pos' for the Y position of the Nether entry position for players. If false, use the player's current Y position."});
    public static final IntValue CUSTOM_PORTAL_Y_POS = (IntValue)NETHER.addInt("portal_y_pos", 0).comment(new String[]{"See 'use_custom_portal_y'."});

    public static Optional<ResourceLocation> lobbyLocation() {
        try {
            return Optional.of(ResourceLocation.parse((String)((String)LOBBY_STRUCTURE_LOCATION.get())));
        }
        catch (ResourceLocationException ignored) {
            FTBTeamBases.LOGGER.error("invalid lobby resource location: {}", LOBBY_STRUCTURE_LOCATION.get());
            return Optional.empty();
        }
    }

    public static Optional<ResourceKey<Level>> lobbyDimension() {
        try {
            return Optional.of(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)((String)LOBBY_DIMENSION.get()))));
        }
        catch (ResourceLocationException ignored) {
            FTBTeamBases.LOGGER.error("invalid dimension ID in config 'lobby_dimension': {}", LOBBY_DIMENSION.get());
            return Optional.empty();
        }
    }

    public static Optional<BlockPos> lobbyPos() {
        int[] pos = (int[])LOBBY_SPAWN.get();
        if (pos.length == 3) {
            return Optional.of(new BlockPos(pos[0], pos[1], pos[2]));
        }
        FTBTeamBases.LOGGER.error("invalid lobby spawn pos! expected 3 integers, got {}", (Object)pos.length);
        return Optional.empty();
    }

    public static int getNetherPortalYPos(Player player) {
        return (Boolean)USE_CUSTOM_PORTAL_Y_POS.get() != false ? ((Integer)CUSTOM_PORTAL_Y_POS.get()).intValue() : player.blockPosition().getY();
    }

    public static enum FeatureGeneration {
        DEFAULT,
        NEVER,
        ALWAYS;

        public static final NameMap<FeatureGeneration> NAME_MAP;

        public boolean shouldGenerate(boolean isVoid) {
            return this == ALWAYS || this == DEFAULT && !isVoid;
        }

        static {
            NAME_MAP = NameMap.of((Object)((Object)DEFAULT), (Object[])FeatureGeneration.values()).create();
        }
    }
}

