/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbteambases.command.CommandUtils;
import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import dev.ftb.mods.ftbteambases.net.OpenVisitScreenMessage;
import dev.ftb.mods.ftbteambases.util.MiscUtil;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class VisitCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"visit").requires(ctx -> ctx.hasPermission(2))).executes(ctx -> VisitCommand.doOpenVisitScreen((CommandSourceStack)ctx.getSource()))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> CommandUtils.suggestLiveBases(builder)).executes(ctx -> VisitCommand.doVisit((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), false)));
    }

    public static LiteralArgumentBuilder<CommandSourceStack> registerNether() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"nether-visit").requires(ctx -> ctx.hasPermission(2))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> CommandUtils.suggestLiveBases(builder)).executes(ctx -> VisitCommand.doVisit((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), true)));
    }

    private static int doOpenVisitScreen(CommandSourceStack source) throws CommandSyntaxException {
        HashMap<ResourceLocation, List<OpenVisitScreenMessage.BaseData>> dimensionData = new HashMap<ResourceLocation, List<OpenVisitScreenMessage.BaseData>>();
        HashMap tickTimes = new HashMap();
        BaseInstanceManager mgr = BaseInstanceManager.get(source.getServer());
        mgr.allLiveBases().forEach((id, base) -> {
            ServerLevel serverLevel = source.getServer().getLevel(base.dimension());
            if (serverLevel != null) {
                String teamName = FTBTeamsAPI.api().getManager().getTeamByID(id).map(Team::getShortName).orElse("???");
                double tickTime = tickTimes.computeIfAbsent(serverLevel.dimension().location(), k -> MiscUtil.getTickTime(source.getServer(), (ResourceKey<Level>)serverLevel.dimension()));
                dimensionData.computeIfAbsent(base.dimension().location(), k -> new ArrayList()).add(OpenVisitScreenMessage.BaseData.create(serverLevel, teamName, tickTime, false));
            }
        });
        mgr.getArchivedBases().forEach(base -> {
            ServerLevel serverLevel = source.getServer().getLevel(base.dimension());
            if (serverLevel != null) {
                double tickTime = tickTimes.computeIfAbsent(serverLevel.dimension().location(), k -> MiscUtil.getTickTime(source.getServer(), (ResourceKey<Level>)serverLevel.dimension()));
                dimensionData.computeIfAbsent(base.dimension().location(), k -> new ArrayList()).add(OpenVisitScreenMessage.BaseData.create(serverLevel, base.archiveId(), tickTime, true));
            }
        });
        if (dimensionData.isEmpty()) {
            source.sendFailure((Component)Component.translatable((String)"ftbteambases.message.no_dimensions"));
            return 0;
        }
        NetworkManager.sendToPlayer((ServerPlayer)source.getPlayerOrException(), (CustomPacketPayload)new OpenVisitScreenMessage(dimensionData));
        return 1;
    }

    private static int doVisit(CommandSourceStack source, String name, boolean gotoNether) throws CommandSyntaxException {
        boolean res;
        Team team = (Team)FTBTeamsAPI.api().getManager().getTeamByName(name).orElseThrow(() -> TeamArgument.TEAM_NOT_FOUND.create((Object)name));
        ServerPlayer player = source.getPlayerOrException();
        BaseInstanceManager mgr = BaseInstanceManager.get(source.getServer());
        boolean bl = res = gotoNether ? mgr.teleportToNether(player) : mgr.teleportToBaseSpawn(player, team.getTeamId());
        if (!res) {
            throw CommandUtils.CANT_TELEPORT.create((Object)name);
        }
        return 1;
    }
}

