/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.ftb.mods.ftbteambases.command.CommandUtils;
import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import dev.ftb.mods.ftbteambases.data.bases.LiveBaseDetails;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.TeamManager;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ListCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"list").requires(ctx -> ctx.hasPermission(2))).executes(ctx -> ListCommand.doList((CommandSourceStack)ctx.getSource()));
    }

    private static int doList(CommandSourceStack source) {
        Map<UUID, LiveBaseDetails> bases = BaseInstanceManager.get(source.getServer()).allLiveBases();
        if (bases.isEmpty()) {
            source.sendSuccess(() -> Component.translatable((String)"ftbteambases.message.no_bases").withStyle(ChatFormatting.GOLD), false);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"ftbteambases.message.bases", (Object[])new Object[]{bases.size()}).withStyle(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.UNDERLINE}), false);
            source.sendSuccess(Component::empty, false);
            TeamManager mgr = FTBTeamsAPI.api().getManager();
            bases.forEach((id, base) -> mgr.getTeamByID(id).ifPresent(team -> {
                MutableComponent msg = Component.literal((String)"\u2022 ").append(CommandUtils.makeTooltipComponent((Component)Component.literal((String)team.getShortName()), ChatFormatting.YELLOW, team.getTeamId().toString())).append(" ").append(CommandUtils.makeCommandClicky("ftbteambases.gui.show", ChatFormatting.GREEN, "/ftbteambases show " + team.getShortName())).append(" ").append(CommandUtils.makeCommandClicky("ftbteambases.gui.visit", ChatFormatting.GREEN, "/ftbteambases visit " + team.getShortName()));
                source.sendSuccess(() -> msg, false);
            }));
        }
        return 1;
    }
}

