/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbteambases.command.CommandUtils;
import dev.ftb.mods.ftbteambases.config.ServerConfig;
import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;

public class HomeCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"home").requires(source -> source.hasPermission(((Integer)ServerConfig.HOME_CMD_PERMISSION_LEVEL.get()).intValue()))).executes(ctx -> HomeCommand.doGoHome((CommandSourceStack)ctx.getSource()));
    }

    private static int doGoHome(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        Team team = (Team)FTBTeamsAPI.api().getManager().getTeamForPlayer(player).orElseThrow(() -> TeamArgument.TEAM_NOT_FOUND.create((Object)player.getUUID()));
        if (team.isPartyTeam()) {
            if (!BaseInstanceManager.get(source.getServer()).teleportToBaseSpawn(player, team.getId())) {
                throw CommandUtils.CANT_TELEPORT.create((Object)team.getShortName());
            }
        } else {
            throw TeamArgument.NOT_IN_PARTY.create();
        }
        return 1;
    }
}

