/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.client.gui;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbteambases.net.OpenVisitScreenMessage;
import dev.ftb.mods.ftbteambases.net.VisitBaseMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class VisitScreen
extends Screen {
    private final Map<ResourceLocation, List<OpenVisitScreenMessage.BaseData>> baseDataMap;
    private VisitList visitList;
    private EditBox searchBox;
    private Button createButton;
    private static boolean showArchived = false;

    public VisitScreen(Map<ResourceLocation, List<OpenVisitScreenMessage.BaseData>> baseDataMap) {
        super((Component)Component.empty());
        this.baseDataMap = baseDataMap;
    }

    protected void init() {
        super.init();
        this.visitList = new VisitList(this.minecraft, this.width, this.height - 80 - 40, 80);
        this.searchBox = new EditBox(this.font, this.width / 2 - 80, 40, 160, 20, (Component)Component.empty());
        this.searchBox.setResponder(this.visitList::onFilterChanged);
        MutableComponent label = Component.translatable((String)"ftbteambases.gui.show_archived");
        Checkbox checkbox = Checkbox.builder((Component)label, (Font)this.font).pos(this.width - this.font.width((FormattedText)label) - 35, 40).selected(showArchived).onValueChange((widget, selected) -> {
            showArchived = selected;
            this.visitList.onFilterChanged(this.searchBox.getValue());
        }).build();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_BACK, btn -> this.onClose()).size(100, 20).pos(this.width / 2 - 130, this.height - 30).build());
        this.createButton = Button.builder((Component)Component.translatable((String)"ftbteambases.gui.visit"), btn -> this.onActivate()).size(150, 20).pos(this.width / 2 - 20, this.height - 30).build();
        this.addRenderableWidget((GuiEventListener)this.createButton);
        this.createButton.active = false;
        this.addRenderableWidget((GuiEventListener)checkbox);
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        this.addRenderableWidget((GuiEventListener)this.visitList);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.render(graphics, mouseX, mouseY, partialTick);
        String value = Component.translatable((String)"ftbteambases.gui.select_dimension").getString();
        graphics.drawString(this.font, value, this.width / 2 - this.font.width(value) / 2, 20, 0xFFFFFF);
    }

    private void onActivate() {
        VisitList.Entry entry = (VisitList.Entry)this.visitList.getSelected();
        if (entry != null) {
            NetworkManager.sendToServer((CustomPacketPayload)new VisitBaseMessage(entry.data.teamName(), entry.data.archived()));
            if (this.minecraft.level != null) {
                this.onClose();
            }
        }
    }

    private class VisitList
    extends AbstractSelectionList<Entry> {
        public VisitList(Minecraft minecraft, int width, int height, int top) {
            super(minecraft, width, height, top, 45);
            this.addChildren("");
        }

        private void addChildren(String filter) {
            ArrayList entries = new ArrayList();
            VisitScreen.this.baseDataMap.forEach((id, dataList) -> dataList.forEach(data -> {
                if (showArchived || !data.archived()) {
                    String name = data.teamName();
                    if (filter.isEmpty() || name.toLowerCase().contains(filter)) {
                        entries.add(new Entry((ResourceLocation)id, (OpenVisitScreenMessage.BaseData)data));
                    }
                }
            }));
            this.children().addAll(entries.stream().sorted(Comparator.comparing(o -> o.data.teamName())).toList());
        }

        public int getRowWidth() {
            return 400;
        }

        protected int getScrollbarPosition() {
            return this.width / 2 + 200;
        }

        public void setSelected(@Nullable Entry entry) {
            VisitScreen.this.createButton.active = entry != null;
            super.setSelected((AbstractSelectionList.Entry)entry);
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        private void onFilterChanged(String filter) {
            this.children().clear();
            this.addChildren(filter);
        }

        private class Entry
        extends AbstractSelectionList.Entry<Entry> {
            private final ResourceLocation dimId;
            private final OpenVisitScreenMessage.BaseData data;
            private long lastClickTime;

            public Entry(ResourceLocation dimId, OpenVisitScreenMessage.BaseData data) {
                this.dimId = dimId;
                this.data = data;
            }

            public boolean mouseClicked(double x, double y, int partialTick) {
                VisitList.this.setSelected(this);
                if (Util.getMillis() - this.lastClickTime < 250L) {
                    VisitScreen.this.onActivate();
                    return true;
                }
                this.lastClickTime = Util.getMillis();
                return false;
            }

            public void render(GuiGraphics graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                Font font = Minecraft.getInstance().font;
                Objects.requireNonNull(font);
                int lh = 9 + 1;
                int tpsCol = this.data.tickTime() < 50.0 ? 0x80FF80 : (this.data.tickTime() < 100.0 ? 0xFFFF80 : 0xFF8080);
                int startX = left + 5;
                graphics.drawString(font, (Component)Component.literal((String)this.data.teamName()), startX, top + 2, this.data.archived() ? 0x606060 : 0xFFFFFF);
                graphics.drawString(font, (Component)Component.literal((String)this.dimId.toString()), startX, top + 2 + lh, this.data.archived() ? 0x808080 : 0xC0C0C0);
                double tps = Math.min(1000.0 / this.data.tickTime(), 20.0);
                graphics.drawString(font, (Component)Component.literal((String)String.format("%.3f ms/tick (%.3f TPS)", this.data.tickTime(), tps)), startX + 5, top + 2 + lh * 2, tpsCol);
                if (this.data.archived()) {
                    graphics.drawString(font, (Component)Component.literal((String)"Archived"), startX + 5, top + 2 + lh * 3, 0xD0A000);
                } else {
                    graphics.drawString(font, (Component)Component.literal((String)"Active"), startX + 5, top + 2 + lh * 3, 0xD0D000);
                }
                if (isMouseOver) {
                    List<MutableComponent> tooltip = List.of(Component.translatable((String)"ftbteambases.gui.block_entities", (Object[])new Object[]{this.data.blockEntities()}), Component.translatable((String)"ftbteambases.gui.entities", (Object[])new Object[]{this.data.entities()}), Component.translatable((String)"ftbteambases.gui.loaded_chunks", (Object[])new Object[]{this.data.loadedChunks()}));
                    graphics.renderTooltip(font, tooltip, Optional.empty(), mouseX, mouseY);
                }
            }
        }
    }
}

