/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases.block;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import dev.ftb.mods.ftbteambases.data.construction.BaseConstructionManager;
import dev.ftb.mods.ftbteambases.net.ShowSelectionGuiMessage;
import dev.ftb.mods.ftbteambases.registry.ModBlocks;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BasesPortalBlock
extends NetherPortalBlock {
    public BasesPortalBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHER_PORTAL));
    }

    public void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
    }

    public void entityInside(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        ServerPlayer player;
        if (level.isClientSide || !(entity instanceof ServerPlayer) || !(player = (ServerPlayer)entity).canUsePortal(false)) {
            return;
        }
        if (player.isOnPortalCooldown()) {
            player.setPortalCooldown();
        } else {
            FTBTeamsAPI.api().getManager().getTeamForPlayer(player).ifPresent(team -> {
                if (team.isPartyTeam()) {
                    BaseInstanceManager.get(player.getServer()).teleportToBaseSpawn(player, team.getId());
                } else if (!BaseConstructionManager.INSTANCE.isConstructing(player)) {
                    player.setPortalCooldown();
                    NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)ShowSelectionGuiMessage.INSTANCE);
                }
            });
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction.Axis facing = ctx.getHorizontalDirection().getAxis();
        facing = facing == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        return (BlockState)this.defaultBlockState().setValue((Property)NetherPortalBlock.AXIS, (Comparable)facing);
    }

    public ItemStack getCloneItemStack(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return new ItemStack((ItemLike)ModBlocks.PORTAL_ITEM.get());
    }

    public BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        return blockState;
    }
}

