/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteambases;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftbteambases.TeamEventListener;
import dev.ftb.mods.ftbteambases.command.CommandUtils;
import dev.ftb.mods.ftbteambases.config.ServerConfig;
import dev.ftb.mods.ftbteambases.data.bases.BaseInstanceManager;
import dev.ftb.mods.ftbteambases.data.construction.BaseConstructionManager;
import dev.ftb.mods.ftbteambases.data.construction.RelocatorTracker;
import dev.ftb.mods.ftbteambases.data.definition.BaseDefinitionManager;
import dev.ftb.mods.ftbteambases.data.purging.PurgeManager;
import dev.ftb.mods.ftbteambases.net.FTBTeamBasesNet;
import dev.ftb.mods.ftbteambases.net.SyncBaseTemplatesMessage;
import dev.ftb.mods.ftbteambases.net.VoidTeamDimensionMessage;
import dev.ftb.mods.ftbteambases.registry.ModBlocks;
import dev.ftb.mods.ftbteambases.registry.ModWorldGen;
import dev.ftb.mods.ftbteambases.util.DimensionUtils;
import dev.ftb.mods.ftbteambases.util.DynamicDimensionManager;
import dev.ftb.mods.ftbteambases.util.InitialPregen;
import dev.ftb.mods.ftbteambases.util.RegionFileRelocator;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FTBTeamBases {
    public static final String MOD_ID = "ftbteambases";
    public static final Logger LOGGER = LogManager.getLogger((String)"ftbteambases");
    public static final ResourceLocation NO_TEMPLATE_ID = FTBTeamBases.rl("none");
    public static final ResourceLocation SHARED_DIMENSION_ID = FTBTeamBases.rl("bases");

    public static void init() {
        try {
            Files.createDirectories(RegionFileRelocator.PREGEN_PATH, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("can't create {}: {}", (Object)RegionFileRelocator.PREGEN_PATH, (Object)e.getMessage());
        }
        ModWorldGen.init();
        ModBlocks.init();
        FTBTeamBasesNet.init();
        LifecycleEvent.SERVER_BEFORE_START.register(FTBTeamBases::serverBeforeStart);
        LifecycleEvent.SERVER_STARTING.register(FTBTeamBases::serverStarting);
        LifecycleEvent.SERVER_STARTED.register(FTBTeamBases::serverStarted);
        LifecycleEvent.SERVER_STOPPING.register(FTBTeamBases::serverStopping);
        LifecycleEvent.SERVER_LEVEL_LOAD.register(FTBTeamBases::onLevelLoad);
        TickEvent.SERVER_POST.register(FTBTeamBases::onServerTick);
        CommandRegistrationEvent.EVENT.register(CommandUtils::registerCommands);
        TeamEvent.PLAYER_JOINED_PARTY.register(TeamEventListener::teamPlayerJoin);
        TeamEvent.PLAYER_LEFT_PARTY.register(TeamEventListener::teamPlayerLeftParty);
        EntityEvent.ADD.register(FTBTeamBases::playerJoinLevel);
        PlayerEvent.PLAYER_JOIN.register(FTBTeamBases::playerEnterServer);
        PlayerEvent.CHANGE_DIMENSION.register(FTBTeamBases::playerChangedDimension);
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)new BaseDefinitionManager.ReloadListener());
    }

    private static void onServerTick(MinecraftServer server) {
        RelocatorTracker.INSTANCE.tick(server);
        BaseConstructionManager.INSTANCE.tick(server);
        DynamicDimensionManager.unregisterScheduledDimensions(server);
    }

    private static void serverBeforeStart(MinecraftServer server) {
        Path configPath = server.getWorldPath(ConfigUtil.SERVER_CONFIG_DIR);
        ConfigUtil.loadDefaulted((SNBTConfig)ServerConfig.CONFIG, (Path)configPath, (String)MOD_ID);
        PurgeManager.INSTANCE.onInit(server);
        PurgeManager.INSTANCE.checkForPurges(server);
    }

    private static void serverStarting(MinecraftServer server) {
        FTBTeamsAPI.api().setPartyCreationFromAPIOnly(true);
    }

    private static void serverStarted(MinecraftServer server) {
        ServerConfig.lobbyDimension().ifPresent(dim -> {
            if (dim.equals(Level.OVERWORLD)) {
                ServerLevel level = server.getLevel(Level.OVERWORLD);
                if (level == null) {
                    LOGGER.error("Missed spawn reset event due to overworld being null?!");
                    return;
                }
                BaseInstanceManager mgr = BaseInstanceManager.get(server);
                if (mgr.isLobbyCreated() && !level.getSharedSpawnPos().equals((Object)mgr.getLobbySpawnPos())) {
                    level.setDefaultSpawnPos(mgr.getLobbySpawnPos(), 180.0f);
                    LOGGER.info("Updating overworld spawn pos to the lobby location: {}", (Object)mgr.getLobbySpawnPos());
                }
            }
        });
    }

    private static void serverStopping(MinecraftServer server) {
        PurgeManager.INSTANCE.onShutdown();
    }

    private static void onLevelLoad(ServerLevel serverLevel) {
        if (serverLevel.dimension() == Level.OVERWORLD && InitialPregen.maybeDoInitialPregen(serverLevel.getServer())) {
            return;
        }
        ServerConfig.lobbyDimension().ifPresent(rl -> {
            if (serverLevel.dimension().equals(rl)) {
                FTBTeamBases.handleLobbySetup(serverLevel);
            }
        });
    }

    private static void playerEnterServer(ServerPlayer player) {
        SyncBaseTemplatesMessage.syncTo(player);
    }

    private static EventResult playerJoinLevel(Entity entity, Level level) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (level instanceof ServerLevel) {
                Level level2;
                ServerLevel serverLevel = (ServerLevel)level;
                if (FTBTeamBases.isFirstTimeConnecting(player, serverLevel)) {
                    ServerLevel destLevel = ServerConfig.lobbyDimension().map(dim -> serverLevel.getServer().getLevel(dim)).orElse(serverLevel);
                    BlockPos lobbySpawnPos = BaseInstanceManager.get(player.server).getLobbySpawnPos();
                    if (player.getRespawnPosition() == null || !player.getRespawnPosition().equals((Object)lobbySpawnPos)) {
                        player.setRespawnPosition(destLevel.dimension(), lobbySpawnPos, ((Double)ServerConfig.LOBBY_PLAYER_YAW.get()).floatValue(), true, false);
                        player.teleportTo(destLevel, (double)lobbySpawnPos.getX(), (double)lobbySpawnPos.getY(), (double)lobbySpawnPos.getZ(), ((Double)ServerConfig.LOBBY_PLAYER_YAW.get()).floatValue(), -10.0f);
                    }
                    BaseInstanceManager.get().addKnownPlayer(player);
                }
                if ((level2 = player.level()) instanceof ServerLevel) {
                    ServerLevel s = (ServerLevel)level2;
                    if (DimensionUtils.isVoidChunkGen(s.getChunkSource().getGenerator())) {
                        VoidTeamDimensionMessage.syncTo(player);
                    }
                    FTBTeamBases.switchGameMode(player, null, (ResourceKey<Level>)s.dimension());
                }
            }
        }
        return EventResult.pass();
    }

    private static boolean isFirstTimeConnecting(ServerPlayer player, ServerLevel level) {
        return level.dimension().equals(Level.OVERWORLD) && player.getRespawnDimension().equals(Level.OVERWORLD) && !BaseInstanceManager.get().isPlayerKnown(player);
    }

    private static void playerChangedDimension(ServerPlayer player, ResourceKey<Level> oldDim, ResourceKey<Level> newDim) {
        FTBTeamBases.switchGameMode(player, oldDim, newDim);
        FTBTeamBases.handleNetherTravel(player, oldDim, newDim);
    }

    private static void switchGameMode(ServerPlayer player, @Nullable ResourceKey<Level> oldDim, ResourceKey<Level> newDim) {
        GameType lobbyGameMode = (GameType)ServerConfig.LOBBY_GAME_MODE.get();
        ResourceKey<Level> lobby = ServerConfig.lobbyDimension().orElse((ResourceKey<Level>)Level.OVERWORLD);
        if (newDim.equals(lobby) && player.gameMode.getGameModeForPlayer() != lobbyGameMode && player.gameMode.getGameModeForPlayer() != GameType.CREATIVE) {
            player.setGameMode(lobbyGameMode);
        } else if (lobby.equals(oldDim) && !newDim.equals(lobby) && player.gameMode.getGameModeForPlayer() == lobbyGameMode) {
            player.setGameMode(GameType.SURVIVAL);
        }
    }

    private static void handleNetherTravel(ServerPlayer player, ResourceKey<Level> oldDim, ResourceKey<Level> newDim) {
        if (player.isOnPortalCooldown()) {
            BaseInstanceManager mgr = BaseInstanceManager.get(player.server);
            if (newDim.equals((Object)Level.NETHER)) {
                BlockPos portalPos = oldDim.location().getNamespace().equals(MOD_ID) ? BlockPos.containing((double)player.xOld, (double)player.yOld, (double)player.zOld) : null;
                mgr.setPlayerNetherPortalLoc(player, portalPos);
            } else if (oldDim.equals((Object)Level.NETHER) && newDim.equals((Object)Level.OVERWORLD)) {
                mgr.getBaseForPlayer(player).ifPresentOrElse(base -> {
                    ResourceKey<Level> teamDim = base.dimension();
                    BlockPos portalPos = mgr.getPlayerNetherPortalLoc(player).orElse(base.spawnPos());
                    DimensionUtils.teleport(player, teamDim, portalPos);
                }, () -> mgr.teleportToLobby(player));
            }
        }
    }

    private static void handleLobbySetup(ServerLevel serverLevel) {
        BaseInstanceManager mgr = BaseInstanceManager.get(serverLevel.getServer());
        if (!mgr.isLobbyCreated()) {
            ServerConfig.lobbyLocation().ifPresent(lobbyLocation -> {
                StructureTemplate lobby = serverLevel.getStructureManager().getOrCreate(lobbyLocation);
                StructurePlaceSettings placeSettings = DimensionUtils.makePlacementSettings(lobby);
                BlockPos lobbyPos = BlockPos.ZERO.offset(-(lobby.getSize().getX() / 2), ((Integer)ServerConfig.LOBBY_Y_POS.get()).intValue(), -(lobby.getSize().getZ() / 2));
                lobby.placeInWorld((ServerLevelAccessor)serverLevel, lobbyPos, lobbyPos, placeSettings, serverLevel.random, 3);
                BlockPos relativePos = DimensionUtils.locateSpawn(lobby).orElse(BlockPos.ZERO);
                BlockPos playerSpawn = lobbyPos.offset(relativePos.getX(), relativePos.getY(), relativePos.getZ());
                mgr.setLobbySpawnPos(playerSpawn);
                serverLevel.removeBlock(playerSpawn, false);
                serverLevel.setDefaultSpawnPos(playerSpawn, ((Double)ServerConfig.LOBBY_PLAYER_YAW.get()).floatValue());
                mgr.setLobbyCreated(true);
                LOGGER.info("Spawned lobby structure @ {} / {}", (Object)serverLevel.dimension().location(), (Object)lobbyPos);
            });
        }
    }

    public static ResourceLocation rl(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)id);
    }
}

