/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.network.client;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.event.SlotModifiersUpdatedEvent;
import top.theillusivec4.curios.api.type.ICuriosMenu;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.client.gui.CuriosScreen;
import top.theillusivec4.curios.common.data.CuriosEntityManager;
import top.theillusivec4.curios.common.data.CuriosSlotManager;
import top.theillusivec4.curios.common.inventory.CurioStacksHandler;
import top.theillusivec4.curios.common.inventory.container.CuriosContainer;
import top.theillusivec4.curios.common.network.server.SPacketBreak;
import top.theillusivec4.curios.common.network.server.SPacketGrabbedItem;
import top.theillusivec4.curios.common.network.server.SPacketPage;
import top.theillusivec4.curios.common.network.server.SPacketQuickMove;
import top.theillusivec4.curios.common.network.server.SPacketSetIcons;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncCurios;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncData;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncModifiers;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncRender;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncStack;
import top.theillusivec4.curios.server.command.CurioArgumentType;

public class CuriosClientPackets {
    public static void handle(SPacketSetIcons data) {
        ClientLevel world = Minecraft.getInstance().level;
        HashSet<String> slotIds = new HashSet<String>();
        if (world != null) {
            CuriosApi.getIconHelper().clearIcons();
            HashMap<String, ResourceLocation> icons = new HashMap<String, ResourceLocation>();
            for (Map.Entry<String, ResourceLocation> entry : data.map.entrySet()) {
                CuriosApi.getIconHelper().addIcon(entry.getKey(), entry.getValue());
                icons.put(entry.getKey(), entry.getValue());
                slotIds.add(entry.getKey());
            }
            CuriosSlotManager.CLIENT.setIcons(icons);
        }
        CurioArgumentType.slotIds = slotIds;
    }

    public static void handle(SPacketQuickMove data) {
        AbstractContainerMenu abstractContainerMenu;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer clientPlayer = mc.player;
        if (clientPlayer != null && (abstractContainerMenu = clientPlayer.containerMenu) instanceof CuriosContainer) {
            CuriosContainer container = (CuriosContainer)abstractContainerMenu;
            container.quickMoveStack((Player)clientPlayer, data.moveIndex());
        }
    }

    public static void handle(SPacketPage data) {
        AbstractContainerMenu container;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer clientPlayer = mc.player;
        Screen screen = mc.screen;
        if (clientPlayer != null && (container = clientPlayer.containerMenu) instanceof CuriosContainer && container.containerId == data.windowId()) {
            ((CuriosContainer)container).setPage(data.page());
        }
        if (screen instanceof CuriosScreen) {
            ((CuriosScreen)screen).updateRenderButtons();
        }
    }

    public static void handle(SPacketBreak data) {
        Entity entity;
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null && (entity = world.getEntity(data.entityId())) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            CuriosApi.getCuriosInventory(livingEntity).flatMap(handler -> handler.getStacksHandler(data.curioId())).ifPresent(stacks -> {
                ItemStack stack = stacks.getStacks().getStackInSlot(data.slotId());
                Optional<ICurio> possibleCurio = CuriosApi.getCurio(stack);
                NonNullList<Boolean> renderStates = stacks.getRenders();
                possibleCurio.ifPresent(curio -> curio.curioBreak(new SlotContext(data.curioId(), livingEntity, data.slotId(), false, renderStates.size() > data.slotId() && (Boolean)renderStates.get(data.slotId()) != false)));
                if (possibleCurio.isEmpty()) {
                    ICurio.playBreakAnimation(stack, livingEntity);
                }
            });
        }
    }

    public static void handle(SPacketSyncRender data) {
        Entity entity;
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null && (entity = world.getEntity(data.entityId())) instanceof LivingEntity) {
            CuriosApi.getCuriosInventory((LivingEntity)entity).flatMap(handler -> handler.getStacksHandler(data.curioId())).ifPresent(stacksHandler -> {
                int index = data.slotId();
                NonNullList<Boolean> renderStatuses = stacksHandler.getRenders();
                if (renderStatuses.size() > index) {
                    renderStatuses.set(index, (Object)data.value());
                }
            });
        }
    }

    public static void handle(SPacketSyncModifiers data) {
        Entity entity;
        Minecraft mc = Minecraft.getInstance();
        ClientLevel world = mc.level;
        if (world != null && (entity = world.getEntity(data.entityId)) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            CuriosApi.getCuriosInventory(livingEntity).ifPresent(handler -> {
                Map<String, ICurioStacksHandler> curios = handler.getCurios();
                for (Map.Entry<String, CompoundTag> entry : data.updates.entrySet()) {
                    String id = entry.getKey();
                    ICurioStacksHandler stacksHandler = curios.get(id);
                    if (stacksHandler == null) continue;
                    stacksHandler.applySyncTag(entry.getValue());
                }
                if (!data.updates.isEmpty()) {
                    NeoForge.EVENT_BUS.post((Event)new SlotModifiersUpdatedEvent(livingEntity, data.updates.keySet()));
                }
                if (entity instanceof LocalPlayer) {
                    Screen patt1$temp;
                    LocalPlayer localPlayer = (LocalPlayer)entity;
                    AbstractContainerMenu patt0$temp = localPlayer.containerMenu;
                    if (patt0$temp instanceof ICuriosMenu) {
                        ICuriosMenu curiosMenu = (ICuriosMenu)patt0$temp;
                        curiosMenu.resetSlots();
                    }
                    if ((patt1$temp = mc.screen) instanceof CuriosScreen) {
                        CuriosScreen screen = (CuriosScreen)patt1$temp;
                        screen.updateRenderButtons();
                    }
                }
            });
        }
    }

    public static void handle(SPacketSyncData data) {
        CuriosSlotManager.applySyncPacket(data.slotData);
        CuriosEntityManager.applySyncPacket(data.entityData);
    }

    public static void handle(SPacketSyncCurios data) {
        Entity entity;
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null && (entity = world.getEntity(data.entityId)) instanceof LivingEntity) {
            CuriosApi.getCuriosInventory((LivingEntity)entity).ifPresent(handler -> {
                LinkedHashMap<String, ICurioStacksHandler> stacks = new LinkedHashMap<String, ICurioStacksHandler>();
                for (Map.Entry<String, CompoundTag> entry : data.map.entrySet()) {
                    CurioStacksHandler stacksHandler = new CurioStacksHandler((ICuriosItemHandler)handler, entry.getKey());
                    stacksHandler.applySyncTag(entry.getValue());
                    stacks.put(entry.getKey(), stacksHandler);
                }
                handler.setCurios(stacks);
                if (entity instanceof LocalPlayer) {
                    LocalPlayer localPlayer = (LocalPlayer)entity;
                    AbstractContainerMenu patt0$temp = localPlayer.containerMenu;
                    if (patt0$temp instanceof ICuriosMenu) {
                        ICuriosMenu curiosContainer = (ICuriosMenu)patt0$temp;
                        curiosContainer.resetSlots();
                    }
                }
            });
        }
    }

    public static void handle(SPacketGrabbedItem data) {
        LocalPlayer clientPlayer = Minecraft.getInstance().player;
        if (clientPlayer != null) {
            clientPlayer.containerMenu.setCarried(data.stack().copy());
        }
    }

    public static void handle(SPacketSyncStack data) {
        Entity entity;
        ClientLevel world = Minecraft.getInstance().level;
        if (world != null && (entity = world.getEntity(data.entityId())) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            CuriosApi.getCuriosInventory(livingEntity).flatMap(handler -> handler.getStacksHandler(data.curioId())).ifPresent(stacksHandler -> {
                boolean cosmetic;
                ItemStack stack = data.stack().copy();
                CompoundTag compoundNBT = data.compoundTag();
                int slot = data.slotId();
                boolean bl = cosmetic = SPacketSyncStack.HandlerType.fromValue(data.handlerType()) == SPacketSyncStack.HandlerType.COSMETIC;
                if (!compoundNBT.isEmpty()) {
                    NonNullList<Boolean> renderStates = stacksHandler.getRenders();
                    CuriosApi.getCurio(stack).ifPresent(curio -> curio.readSyncData(new SlotContext(data.curioId(), livingEntity, slot, cosmetic, renderStates.size() > slot && (Boolean)renderStates.get(slot) != false), compoundNBT));
                }
                if (cosmetic) {
                    stacksHandler.getCosmeticStacks().setStackInSlot(slot, stack);
                } else {
                    stacksHandler.getStacks().setStackInSlot(slot, stack);
                }
            });
        }
    }
}

