/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.event;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.EnderManAngerEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEquipmentChangeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotAttribute;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.event.CurioChangeEvent;
import top.theillusivec4.curios.api.event.CurioDropsEvent;
import top.theillusivec4.curios.api.event.DropRulesEvent;
import top.theillusivec4.curios.api.type.ICuriosMenu;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.CuriosConfig;
import top.theillusivec4.curios.common.CuriosRegistry;
import top.theillusivec4.curios.common.data.CuriosEntityManager;
import top.theillusivec4.curios.common.data.CuriosSlotManager;
import top.theillusivec4.curios.common.inventory.container.CuriosContainer;
import top.theillusivec4.curios.common.network.server.SPacketSetIcons;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncCurios;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncData;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncModifiers;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncStack;

public class CuriosEventHandler {
    public static boolean dirtyTags = false;
    static Map<UUID, Pair<Long, Boolean>> enderManMaskCache = new HashMap<UUID, Pair<Long, Boolean>>();

    private static void handleDrops(String identifier, LivingEntity livingEntity, List<Tuple<Predicate<ItemStack>, ICurio.DropRule>> dropRules, NonNullList<Boolean> renders, IDynamicStackHandler stacks, boolean cosmetic, Collection<ItemEntity> drops, boolean keepInventory, LivingDropsEvent evt) {
        for (int i = 0; i < stacks.getSlots(); ++i) {
            ICurio.DropRule dropRule;
            ItemStack stack = stacks.getStackInSlot(i);
            SlotContext slotContext = new SlotContext(identifier, livingEntity, i, cosmetic, renders.size() > i && (Boolean)renders.get(i) != false);
            if (stack.isEmpty()) continue;
            ICurio.DropRule dropRuleOverride = null;
            for (Tuple<Predicate<ItemStack>, ICurio.DropRule> override : dropRules) {
                if (!((Predicate)override.getA()).test(stack)) continue;
                dropRuleOverride = (ICurio.DropRule)((Object)override.getB());
            }
            ICurio.DropRule dropRule2 = dropRule = dropRuleOverride != null ? dropRuleOverride : CuriosApi.getCurio(stack).map(curio -> curio.getDropRule(slotContext, evt.getSource(), 0, evt.isRecentlyHit())).orElse(ICurio.DropRule.DEFAULT);
            if (dropRule == ICurio.DropRule.DEFAULT) {
                dropRule = CuriosApi.getSlot(identifier, livingEntity.level()).map(ISlotType::getDropRule).orElse(ICurio.DropRule.DEFAULT);
            }
            if (dropRule == ICurio.DropRule.DEFAULT && keepInventory || dropRule == ICurio.DropRule.ALWAYS_KEEP) continue;
            if (!EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP) && dropRule != ICurio.DropRule.DESTROY) {
                drops.add(CuriosEventHandler.getDroppedItem(stack, livingEntity));
            }
            stacks.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    private static ItemEntity getDroppedItem(ItemStack droppedItem, LivingEntity livingEntity) {
        double d0 = livingEntity.getY() - (double)0.3f + (double)livingEntity.getEyeHeight();
        ItemEntity entityitem = new ItemEntity(livingEntity.level(), livingEntity.getX(), d0, livingEntity.getZ(), droppedItem);
        entityitem.setPickUpDelay(40);
        float f = livingEntity.level().random.nextFloat() * 0.5f;
        float f1 = livingEntity.level().random.nextFloat() * ((float)Math.PI * 2);
        entityitem.setDeltaMovement((double)(-Mth.sin((float)f1) * f), (double)0.2f, (double)(Mth.cos((float)f1) * f));
        return entityitem;
    }

    private static boolean handleMending(Player player, IDynamicStackHandler stacks, PlayerXpEvent.PickupXp evt) {
        Holder.Reference mendingHolder = player.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.MENDING);
        for (int i = 0; i < stacks.getSlots(); ++i) {
            ItemStack stack = stacks.getStackInSlot(i);
            if (stack.isEmpty() || stack.getEnchantmentLevel((Holder)mendingHolder) <= 0 || !stack.isDamaged()) continue;
            evt.setCanceled(true);
            ExperienceOrb orb = evt.getOrb();
            player.takeXpDelay = 2;
            player.take((Entity)orb, 1);
            int toRepair = Math.min(orb.value * 2, stack.getDamageValue());
            orb.value -= toRepair / 2;
            stack.setDamageValue(stack.getDamageValue() - toRepair);
            if (orb.value > 0) {
                player.giveExperiencePoints(orb.value);
            }
            orb.remove(Entity.RemovalReason.KILLED);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent evt) {
        Player playerEntity = evt.getEntity();
        if (playerEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
            Collection<ISlotType> slotTypes = CuriosApi.getPlayerSlots(playerEntity).values();
            HashMap<String, ResourceLocation> icons = new HashMap<String, ResourceLocation>();
            slotTypes.forEach(type -> icons.put(type.getIdentifier(), type.getIcon()));
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SPacketSetIcons(icons), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public void onDatapackSync(OnDatapackSyncEvent evt) {
        if (evt.getPlayer() == null) {
            PlayerList playerList = evt.getPlayerList();
            for (ServerPlayer player : playerList.getPlayers()) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SPacketSyncData(CuriosSlotManager.getSyncPacket(), CuriosEntityManager.getSyncPacket()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
                    Tag tag = handler.writeTag();
                    for (Map.Entry<String, ICurioStacksHandler> entry : handler.getCurios().entrySet()) {
                        ICurioStacksHandler stacks = entry.getValue();
                        for (int i = 0; i < stacks.getSlots(); ++i) {
                            stacks.getStacks().setStackInSlot(i, ItemStack.EMPTY);
                            stacks.getCosmeticStacks().setStackInSlot(i, ItemStack.EMPTY);
                        }
                    }
                    handler.readTag(tag);
                    PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)new SPacketSyncCurios(player.getId(), handler.getCurios()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    AbstractContainerMenu patt0$temp = player.containerMenu;
                    if (patt0$temp instanceof ICuriosMenu) {
                        ICuriosMenu curiosContainer = (ICuriosMenu)patt0$temp;
                        curiosContainer.resetSlots();
                    }
                });
                Collection<ISlotType> slotTypes = CuriosApi.getPlayerSlots((Player)player).values();
                HashMap<String, ResourceLocation> icons = new HashMap<String, ResourceLocation>();
                slotTypes.forEach(type -> icons.put(type.getIdentifier(), type.getIcon()));
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new SPacketSetIcons(icons), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        } else {
            ServerPlayer mp = evt.getPlayer();
            PacketDistributor.sendToPlayer((ServerPlayer)mp, (CustomPacketPayload)new SPacketSyncData(CuriosSlotManager.getSyncPacket(), CuriosEntityManager.getSyncPacket()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            CuriosApi.getCuriosInventory((LivingEntity)mp).ifPresent(handler -> {
                Tag tag = handler.writeTag();
                for (Map.Entry<String, ICurioStacksHandler> entry : handler.getCurios().entrySet()) {
                    ICurioStacksHandler stacks = entry.getValue();
                    for (int i = 0; i < stacks.getSlots(); ++i) {
                        stacks.getStacks().setStackInSlot(i, ItemStack.EMPTY);
                        stacks.getCosmeticStacks().setStackInSlot(i, ItemStack.EMPTY);
                    }
                }
                handler.readTag(tag);
                PacketDistributor.sendToPlayer((ServerPlayer)mp, (CustomPacketPayload)new SPacketSyncCurios(mp.getId(), handler.getCurios()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                AbstractContainerMenu patt0$temp = mp.containerMenu;
                if (patt0$temp instanceof ICuriosMenu) {
                    ICuriosMenu curiosContainer = (ICuriosMenu)patt0$temp;
                    curiosContainer.resetSlots();
                }
            });
            Collection<ISlotType> slotTypes = CuriosApi.getPlayerSlots((Player)mp).values();
            HashMap<String, ResourceLocation> icons = new HashMap<String, ResourceLocation>();
            slotTypes.forEach(type -> icons.put(type.getIdentifier(), type.getIcon()));
            PacketDistributor.sendToPlayer((ServerPlayer)mp, (CustomPacketPayload)new SPacketSetIcons(icons), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public void entityConstructing(EntityEvent.EntityConstructing evt) {
        Entity entity = evt.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            CuriosApi.getCuriosInventory(livingEntity).ifPresent(inv -> {
                Tag tag = inv.writeTag();
                for (Map.Entry<String, ICurioStacksHandler> entry : inv.getCurios().entrySet()) {
                    ICurioStacksHandler stacks = entry.getValue();
                    for (int i = 0; i < stacks.getSlots(); ++i) {
                        stacks.getStacks().setStackInSlot(i, ItemStack.EMPTY);
                        stacks.getCosmeticStacks().setStackInSlot(i, ItemStack.EMPTY);
                    }
                }
                inv.readTag(tag);
            });
        }
    }

    @SubscribeEvent
    public void entityJoinWorld(EntityJoinLevelEvent evt) {
        Entity entity = evt.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)entity;
            CuriosApi.getCuriosInventory((LivingEntity)serverPlayerEntity).ifPresent(handler -> {
                ServerPlayer mp = (ServerPlayer)entity;
                PacketDistributor.sendToPlayer((ServerPlayer)mp, (CustomPacketPayload)new SPacketSyncCurios(mp.getId(), handler.getCurios()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            });
        }
    }

    @SubscribeEvent
    public void playerStartTracking(PlayerEvent.StartTracking evt) {
        Entity target = evt.getTarget();
        Player player = evt.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (target instanceof LivingEntity) {
                LivingEntity livingBase = (LivingEntity)target;
                CuriosApi.getCuriosInventory(livingBase).ifPresent(handler -> PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SPacketSyncCurios(target.getId(), handler.getCurios()), (CustomPacketPayload[])new CustomPacketPayload[0]));
            }
        }
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone evt) {
        Player player = evt.getEntity();
        Player oldPlayer = evt.getOriginal();
        Optional<ICuriosItemHandler> oldHandler = CuriosApi.getCuriosInventory((LivingEntity)oldPlayer);
        Optional<ICuriosItemHandler> newHandler = CuriosApi.getCuriosInventory((LivingEntity)player);
        oldHandler.ifPresent(oldCurios -> newHandler.ifPresent(newCurios -> newCurios.readTag(oldCurios.writeTag())));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerDrops(LivingDropsEvent evt) {
        LivingEntity livingEntity = evt.getEntity();
        if (!livingEntity.isSpectator()) {
            CuriosApi.getCuriosInventory(livingEntity).ifPresent(handler -> {
                Collection drops = evt.getDrops();
                ArrayList<ItemEntity> curioDrops = new ArrayList<ItemEntity>();
                Map<String, ICurioStacksHandler> curios = handler.getCurios();
                DropRulesEvent dropRulesEvent = new DropRulesEvent(livingEntity, (ICuriosItemHandler)handler, evt.getSource(), 0, evt.isRecentlyHit());
                NeoForge.EVENT_BUS.post((Event)dropRulesEvent);
                ImmutableList<Tuple<Predicate<ItemStack>, ICurio.DropRule>> dropRules = dropRulesEvent.getOverrides();
                boolean keepInventory = false;
                if (livingEntity instanceof Player) {
                    keepInventory = livingEntity.level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY);
                    if (CuriosConfig.SERVER.keepCurios.get() != CuriosConfig.KeepCurios.DEFAULT) {
                        keepInventory = CuriosConfig.SERVER.keepCurios.get() == CuriosConfig.KeepCurios.ON;
                    }
                }
                boolean finalKeepInventory = keepInventory;
                curios.forEach((id, stacksHandler) -> {
                    CuriosEventHandler.handleDrops(id, livingEntity, dropRules, stacksHandler.getRenders(), stacksHandler.getStacks(), false, curioDrops, finalKeepInventory, evt);
                    CuriosEventHandler.handleDrops(id, livingEntity, dropRules, stacksHandler.getRenders(), stacksHandler.getCosmeticStacks(), true, curioDrops, finalKeepInventory, evt);
                });
                CurioDropsEvent dropsEvent = (CurioDropsEvent)NeoForge.EVENT_BUS.post((Event)new CurioDropsEvent(livingEntity, (ICuriosItemHandler)handler, evt.getSource(), (Collection<ItemEntity>)curioDrops, 0, evt.isRecentlyHit()));
                if (!dropsEvent.isCanceled()) {
                    drops.addAll(curioDrops);
                }
            });
        }
    }

    @SubscribeEvent
    public void playerXPPickUp(PlayerXpEvent.PickupXp evt) {
        Player player = evt.getEntity();
        if (!player.level().isClientSide) {
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
                Map<String, ICurioStacksHandler> curios = handler.getCurios();
                for (ICurioStacksHandler stacksHandler : curios.values()) {
                    if (!CuriosEventHandler.handleMending(player, stacksHandler.getStacks(), evt) && !CuriosEventHandler.handleMending(player, stacksHandler.getCosmeticStacks(), evt)) continue;
                    return;
                }
            });
        }
    }

    @SubscribeEvent
    public void curioRightClick(PlayerInteractEvent.RightClickItem evt) {
        Player player = evt.getEntity();
        ItemStack stack = evt.getItemStack();
        CuriosApi.getCurio(stack).ifPresent(curio -> CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            Tuple firstSlot = null;
            for (Map.Entry<String, ICurioStacksHandler> entry : curios.entrySet()) {
                IDynamicStackHandler stackHandler = entry.getValue().getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    String id = entry.getKey();
                    NonNullList<Boolean> renderStates = entry.getValue().getRenders();
                    SlotContext slotContext = new SlotContext(id, (LivingEntity)player, i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false);
                    if (!stackHandler.isItemValid(i, stack) || !curio.canEquipFromUse(slotContext)) continue;
                    ItemStack present = stackHandler.getStackInSlot(i);
                    if (present.isEmpty()) {
                        stackHandler.setStackInSlot(i, stack.copy());
                        curio.onEquipFromUse(slotContext);
                        if (!player.isCreative()) {
                            int count = stack.getCount();
                            stack.shrink(count);
                        }
                        evt.setCancellationResult(InteractionResult.sidedSuccess((boolean)player.level().isClientSide()));
                        evt.setCanceled(true);
                        return;
                    }
                    if (firstSlot != null || stackHandler.extractItem(i, stack.getMaxStackSize(), true).getCount() != stack.getCount()) continue;
                    firstSlot = new Tuple((Object)stackHandler, (Object)slotContext);
                }
            }
            if (firstSlot != null) {
                IDynamicStackHandler stackHandler = (IDynamicStackHandler)firstSlot.getA();
                SlotContext slotContext = (SlotContext)firstSlot.getB();
                int i = slotContext.index();
                ItemStack present = stackHandler.getStackInSlot(i);
                stackHandler.setStackInSlot(i, stack.copy());
                curio.onEquipFromUse(slotContext);
                player.setItemInHand(evt.getHand(), present.copy());
                evt.setCancellationResult(InteractionResult.sidedSuccess((boolean)player.level().isClientSide()));
                evt.setCanceled(true);
            }
        }));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBreakBlock(BlockDropsEvent event) {
        Entity entity;
        AtomicInteger experience = new AtomicInteger(event.getDroppedExperience());
        if (experience.get() <= 0 || !((entity = event.getBreaker()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        CuriosApi.getCuriosInventory(entity2).ifPresent(handler -> {
            for (Map.Entry<String, ICurioStacksHandler> entry : handler.getCurios().entrySet()) {
                IDynamicStackHandler stacks = entry.getValue().getStacks();
                NonNullList<Boolean> renderStates = entry.getValue().getRenders();
                for (int i = 0; i < stacks.getSlots(); ++i) {
                    SlotContext context = new SlotContext(entry.getKey(), entity2, i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false);
                    experience.addAndGet(EnchantmentHelper.processBlockExperience((ServerLevel)event.getLevel(), (ItemStack)event.getTool(), (int)CuriosApi.getCurio(stacks.getStackInSlot(i)).map(curio -> curio.getFortuneLevel(context, null)).orElse(0)));
                }
            }
        });
        event.setDroppedExperience(experience.get());
    }

    @SubscribeEvent
    public void enderManAnger(EnderManAngerEvent evt) {
        Pair<Long, Boolean> pair;
        if (enderManMaskCache.size() > 500) {
            enderManMaskCache.clear();
        }
        Player player = evt.getPlayer();
        long gameTime = player.level().getGameTime();
        if (enderManMaskCache.containsKey(player.getUUID()) && (Long)(pair = enderManMaskCache.get(player.getUUID())).getFirst() == gameTime) {
            evt.setCanceled(((Boolean)pair.getSecond()).booleanValue());
            return;
        }
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
            block0: for (Map.Entry<String, ICurioStacksHandler> entry : handler.getCurios().entrySet()) {
                IDynamicStackHandler stacks = entry.getValue().getStacks();
                for (int i = 0; i < stacks.getSlots(); ++i) {
                    int index = i;
                    NonNullList<Boolean> renderStates = entry.getValue().getRenders();
                    boolean hasMask = CuriosApi.getCurio(stacks.getStackInSlot(i)).map(curio -> curio.isEnderMask(new SlotContext((String)entry.getKey(), (LivingEntity)player, index, false, renderStates.size() > index && (Boolean)renderStates.get(index) != false), evt.getEntity())).orElse(false);
                    if (!hasMask) continue;
                    enderManMaskCache.put(player.getUUID(), (Pair<Long, Boolean>)Pair.of((Object)gameTime, (Object)true));
                    evt.setCanceled(true);
                    break block0;
                }
            }
        });
        enderManMaskCache.put(player.getUUID(), (Pair<Long, Boolean>)Pair.of((Object)gameTime, (Object)false));
    }

    @SubscribeEvent
    public void tick(EntityTickEvent.Post evt) {
        Entity entity = evt.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                AbstractContainerMenu abstractContainerMenu = player.containerMenu;
                if (abstractContainerMenu instanceof CuriosContainer) {
                    CuriosContainer curiosContainer = (CuriosContainer)abstractContainerMenu;
                    curiosContainer.checkQuickMove();
                }
            }
            CuriosApi.getCuriosInventory(livingEntity).ifPresent(handler -> {
                Set<ICurioStacksHandler> updates;
                handler.clearCachedSlotModifiers();
                handler.handleInvalidStacks();
                Map<String, ICurioStacksHandler> curios = handler.getCurios();
                for (Map.Entry<String, ICurioStacksHandler> entry : curios.entrySet()) {
                    ICurioStacksHandler stacksHandler = entry.getValue();
                    String identifier = entry.getKey();
                    IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                    IDynamicStackHandler cosmeticStackHandler = stacksHandler.getCosmeticStacks();
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        ItemStack prevCosmeticStack;
                        ItemStack cosmeticStack;
                        NonNullList<Boolean> renderStates = stacksHandler.getRenders();
                        SlotContext slotContext = new SlotContext(identifier, livingEntity, i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false);
                        ItemStack stack = stackHandler.getStackInSlot(i);
                        Optional<ICurio> currentCurio = CuriosApi.getCurio(stack);
                        if (!stack.isEmpty()) {
                            stack.inventoryTick(livingEntity.level(), (Entity)livingEntity, -1, false);
                            currentCurio.ifPresent(curio -> curio.curioTick(slotContext));
                        }
                        if (livingEntity.level().isClientSide) continue;
                        ItemStack prevStack = stackHandler.getPreviousStackInSlot(i);
                        if (!ItemStack.matches((ItemStack)stack, (ItemStack)prevStack)) {
                            SlotAttribute wrapper;
                            Object patt0$temp;
                            HashSet<Holder> toRemove;
                            HashMultimap slots;
                            Multimap<Holder<Attribute>, AttributeModifier> map;
                            Optional<ICurio> prevCurio = CuriosApi.getCurio(prevStack);
                            CuriosEventHandler.syncCurios(livingEntity, stack, currentCurio, prevCurio, identifier, i, false, renderStates.size() > i && (Boolean)renderStates.get(i) != false, SPacketSyncStack.HandlerType.EQUIPMENT);
                            NeoForge.EVENT_BUS.post((Event)new CurioChangeEvent(livingEntity, identifier, i, prevStack, stack));
                            ResourceLocation id = CuriosApi.getSlotId(slotContext);
                            AttributeMap attributeMap = livingEntity.getAttributes();
                            if (!prevStack.isEmpty()) {
                                map = CuriosApi.getAttributeModifiers(slotContext, id, prevStack);
                                slots = HashMultimap.create();
                                toRemove = new HashSet<Holder>();
                                for (Holder attribute : map.keySet()) {
                                    patt0$temp = attribute.value();
                                    if (!(patt0$temp instanceof SlotAttribute)) continue;
                                    wrapper = (SlotAttribute)((Object)((Object)patt0$temp));
                                    slots.putAll((Object)wrapper.getIdentifier(), (Iterable)map.get((Object)attribute));
                                    toRemove.add(attribute);
                                }
                                for (Holder attribute : toRemove) {
                                    map.removeAll((Object)attribute);
                                }
                                map.forEach((key, value) -> {
                                    AttributeInstance attInst = attributeMap.getInstance(key);
                                    if (attInst != null) {
                                        attInst.removeModifier(value);
                                    }
                                });
                                handler.removeSlotModifiers((Multimap<String, AttributeModifier>)slots);
                                prevCurio.ifPresent(curio -> curio.onUnequip(slotContext, stack));
                            }
                            if (!stack.isEmpty()) {
                                map = CuriosApi.getAttributeModifiers(slotContext, id, stack);
                                slots = HashMultimap.create();
                                toRemove = new HashSet();
                                for (Holder attribute : map.keySet()) {
                                    patt0$temp = attribute.value();
                                    if (!(patt0$temp instanceof SlotAttribute)) continue;
                                    wrapper = (SlotAttribute)((Object)((Object)patt0$temp));
                                    slots.putAll((Object)wrapper.getIdentifier(), (Iterable)map.get((Object)attribute));
                                    toRemove.add(attribute);
                                }
                                for (Holder attribute : toRemove) {
                                    map.removeAll((Object)attribute);
                                }
                                map.forEach((key, value) -> {
                                    AttributeInstance attInst = attributeMap.getInstance(key);
                                    if (attInst != null) {
                                        attInst.addOrUpdateTransientModifier(value);
                                    }
                                });
                                handler.addTransientSlotModifiers((Multimap<String, AttributeModifier>)slots);
                                currentCurio.ifPresent(curio -> curio.onEquip(slotContext, prevStack));
                                if (livingEntity instanceof ServerPlayer) {
                                    CuriosRegistry.EQUIP_TRIGGER.get().trigger(slotContext, (ServerPlayer)livingEntity, stack);
                                }
                            }
                            stackHandler.setPreviousStackInSlot(i, stack.copy());
                        }
                        if (ItemStack.matches((ItemStack)(cosmeticStack = cosmeticStackHandler.getStackInSlot(i)), (ItemStack)(prevCosmeticStack = cosmeticStackHandler.getPreviousStackInSlot(i)))) continue;
                        CuriosEventHandler.syncCurios(livingEntity, cosmeticStack, CuriosApi.getCurio(cosmeticStack), CuriosApi.getCurio(prevCosmeticStack), identifier, i, true, true, SPacketSyncStack.HandlerType.COSMETIC);
                        cosmeticStackHandler.setPreviousStackInSlot(i, cosmeticStack.copy());
                    }
                }
                if (!livingEntity.level().isClientSide() && !(updates = handler.getUpdatingInventories()).isEmpty()) {
                    PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)livingEntity, (CustomPacketPayload)new SPacketSyncModifiers(livingEntity.getId(), updates), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    updates.clear();
                }
            });
        }
    }

    @SubscribeEvent
    public void livingEquipmentChange(LivingEquipmentChangeEvent evt) {
        CuriosApi.getCuriosInventory(evt.getEntity()).ifPresent(inv -> {
            HashMultimap slots;
            ItemStack from = evt.getFrom();
            ItemStack to = evt.getTo();
            EquipmentSlot slot = evt.getSlot();
            if (!from.isEmpty()) {
                slots = HashMultimap.create();
                from.forEachModifier(slot, (arg_0, arg_1) -> CuriosEventHandler.lambda$livingEquipmentChange$26((Multimap)slots, arg_0, arg_1));
                inv.removeSlotModifiers((Multimap<String, AttributeModifier>)slots);
            }
            if (!to.isEmpty()) {
                slots = HashMultimap.create();
                to.forEachModifier(slot, (arg_0, arg_1) -> CuriosEventHandler.lambda$livingEquipmentChange$27((Multimap)slots, arg_0, arg_1));
                inv.addTransientSlotModifiers((Multimap<String, AttributeModifier>)slots);
            }
        });
    }

    private static void syncCurios(LivingEntity livingEntity, ItemStack stack, Optional<ICurio> currentCurio, Optional<ICurio> prevCurio, String identifier, int index, boolean cosmetic, boolean visible, SPacketSyncStack.HandlerType type) {
        SlotContext slotContext = new SlotContext(identifier, livingEntity, index, cosmetic, visible);
        boolean syncable = currentCurio.map(curio -> curio.canSync(slotContext)).orElse(false) != false || prevCurio.map(curio -> curio.canSync(slotContext)).orElse(false) != false;
        CompoundTag syncTag = syncable ? currentCurio.map(curio -> curio.writeSyncData(slotContext)).orElse(new CompoundTag()) : new CompoundTag();
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)livingEntity, (CustomPacketPayload)new SPacketSyncStack(livingEntity.getId(), identifier, index, stack, type.ordinal(), syncTag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static /* synthetic */ void lambda$livingEquipmentChange$27(Multimap slots, Holder att, AttributeModifier modifier) {
        Object patt0$temp = att.value();
        if (patt0$temp instanceof SlotAttribute) {
            SlotAttribute wrapper = (SlotAttribute)((Object)patt0$temp);
            slots.putAll((Object)wrapper.getIdentifier(), Collections.singleton(modifier));
        }
    }

    private static /* synthetic */ void lambda$livingEquipmentChange$26(Multimap slots, Holder att, AttributeModifier modifier) {
        Object patt0$temp = att.value();
        if (patt0$temp instanceof SlotAttribute) {
            SlotAttribute wrapper = (SlotAttribute)((Object)patt0$temp);
            slots.putAll((Object)wrapper.getIdentifier(), Collections.singleton(modifier));
        }
    }
}

