/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.neoauth.mixin;

import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import com.mrbysco.neoauth.NeoAuth;
import com.mrbysco.neoauth.impl.gui.AuthMethodScreen;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.realms.RealmsScreen;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RealmsGenericErrorScreen.class})
public abstract class RealmsGenericErrorScreenMixin
extends RealmsScreen {
    @Shadow
    @Final
    private Screen nextScreen;
    @Shadow
    @Final
    private RealmsGenericErrorScreen.ErrorMessage lines;

    private RealmsGenericErrorScreenMixin(Component title) {
        super(title);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        if (RealmsGenericErrorScreenMixin.isUserRelated(this.lines.detail())) {
            NeoAuth.LOGGER.info("Adding auth button to the Realms error screen");
            assert (this.minecraft != null);
            Button backButton = (Button)this.children().getFirst();
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.neo_auth.button.relogin"), btn -> this.minecraft.setScreen((Screen)new AuthMethodScreen(this.nextScreen))).bounds(backButton.getX(), backButton.getY() - backButton.getHeight() - 4, backButton.getWidth(), backButton.getHeight()).build());
        }
    }

    @Unique
    private static boolean isUserRelated(@Nullable Component reason) {
        ComponentContents componentContents;
        if (reason != null && (componentContents = reason.getContents()) instanceof TranslatableContents) {
            TranslatableContents content = (TranslatableContents)componentContents;
            String key = content.getKey();
            return key != null && key.startsWith("mco.error.invalid.session");
        }
        return false;
    }
}

