/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat.unification;

import com.almostreliable.unified.api.unification.bundled.GenericRecipeUnifier;
import com.almostreliable.unified.api.unification.recipe.RecipeJson;
import com.almostreliable.unified.api.unification.recipe.RecipeUnifier;
import com.almostreliable.unified.api.unification.recipe.UnificationHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;

public class ImmersiveEngineeringRecipeUnifier
implements RecipeUnifier {
    private static final String INPUT_0 = "input0";
    private static final String INPUT_1 = "input1";
    private static final String ADDITIVES = "additives";
    private static final String BASE_INGREDIENT = "base_ingredient";
    private static final String SECONDARIES = "secondaries";
    private static final String SLAG = "slag";

    @Override
    public void unify(UnificationHelper helper, RecipeJson recipe) {
        GenericRecipeUnifier.INSTANCE.unify(helper, recipe);
        List.of(INPUT_0, INPUT_1, "input", ADDITIVES, "catalyst").forEach(key -> this.unifyInputs(helper, recipe, (String)key));
        List.of("result", "results", SLAG).forEach(key -> helper.unifyOutputs(recipe, (String)key, true, "item", BASE_INGREDIENT));
        this.unifySecondaries(helper, recipe);
    }

    public void unifyInputs(UnificationHelper helper, RecipeJson recipe, String key) {
        JsonObject json;
        JsonElement jsonElement = recipe.getProperty(key);
        if (jsonElement instanceof JsonObject && (json = (JsonObject)jsonElement).has(BASE_INGREDIENT) && helper.unifyInputElement(json.get(BASE_INGREDIENT), new String[0])) {
            return;
        }
        helper.unifyInputs(recipe, key);
    }

    public void unifySecondaries(UnificationHelper helper, RecipeJson recipe) {
        JsonElement secondaries = recipe.getProperty(SECONDARIES);
        if (secondaries == null) {
            return;
        }
        helper.unifyOutputArray(secondaries.getAsJsonArray(), true, "output");
    }
}

