/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tileentity;

import com.blakebr0.cucumber.energy.BaseEnergyStorage;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.CachedRecipe;
import com.blakebr0.cucumber.inventory.OnContentsChangedFunction;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.api.crafting.ICompressorRecipe;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.container.CompressorContainer;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CompressorTileEntity
extends BaseInventoryTileEntity
implements MenuProvider {
    private final BaseItemStackHandler inventory;
    private final BaseItemStackHandler recipeInventory;
    private final BaseEnergyStorage energy;
    private final CachedRecipe<CraftingInput, ICompressorRecipe> recipe;
    private ItemStack materialStack = ItemStack.EMPTY;
    private List<MaterialInput> inputs = NonNullList.create();
    private int materialCount;
    private int progress;
    private boolean ejecting = false;
    private boolean inputLimit = true;

    public CompressorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.COMPRESSOR.get(), pos, state);
        this.inventory = CompressorTileEntity.createInventoryHandler(null);
        this.recipeInventory = BaseItemStackHandler.create((int)2);
        this.energy = new BaseEnergyStorage(((Integer)ModConfigs.COMPRESSOR_POWER_CAPACITY.get()).intValue(), () -> ((CompressorTileEntity)this).setChangedFast());
        this.recipe = new CachedRecipe((RecipeType)ModRecipeTypes.COMPRESSOR.get());
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        this.materialCount = tag.getInt("MaterialCount");
        this.materialStack = ItemStack.parseOptional((HolderLookup.Provider)lookup, (CompoundTag)tag.getCompound("MaterialStack"));
        this.progress = tag.getInt("Progress");
        this.ejecting = tag.getBoolean("Ejecting");
        this.energy.deserializeNBT(lookup, tag.get("Energy"));
        this.inputLimit = tag.getBoolean("InputLimit");
        this.inputs = CompressorTileEntity.loadMaterialInputs(lookup, tag);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.putInt("MaterialCount", this.materialCount);
        tag.put("MaterialStack", this.materialStack.saveOptional(lookup));
        tag.putInt("Progress", this.progress);
        tag.putBoolean("Ejecting", this.ejecting);
        tag.putInt("Energy", this.energy.getEnergyStored());
        tag.putBoolean("InputLimit", this.inputLimit);
        CompressorTileEntity.saveMaterialInputs(lookup, tag, this.inputs);
    }

    public Component getDisplayName() {
        return Localizable.of((String)"container.extendedcrafting.compressor").build();
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player playerEntity) {
        return CompressorContainer.create(windowId, playerInventory, this.inventory, this.getBlockPos());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CompressorTileEntity tile) {
        ICompressorRecipe recipe = tile.getActiveRecipe();
        ItemStack output = tile.inventory.getStackInSlot(0);
        ItemStack input = tile.inventory.getStackInSlot(1);
        if (!input.isEmpty()) {
            int index;
            if (tile.materialStack.isEmpty() || tile.materialCount <= 0) {
                tile.materialStack = input.copy();
                tile.setChangedFast();
            }
            if ((!tile.inputLimit || recipe != null && tile.materialCount < recipe.getCount(0)) && (index = tile.canInsertItem(input)) > -1) {
                tile.insertItem(index, input);
                tile.setChangedFast();
            }
        }
        if (recipe != null && tile.getEnergy().getEnergyStored() > 0 && tile.materialCount >= recipe.getCount(0)) {
            if (tile.progress >= recipe.getPowerCost()) {
                ItemStack result = recipe.assemble((RecipeInput)tile.toCraftingInput(), (HolderLookup.Provider)level.registryAccess());
                if (StackHelper.canCombineStacks((ItemStack)result, (ItemStack)output)) {
                    tile.updateResult(result);
                    tile.progress = 0;
                    tile.materialCount -= recipe.getCount(0);
                    tile.consumeInputs(recipe.getCount(0));
                    if (tile.materialCount <= 0) {
                        tile.materialStack = ItemStack.EMPTY;
                        tile.ejecting = false;
                    }
                    tile.setChangedFast();
                }
            } else {
                tile.process(recipe);
                tile.setChangedFast();
            }
        }
        if (tile.ejecting && !tile.inputs.isEmpty()) {
            int addCount;
            MaterialInput newestInput = tile.getNewestInput();
            ItemStack newestStack = newestInput.stack;
            if (tile.materialCount > 0 && !newestStack.isEmpty() && (output.isEmpty() || StackHelper.areStacksEqual((ItemStack)newestStack, (ItemStack)output)) && (addCount = Math.min(newestInput.count, newestStack.getMaxStackSize() - output.getCount())) > 0) {
                ItemStack toAdd = StackHelper.withSize((ItemStack)newestStack, (int)addCount, (boolean)false);
                tile.updateResult(toAdd);
                tile.materialCount -= addCount;
                newestInput.count -= addCount;
                if (newestInput.count <= 0) {
                    tile.inputs.removeLast();
                }
                if (tile.materialCount < 1) {
                    tile.materialStack = ItemStack.EMPTY;
                    tile.ejecting = false;
                }
                if (tile.progress > 0) {
                    tile.progress = 0;
                }
                tile.setChangedFast();
            }
        }
        tile.dispatchIfChanged();
    }

    public static BaseItemStackHandler createInventoryHandler() {
        return CompressorTileEntity.createInventoryHandler(null);
    }

    public static BaseItemStackHandler createInventoryHandler(OnContentsChangedFunction onContentsChanged) {
        return BaseItemStackHandler.create((int)3, (OnContentsChangedFunction)onContentsChanged, builder -> {
            builder.setOutputSlots(new int[]{0});
            builder.setCanInsert((slot, stack) -> slot == 1);
        });
    }

    public BaseEnergyStorage getEnergy() {
        return this.energy;
    }

    public ItemStack getMaterialStack() {
        return this.materialStack;
    }

    public boolean hasMaterialStack() {
        return !this.materialStack.isEmpty();
    }

    public int getMaterialCount() {
        return this.materialCount;
    }

    public boolean isEjecting() {
        return this.ejecting;
    }

    public void toggleEjecting() {
        if (this.materialCount > 0) {
            this.ejecting = !this.ejecting;
            this.setChangedAndDispatch();
        }
    }

    public boolean isLimitingInput() {
        return this.inputLimit;
    }

    public void toggleInputLimit() {
        this.inputLimit = !this.inputLimit;
        this.setChangedAndDispatch();
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean hasRecipe() {
        return this.recipe.exists();
    }

    public ICompressorRecipe getActiveRecipe() {
        if (this.level == null) {
            return null;
        }
        ItemStack catalyst = this.inventory.getStackInSlot(2);
        this.recipeInventory.setStackInSlot(0, this.materialStack);
        this.recipeInventory.setStackInSlot(1, catalyst);
        return (ICompressorRecipe)this.recipe.checkAndGet((RecipeInput)this.toCraftingInput(), this.level);
    }

    public int getEnergyRequired() {
        if (this.hasRecipe()) {
            return ((ICompressorRecipe)this.recipe.get()).getPowerCost();
        }
        return 0;
    }

    public int getMaterialsRequired() {
        if (this.hasRecipe()) {
            return ((ICompressorRecipe)this.recipe.get()).getCount(0);
        }
        return 0;
    }

    public List<MaterialInput> getInputs() {
        return this.inputs;
    }

    private void process(ICompressorRecipe recipe) {
        int extract = recipe.getPowerRate();
        int difference = recipe.getPowerCost() - this.progress;
        if (difference < extract) {
            extract = difference;
        }
        int extracted = this.energy.extractEnergy(extract, false);
        this.progress += extracted;
    }

    private void updateResult(ItemStack stack) {
        ItemStack result = this.inventory.getStackInSlot(0);
        if (result.isEmpty()) {
            this.inventory.setStackInSlot(0, stack);
        } else {
            this.inventory.setStackInSlot(0, StackHelper.grow((ItemStack)result, (int)stack.getCount()));
        }
    }

    private int canInsertItem(ItemStack stack) {
        Ingredient recipeStack;
        int size = this.inputs.size();
        if (size == 0) {
            return 0;
        }
        for (int i = 0; i < size; ++i) {
            MaterialInput input = this.inputs.get(i);
            if (!StackHelper.areStacksEqual((ItemStack)stack, (ItemStack)input.stack)) continue;
            return i;
        }
        if (size < 100 && this.recipe.exists() && (recipeStack = (Ingredient)((ICompressorRecipe)this.recipe.get()).getIngredients().getFirst()).test(stack)) {
            return size;
        }
        return -1;
    }

    private void insertItem(int index, ItemStack stack) {
        int consumeAmount = stack.getCount();
        if (this.inputLimit) {
            consumeAmount = Math.min(consumeAmount, ((ICompressorRecipe)this.recipe.get()).getCount(0) - this.materialCount);
        }
        if (this.inputs.isEmpty() || this.inputs.size() == index) {
            this.inputs.add(new MaterialInput(stack.copy(), consumeAmount));
        } else {
            MaterialInput input = this.inputs.get(index);
            if (StackHelper.areStacksEqual((ItemStack)stack, (ItemStack)input.stack)) {
                input.count += consumeAmount;
            } else {
                this.inputs.add(new MaterialInput(stack.copy(), consumeAmount));
            }
        }
        stack.shrink(consumeAmount);
        this.materialCount += consumeAmount;
    }

    private MaterialInput getNewestInput() {
        return this.inputs.getLast();
    }

    private void consumeInputs(int amount) {
        for (int i = this.inputs.size() - 1; i > -1; --i) {
            MaterialInput input = this.inputs.get(i);
            if (input.count > amount) {
                input.count -= amount;
                break;
            }
            amount -= input.count;
            this.inputs.remove(i);
        }
    }

    private CraftingInput toCraftingInput() {
        return this.recipeInventory.toShapelessCraftingInput();
    }

    private static List<MaterialInput> loadMaterialInputs(HolderLookup.Provider lookup, CompoundTag tag) {
        ListTag list = tag.getList("Inputs", 10);
        ArrayList<MaterialInput> inputs = new ArrayList<MaterialInput>();
        for (int i = 0; i < list.size(); ++i) {
            inputs.add(MaterialInput.load(lookup, list.getCompound(i)));
        }
        if (tag.contains("MaterialStack") && inputs.isEmpty()) {
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)lookup, (CompoundTag)tag.getCompound("MaterialStack"));
            int count = tag.getInt("MaterialCount");
            if (count > 0) {
                inputs.add(new MaterialInput(stack, count));
            }
        }
        return inputs;
    }

    private static void saveMaterialInputs(HolderLookup.Provider lookup, CompoundTag tag, List<MaterialInput> inputs) {
        ListTag list = new ListTag();
        for (MaterialInput input : inputs) {
            list.add((Object)input.save(lookup));
        }
        tag.put("Inputs", (Tag)list);
    }

    public static class MaterialInput {
        public ItemStack stack;
        public int count;

        public MaterialInput(ItemStack stack, int count) {
            this.stack = stack;
            this.count = count;
        }

        public Component getDisplayName() {
            return Component.literal((String)(this.count + "x ")).append(this.stack.getHoverName());
        }

        public CompoundTag save(HolderLookup.Provider lookup) {
            CompoundTag tag = new CompoundTag();
            tag.put("Item", this.stack.save(lookup));
            tag.putInt("Count", this.count);
            return tag;
        }

        public static MaterialInput load(HolderLookup.Provider lookup, CompoundTag tag) {
            ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)lookup, (CompoundTag)tag.getCompound("Item"));
            int count = tag.getInt("Count");
            return new MaterialInput(stack, count);
        }
    }
}

