/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tileentity;

import com.blakebr0.cucumber.energy.BaseEnergyStorage;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.OnContentsChangedFunction;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.api.TableCraftingInput;
import com.blakebr0.extendedcrafting.api.crafting.ITableRecipe;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.container.AdvancedAutoTableContainer;
import com.blakebr0.extendedcrafting.container.BasicAutoTableContainer;
import com.blakebr0.extendedcrafting.container.EliteAutoTableContainer;
import com.blakebr0.extendedcrafting.container.UltimateAutoTableContainer;
import com.blakebr0.extendedcrafting.crafting.TableRecipeStorage;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import com.mojang.datafixers.util.Either;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public abstract class AutoTableTileEntity
extends BaseInventoryTileEntity
implements MenuProvider {
    @Nullable
    private Either<Recipe<CraftingInput>, ITableRecipe> recipe;
    private int progress;
    private boolean running = true;
    private boolean isGridChanged = true;

    public AutoTableTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        this.progress = tag.getInt("Progress");
        this.running = tag.getBoolean("Running");
        this.getEnergy().deserializeNBT(lookup, tag.get("Energy"));
        this.getRecipeStorage().deserializeNBT(lookup, tag);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.putInt("Progress", this.progress);
        tag.putBoolean("Running", this.running);
        tag.putInt("Energy", this.getEnergy().getEnergyStored());
        tag.merge(this.getRecipeStorage().serializeNBT(lookup));
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && !this.level.isClientSide()) {
            this.getRecipeStorage().validate(inventory -> {
                TableCraftingInput tableInventory = TableCraftingInput.of(inventory.width(), inventory.height(), inventory.items(), this.getTier());
                return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.TABLE.get(), (RecipeInput)tableInventory, this.level).map(r -> ((ITableRecipe)r.value()).assemble((RecipeInput)tableInventory, (HolderLookup.Provider)this.level.registryAccess())).orElse(ItemStack.EMPTY);
            });
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AutoTableTileEntity tile) {
        int selected;
        BaseEnergyStorage energy = tile.getEnergy();
        if (tile.running) {
            Either<Recipe<CraftingInput>, ITableRecipe> recipe = tile.getActiveRecipe();
            if (recipe != null && tile.matchesSelectedRecipe(recipe)) {
                TableCraftingInput recipeInventory = tile.getRecipeInventory();
                BaseItemStackHandler inventory = tile.getInventory();
                ItemStack result = (ItemStack)recipe.map(v -> v.assemble((RecipeInput)recipeInventory, (HolderLookup.Provider)level.registryAccess()), t -> t.assemble((RecipeInput)recipeInventory, (HolderLookup.Provider)level.registryAccess()));
                int outputSlot = inventory.getSlots() - 1;
                ItemStack output = inventory.getStackInSlot(outputSlot);
                int powerRate = (Integer)ModConfigs.AUTO_TABLE_POWER_RATE.get();
                if (StackHelper.canCombineStacks((ItemStack)result, (ItemStack)output) && energy.getEnergyStored() >= powerRate) {
                    ++tile.progress;
                    energy.extractEnergy(powerRate, false);
                    if (tile.progress >= tile.getProgressRequired()) {
                        NonNullList remaining = (NonNullList)recipe.map(v -> v.getRemainingItems((RecipeInput)recipeInventory), t -> t.getRemainingItems((RecipeInput)recipeInventory));
                        for (int k = 0; k < recipeInventory.height(); ++k) {
                            for (int l = 0; l < recipeInventory.width(); ++l) {
                                int size = recipeInventory.tier() * 2 + 1;
                                int index = l + recipeInventory.left() + (k + recipeInventory.top()) * size;
                                ItemStack remainingStack = (ItemStack)remaining.get(l + k * recipeInventory.width());
                                if (!remainingStack.isEmpty()) {
                                    inventory.setStackInSlot(index, remainingStack);
                                    continue;
                                }
                                inventory.setStackInSlot(index, StackHelper.shrink((ItemStack)inventory.getStackInSlot(index), (int)1, (boolean)false));
                            }
                        }
                        tile.updateResult(result, outputSlot);
                        tile.progress = 0;
                        tile.isGridChanged = true;
                    }
                    tile.setChangedFast();
                }
            } else if (tile.progress > 0) {
                tile.progress = 0;
                tile.setChangedFast();
            }
        } else if (tile.progress > 0) {
            tile.progress = 0;
            tile.setChangedFast();
        }
        int insertPowerRate = (Integer)ModConfigs.AUTO_TABLE_INSERT_POWER_RATE.get();
        if (tile.getEnergy().getEnergyStored() >= insertPowerRate && (selected = tile.getRecipeStorage().getSelected()) != -1) {
            tile.getAboveInventory().ifPresent(handler -> {
                for (int i = 0; i < handler.getSlots(); ++i) {
                    boolean inserted;
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.isEmpty() || handler.extractItem(i, 1, true).isEmpty() || !(inserted = tile.tryInsertItemIntoGrid(stack))) continue;
                    handler.extractItem(i, 1, false);
                    break;
                }
            });
        }
        tile.dispatchIfChanged();
    }

    public int getProgress() {
        return this.progress;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void toggleRunning() {
        this.running = !this.running;
        this.setChangedAndDispatch();
    }

    public void selectRecipe(int index) {
        this.getRecipeStorage().setSelected(index);
        this.setChangedAndDispatch();
    }

    public void saveRecipe(int index) {
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        TableCraftingInput inventory = this.getRecipeInventory();
        RecipeHolder recipe = level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.TABLE.get(), (RecipeInput)inventory, level).orElse(null);
        ItemStack result = ItemStack.EMPTY;
        if (recipe != null) {
            result = ((ITableRecipe)recipe.value()).assemble((RecipeInput)inventory, (HolderLookup.Provider)level.registryAccess());
        } else {
            RecipeHolder vanilla = level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)inventory, level).orElse(null);
            if (vanilla != null) {
                result = ((CraftingRecipe)vanilla.value()).assemble((RecipeInput)inventory, (HolderLookup.Provider)level.registryAccess());
            }
        }
        this.getRecipeStorage().setRecipe(index, this.getInventory(), result);
        this.setChangedAndDispatch();
    }

    public void deleteRecipe(int index) {
        this.getRecipeStorage().unsetRecipe(index);
        this.setChangedAndDispatch();
    }

    public TableCraftingInput getRecipeInventory() {
        BaseItemStackHandler inventory = this.getInventory();
        int size = (int)Math.sqrt(inventory.getSlots() - 1);
        return TableCraftingInput.of(size, size, inventory.getStacks().subList(0, inventory.getSlots() - 1), this.getTier());
    }

    public Either<Recipe<CraftingInput>, ITableRecipe> getActiveRecipe() {
        if (this.level == null) {
            return null;
        }
        TableCraftingInput inventory = this.getRecipeInventory();
        if (this.isGridChanged && (this.recipe == null || !((Boolean)this.recipe.map(v -> v.matches((RecipeInput)inventory, this.level), t -> t.matches((RecipeInput)inventory, this.level))).booleanValue())) {
            ITableRecipe recipe = this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipeTypes.TABLE.get(), (RecipeInput)inventory, this.level).map(RecipeHolder::value).orElse(null);
            this.recipe = recipe != null ? Either.right((Object)recipe) : null;
            if (recipe == null && ((Boolean)ModConfigs.TABLE_USE_VANILLA_RECIPES.get()).booleanValue() && this instanceof Basic) {
                CraftingRecipe vanillaRecipe = this.level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)inventory, this.level).map(RecipeHolder::value).orElse(null);
                this.recipe = vanillaRecipe != null ? Either.left((Object)vanillaRecipe) : null;
            }
            this.isGridChanged = false;
        }
        return this.recipe;
    }

    public boolean matchesSelectedRecipe(Either<Recipe<CraftingInput>, ITableRecipe> recipe) {
        if (this.level == null) {
            return false;
        }
        BaseItemStackHandler selectedRecipe = this.getRecipeStorage().getSelectedRecipe();
        if (selectedRecipe == null) {
            return true;
        }
        TableCraftingInput inventory = this.getRecipeInventory();
        return (Boolean)recipe.map(v -> v.matches((RecipeInput)inventory, this.level), t -> t.matches((RecipeInput)inventory, this.level));
    }

    public abstract int getProgressRequired();

    public abstract TableRecipeStorage getRecipeStorage();

    public abstract BaseEnergyStorage getEnergy();

    public abstract int getTier();

    protected void onContentsChanged(int slot) {
        this.isGridChanged = true;
        this.setChangedFast();
    }

    private void updateResult(ItemStack stack, int slot) {
        BaseItemStackHandler inventory = this.getInventory();
        ItemStack result = inventory.getStackInSlot(inventory.getSlots() - 1);
        if (result.isEmpty()) {
            inventory.setStackInSlot(slot, stack);
        } else {
            inventory.setStackInSlot(slot, StackHelper.grow((ItemStack)result, (int)stack.getCount()));
        }
    }

    private void addStackToSlot(ItemStack stack, int slot) {
        BaseItemStackHandler inventory = this.getInventory();
        ItemStack stackInSlot = inventory.getStackInSlot(slot);
        if (stackInSlot.isEmpty()) {
            inventory.setStackInSlot(slot, stack);
        } else {
            inventory.setStackInSlot(slot, StackHelper.grow((ItemStack)stackInSlot, (int)stack.getCount()));
        }
    }

    private Optional<IItemHandler> getAboveInventory() {
        Level level = this.getLevel();
        BlockPos pos = this.getBlockPos().above();
        if (level != null) {
            IItemHandler capability = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)Direction.DOWN);
            return Optional.ofNullable(capability);
        }
        return Optional.empty();
    }

    private boolean tryInsertItemIntoGrid(ItemStack input) {
        BaseItemStackHandler inventory = this.getInventory();
        ItemStack stackToPut = ItemStack.EMPTY;
        BaseItemStackHandler recipe = this.getRecipeStorage().getSelectedRecipe();
        int slotToPut = -1;
        boolean isGridChanged = false;
        int slots = inventory.getSlots() - 1;
        for (int i = 0; i < slots; ++i) {
            ItemStack slot = inventory.getStackInSlot(i);
            ItemStack recipeStack = recipe.getStackInSlot(i);
            if (!slot.isEmpty() && !StackHelper.areStacksEqual((ItemStack)input, (ItemStack)slot) || !StackHelper.areStacksEqual((ItemStack)input, (ItemStack)recipeStack) || !slot.isEmpty() && slot.getCount() >= slot.getMaxStackSize()) continue;
            if (slot.isEmpty()) {
                slotToPut = i;
                isGridChanged = true;
                break;
            }
            if (!stackToPut.isEmpty() && slot.getCount() >= stackToPut.getCount()) continue;
            slotToPut = i;
            stackToPut = slot;
        }
        this.isGridChanged |= isGridChanged;
        if (slotToPut > -1) {
            int insertPowerRate = (Integer)ModConfigs.AUTO_TABLE_INSERT_POWER_RATE.get();
            ItemStack toInsert = StackHelper.withSize((ItemStack)input, (int)1, (boolean)false);
            this.addStackToSlot(toInsert, slotToPut);
            this.getEnergy().extractEnergy(insertPowerRate, false);
            return true;
        }
        return false;
    }

    public static class Basic
    extends AutoTableTileEntity {
        private final BaseItemStackHandler inventory = Basic.createInventoryHandler(this::onContentsChanged);
        private final BaseEnergyStorage energy;
        private final TableRecipeStorage recipeStorage = new TableRecipeStorage(10);

        public Basic(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModTileEntities.BASIC_AUTO_TABLE.get(), pos, state);
            this.energy = new BaseEnergyStorage(((Integer)ModConfigs.AUTO_TABLE_POWER_CAPACITY.get()).intValue(), () -> ((Basic)this).setChangedFast());
        }

        public BaseItemStackHandler getInventory() {
            return this.inventory;
        }

        public Component getDisplayName() {
            return Localizable.of((String)"container.extendedcrafting.basic_table").build();
        }

        public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
            return BasicAutoTableContainer.create(windowId, playerInventory, this.inventory, this.getBlockPos());
        }

        @Override
        public int getProgressRequired() {
            return (Integer)ModConfigs.AUTO_TABLE_TIME_REQUIRED.get();
        }

        @Override
        public TableRecipeStorage getRecipeStorage() {
            return this.recipeStorage;
        }

        @Override
        public BaseEnergyStorage getEnergy() {
            return this.energy;
        }

        @Override
        public int getTier() {
            return 1;
        }

        public static BaseItemStackHandler createInventoryHandler() {
            return Basic.createInventoryHandler(null);
        }

        public static BaseItemStackHandler createInventoryHandler(OnContentsChangedFunction onContentsChanged) {
            return BaseItemStackHandler.create((int)10, (OnContentsChangedFunction)onContentsChanged, builder -> {
                builder.setOutputSlots(new int[]{9});
                builder.setCanInsert((slot, stack) -> false);
            });
        }
    }

    public static class Ultimate
    extends AutoTableTileEntity {
        private final BaseItemStackHandler inventory = Ultimate.createInventoryHandler(this::onContentsChanged);
        private final BaseEnergyStorage energy;
        private final TableRecipeStorage recipeStorage = new TableRecipeStorage(82);

        public Ultimate(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModTileEntities.ULTIMATE_AUTO_TABLE.get(), pos, state);
            this.energy = new BaseEnergyStorage((Integer)ModConfigs.AUTO_TABLE_POWER_CAPACITY.get() * 8, () -> ((Ultimate)this).setChangedFast());
        }

        public BaseItemStackHandler getInventory() {
            return this.inventory;
        }

        public Component getDisplayName() {
            return Localizable.of((String)"container.extendedcrafting.ultimate_table").build();
        }

        public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
            return UltimateAutoTableContainer.create(windowId, playerInventory, this.inventory, this.getBlockPos());
        }

        @Override
        public int getProgressRequired() {
            return (Integer)ModConfigs.AUTO_TABLE_TIME_REQUIRED.get() * 4;
        }

        @Override
        public TableRecipeStorage getRecipeStorage() {
            return this.recipeStorage;
        }

        @Override
        public BaseEnergyStorage getEnergy() {
            return this.energy;
        }

        @Override
        public int getTier() {
            return 4;
        }

        public static BaseItemStackHandler createInventoryHandler() {
            return Ultimate.createInventoryHandler(null);
        }

        public static BaseItemStackHandler createInventoryHandler(OnContentsChangedFunction onContentsChanged) {
            return BaseItemStackHandler.create((int)82, (OnContentsChangedFunction)onContentsChanged, builder -> {
                builder.setOutputSlots(new int[]{81});
                builder.setCanInsert((slot, stack) -> false);
            });
        }
    }

    public static class Elite
    extends AutoTableTileEntity {
        private final BaseItemStackHandler inventory = Elite.createInventoryHandler(this::onContentsChanged);
        private final BaseEnergyStorage energy;
        private final TableRecipeStorage recipeStorage = new TableRecipeStorage(50);

        public Elite(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModTileEntities.ELITE_AUTO_TABLE.get(), pos, state);
            this.energy = new BaseEnergyStorage((Integer)ModConfigs.AUTO_TABLE_POWER_CAPACITY.get() * 4, () -> ((Elite)this).setChangedFast());
        }

        public BaseItemStackHandler getInventory() {
            return this.inventory;
        }

        public Component getDisplayName() {
            return Localizable.of((String)"container.extendedcrafting.elite_table").build();
        }

        public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
            return EliteAutoTableContainer.create(windowId, playerInventory, this.inventory, this.getBlockPos());
        }

        @Override
        public int getProgressRequired() {
            return (Integer)ModConfigs.AUTO_TABLE_TIME_REQUIRED.get() * 3;
        }

        @Override
        public TableRecipeStorage getRecipeStorage() {
            return this.recipeStorage;
        }

        @Override
        public BaseEnergyStorage getEnergy() {
            return this.energy;
        }

        @Override
        public int getTier() {
            return 3;
        }

        public static BaseItemStackHandler createInventoryHandler() {
            return Elite.createInventoryHandler(null);
        }

        public static BaseItemStackHandler createInventoryHandler(OnContentsChangedFunction onContentsChanged) {
            return BaseItemStackHandler.create((int)50, (OnContentsChangedFunction)onContentsChanged, builder -> {
                builder.setOutputSlots(new int[]{49});
                builder.setCanInsert((slot, stack) -> false);
            });
        }
    }

    public static class Advanced
    extends AutoTableTileEntity {
        private final BaseItemStackHandler inventory = Advanced.createInventoryHandler(this::onContentsChanged);
        private final BaseEnergyStorage energy;
        private final TableRecipeStorage recipeStorage = new TableRecipeStorage(26);

        public Advanced(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModTileEntities.ADVANCED_AUTO_TABLE.get(), pos, state);
            this.energy = new BaseEnergyStorage((Integer)ModConfigs.AUTO_TABLE_POWER_CAPACITY.get() * 2, () -> ((Advanced)this).setChangedFast());
        }

        public BaseItemStackHandler getInventory() {
            return this.inventory;
        }

        public Component getDisplayName() {
            return Localizable.of((String)"container.extendedcrafting.advanced_table").build();
        }

        public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
            return AdvancedAutoTableContainer.create(windowId, playerInventory, this.inventory, this.getBlockPos());
        }

        @Override
        public int getProgressRequired() {
            return (Integer)ModConfigs.AUTO_TABLE_TIME_REQUIRED.get() * 2;
        }

        @Override
        public TableRecipeStorage getRecipeStorage() {
            return this.recipeStorage;
        }

        @Override
        public BaseEnergyStorage getEnergy() {
            return this.energy;
        }

        @Override
        public int getTier() {
            return 2;
        }

        public static BaseItemStackHandler createInventoryHandler() {
            return Advanced.createInventoryHandler(null);
        }

        public static BaseItemStackHandler createInventoryHandler(OnContentsChangedFunction onContentsChanged) {
            return BaseItemStackHandler.create((int)26, (OnContentsChangedFunction)onContentsChanged, builder -> {
                builder.setOutputSlots(new int[]{25});
                builder.setCanInsert((slot, stack) -> false);
            });
        }
    }
}

