/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.jei;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.api.component.RecipeMakerComponent;
import com.blakebr0.extendedcrafting.client.screen.AdvancedAutoTableScreen;
import com.blakebr0.extendedcrafting.client.screen.AdvancedTableScreen;
import com.blakebr0.extendedcrafting.client.screen.AutoEnderCrafterScreen;
import com.blakebr0.extendedcrafting.client.screen.AutoFluxCrafterScreen;
import com.blakebr0.extendedcrafting.client.screen.BasicAutoTableScreen;
import com.blakebr0.extendedcrafting.client.screen.BasicTableScreen;
import com.blakebr0.extendedcrafting.client.screen.CompressorScreen;
import com.blakebr0.extendedcrafting.client.screen.CraftingCoreScreen;
import com.blakebr0.extendedcrafting.client.screen.EliteAutoTableScreen;
import com.blakebr0.extendedcrafting.client.screen.EliteTableScreen;
import com.blakebr0.extendedcrafting.client.screen.EnderCrafterScreen;
import com.blakebr0.extendedcrafting.client.screen.FluxCrafterScreen;
import com.blakebr0.extendedcrafting.client.screen.UltimateAutoTableScreen;
import com.blakebr0.extendedcrafting.client.screen.UltimateTableScreen;
import com.blakebr0.extendedcrafting.compat.jei.category.CombinationCraftingCategory;
import com.blakebr0.extendedcrafting.compat.jei.category.CompressorCraftingCategory;
import com.blakebr0.extendedcrafting.compat.jei.category.EnderCrafterCategory;
import com.blakebr0.extendedcrafting.compat.jei.category.FluxCraftingCategory;
import com.blakebr0.extendedcrafting.compat.jei.category.table.AdvancedTableCategory;
import com.blakebr0.extendedcrafting.compat.jei.category.table.BasicTableCategory;
import com.blakebr0.extendedcrafting.compat.jei.category.table.EliteTableCategory;
import com.blakebr0.extendedcrafting.compat.jei.category.table.UltimateTableCategory;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.container.AdvancedAutoTableContainer;
import com.blakebr0.extendedcrafting.container.AdvancedTableContainer;
import com.blakebr0.extendedcrafting.container.AutoEnderCrafterContainer;
import com.blakebr0.extendedcrafting.container.AutoFluxCrafterContainer;
import com.blakebr0.extendedcrafting.container.BasicAutoTableContainer;
import com.blakebr0.extendedcrafting.container.BasicTableContainer;
import com.blakebr0.extendedcrafting.container.EliteAutoTableContainer;
import com.blakebr0.extendedcrafting.container.EliteTableContainer;
import com.blakebr0.extendedcrafting.container.EnderCrafterContainer;
import com.blakebr0.extendedcrafting.container.FluxCrafterContainer;
import com.blakebr0.extendedcrafting.container.UltimateAutoTableContainer;
import com.blakebr0.extendedcrafting.container.UltimateTableContainer;
import com.blakebr0.extendedcrafting.init.ModBlocks;
import com.blakebr0.extendedcrafting.init.ModDataComponentTypes;
import com.blakebr0.extendedcrafting.init.ModItems;
import com.blakebr0.extendedcrafting.init.ModMenuTypes;
import com.blakebr0.extendedcrafting.init.ModRecipeTypes;
import com.blakebr0.extendedcrafting.singularity.Singularity;
import com.blakebr0.extendedcrafting.singularity.SingularityUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public final class JeiCompat
implements IModPlugin {
    public static final ResourceLocation UID = ExtendedCrafting.resource("jei_plugin");
    public static final ResourceLocation ICONS = ExtendedCrafting.resource("textures/jei/icons.png");

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        if (((Boolean)ModConfigs.ENABLE_CRAFTING_CORE.get()).booleanValue()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new CombinationCraftingCategory(helper)});
        }
        if (((Boolean)ModConfigs.ENABLE_TABLES.get()).booleanValue()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new BasicTableCategory(helper), new AdvancedTableCategory(helper), new EliteTableCategory(helper), new UltimateTableCategory(helper)});
        }
        if (((Boolean)ModConfigs.ENABLE_COMPRESSOR.get()).booleanValue()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new CompressorCraftingCategory(helper)});
        }
        if (((Boolean)ModConfigs.ENABLE_ENDER_CRAFTER.get()).booleanValue()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new EnderCrafterCategory(helper)});
        }
        if (((Boolean)ModConfigs.ENABLE_FLUX_CRAFTER.get()).booleanValue()) {
            registration.addRecipeCategories(new IRecipeCategory[]{new FluxCraftingCategory(helper)});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (((Boolean)ModConfigs.ENABLE_CRAFTING_CORE.get()).booleanValue()) {
            registration.addRecipes(CombinationCraftingCategory.RECIPE_TYPE, RecipeHelper.byTypeValues((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.COMBINATION.get())));
        }
        if (((Boolean)ModConfigs.ENABLE_TABLES.get()).booleanValue()) {
            Map<Integer, List> recipes = Stream.of(1, 2, 3, 4).collect(Collectors.toMap(tier -> tier, tier -> RecipeHelper.byType((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.TABLE.get())).stream().map(RecipeHolder::value).filter(recipe -> recipe.hasRequiredTier() ? tier.intValue() == recipe.getTier() : tier >= recipe.getTier()).toList()));
            registration.addRecipes(BasicTableCategory.RECIPE_TYPE, (List)recipes.getOrDefault(1, new ArrayList()));
            registration.addRecipes(AdvancedTableCategory.RECIPE_TYPE, (List)recipes.getOrDefault(2, new ArrayList()));
            registration.addRecipes(EliteTableCategory.RECIPE_TYPE, (List)recipes.getOrDefault(3, new ArrayList()));
            registration.addRecipes(UltimateTableCategory.RECIPE_TYPE, (List)recipes.getOrDefault(4, new ArrayList()));
        }
        if (((Boolean)ModConfigs.ENABLE_COMPRESSOR.get()).booleanValue()) {
            registration.addRecipes(CompressorCraftingCategory.RECIPE_TYPE, RecipeHelper.byTypeValues((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.COMPRESSOR.get())));
        }
        if (((Boolean)ModConfigs.ENABLE_ENDER_CRAFTER.get()).booleanValue()) {
            registration.addRecipes(EnderCrafterCategory.RECIPE_TYPE, RecipeHelper.byTypeValues((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.ENDER_CRAFTER.get())));
        }
        if (((Boolean)ModConfigs.ENABLE_FLUX_CRAFTER.get()).booleanValue()) {
            registration.addRecipes(FluxCraftingCategory.RECIPE_TYPE, RecipeHelper.byTypeValues((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.FLUX_CRAFTER.get())));
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (((Boolean)ModConfigs.ENABLE_HANDHELD_WORKBENCH.get()).booleanValue()) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.HANDHELD_TABLE.get()), new RecipeType[]{RecipeTypes.CRAFTING});
        }
        if (((Boolean)ModConfigs.ENABLE_CRAFTING_CORE.get()).booleanValue()) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CRAFTING_CORE.get()), new RecipeType[]{CombinationCraftingCategory.RECIPE_TYPE});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.PEDESTAL.get()), new RecipeType[]{CombinationCraftingCategory.RECIPE_TYPE});
        }
        if (((Boolean)ModConfigs.ENABLE_TABLES.get()).booleanValue()) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BASIC_TABLE.get()), new RecipeType[]{BasicTableCategory.RECIPE_TYPE});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ADVANCED_TABLE.get()), new RecipeType[]{AdvancedTableCategory.RECIPE_TYPE});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ELITE_TABLE.get()), new RecipeType[]{EliteTableCategory.RECIPE_TYPE});
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ULTIMATE_TABLE.get()), new RecipeType[]{UltimateTableCategory.RECIPE_TYPE});
            if (((Boolean)ModConfigs.TABLE_USE_VANILLA_RECIPES.get()).booleanValue()) {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BASIC_TABLE.get()), new RecipeType[]{RecipeTypes.CRAFTING});
            }
            if (((Boolean)ModConfigs.ENABLE_AUTO_TABLES.get()).booleanValue()) {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BASIC_AUTO_TABLE.get()), new RecipeType[]{BasicTableCategory.RECIPE_TYPE});
                registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ADVANCED_AUTO_TABLE.get()), new RecipeType[]{AdvancedTableCategory.RECIPE_TYPE});
                registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ELITE_AUTO_TABLE.get()), new RecipeType[]{EliteTableCategory.RECIPE_TYPE});
                registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ULTIMATE_AUTO_TABLE.get()), new RecipeType[]{UltimateTableCategory.RECIPE_TYPE});
                if (((Boolean)ModConfigs.TABLE_USE_VANILLA_RECIPES.get()).booleanValue()) {
                    registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BASIC_AUTO_TABLE.get()), new RecipeType[]{RecipeTypes.CRAFTING});
                }
            }
        }
        if (((Boolean)ModConfigs.ENABLE_COMPRESSOR.get()).booleanValue()) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.COMPRESSOR.get()), new RecipeType[]{CompressorCraftingCategory.RECIPE_TYPE});
        }
        if (((Boolean)ModConfigs.ENABLE_ENDER_CRAFTER.get()).booleanValue()) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ENDER_CRAFTER.get()), new RecipeType[]{EnderCrafterCategory.RECIPE_TYPE});
            if (((Boolean)ModConfigs.ENABLE_AUTO_ENDER_CRAFTER.get()).booleanValue()) {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.AUTO_ENDER_CRAFTER.get()), new RecipeType[]{EnderCrafterCategory.RECIPE_TYPE});
            }
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ENDER_ALTERNATOR.get()), new RecipeType[]{EnderCrafterCategory.RECIPE_TYPE});
        }
        if (((Boolean)ModConfigs.ENABLE_FLUX_CRAFTER.get()).booleanValue()) {
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.FLUX_CRAFTER.get()), new RecipeType[]{FluxCraftingCategory.RECIPE_TYPE});
            if (((Boolean)ModConfigs.ENABLE_AUTO_FLUX_CRAFTER.get()).booleanValue()) {
                registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.AUTO_FLUX_CRAFTER.get()), new RecipeType[]{FluxCraftingCategory.RECIPE_TYPE});
            }
            registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.FLUX_ALTERNATOR.get()), new RecipeType[]{FluxCraftingCategory.RECIPE_TYPE});
        }
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        if (((Boolean)ModConfigs.ENABLE_TABLES.get()).booleanValue()) {
            registration.addRecipeTransferHandler(BasicTableContainer.class, (MenuType)ModMenuTypes.BASIC_TABLE.get(), BasicTableCategory.RECIPE_TYPE, 1, 9, 10, 36);
            registration.addRecipeTransferHandler(AdvancedTableContainer.class, (MenuType)ModMenuTypes.ADVANCED_TABLE.get(), AdvancedTableCategory.RECIPE_TYPE, 1, 25, 26, 36);
            registration.addRecipeTransferHandler(EliteTableContainer.class, (MenuType)ModMenuTypes.ELITE_TABLE.get(), EliteTableCategory.RECIPE_TYPE, 1, 49, 50, 36);
            registration.addRecipeTransferHandler(UltimateTableContainer.class, (MenuType)ModMenuTypes.ULTIMATE_TABLE.get(), UltimateTableCategory.RECIPE_TYPE, 1, 81, 82, 36);
            if (((Boolean)ModConfigs.TABLE_USE_VANILLA_RECIPES.get()).booleanValue()) {
                registration.addRecipeTransferHandler(BasicTableContainer.class, (MenuType)ModMenuTypes.BASIC_TABLE.get(), RecipeTypes.CRAFTING, 1, 9, 10, 36);
            }
            if (((Boolean)ModConfigs.ENABLE_AUTO_TABLES.get()).booleanValue()) {
                registration.addRecipeTransferHandler(BasicAutoTableContainer.class, (MenuType)ModMenuTypes.BASIC_AUTO_TABLE.get(), BasicTableCategory.RECIPE_TYPE, 1, 9, 11, 36);
                registration.addRecipeTransferHandler(AdvancedAutoTableContainer.class, (MenuType)ModMenuTypes.ADVANCED_AUTO_TABLE.get(), AdvancedTableCategory.RECIPE_TYPE, 1, 25, 27, 36);
                registration.addRecipeTransferHandler(EliteAutoTableContainer.class, (MenuType)ModMenuTypes.ELITE_AUTO_TABLE.get(), EliteTableCategory.RECIPE_TYPE, 1, 49, 51, 36);
                registration.addRecipeTransferHandler(UltimateAutoTableContainer.class, (MenuType)ModMenuTypes.ULTIMATE_AUTO_TABLE.get(), UltimateTableCategory.RECIPE_TYPE, 1, 81, 83, 36);
                if (((Boolean)ModConfigs.TABLE_USE_VANILLA_RECIPES.get()).booleanValue()) {
                    registration.addRecipeTransferHandler(BasicAutoTableContainer.class, (MenuType)ModMenuTypes.BASIC_AUTO_TABLE.get(), RecipeTypes.CRAFTING, 1, 9, 11, 36);
                }
            }
        }
        if (((Boolean)ModConfigs.ENABLE_ENDER_CRAFTER.get()).booleanValue()) {
            registration.addRecipeTransferHandler(EnderCrafterContainer.class, (MenuType)ModMenuTypes.ENDER_CRAFTER.get(), EnderCrafterCategory.RECIPE_TYPE, 1, 9, 10, 36);
            if (((Boolean)ModConfigs.ENABLE_AUTO_ENDER_CRAFTER.get()).booleanValue()) {
                registration.addRecipeTransferHandler(AutoEnderCrafterContainer.class, (MenuType)ModMenuTypes.AUTO_ENDER_CRAFTER.get(), EnderCrafterCategory.RECIPE_TYPE, 1, 9, 10, 36);
            }
        }
        if (((Boolean)ModConfigs.ENABLE_FLUX_CRAFTER.get()).booleanValue()) {
            registration.addRecipeTransferHandler(FluxCrafterContainer.class, (MenuType)ModMenuTypes.FLUX_CRAFTER.get(), FluxCraftingCategory.RECIPE_TYPE, 1, 9, 10, 36);
            if (((Boolean)ModConfigs.ENABLE_AUTO_FLUX_CRAFTER.get()).booleanValue()) {
                registration.addRecipeTransferHandler(AutoFluxCrafterContainer.class, (MenuType)ModMenuTypes.AUTO_FLUX_CRAFTER.get(), FluxCraftingCategory.RECIPE_TYPE, 1, 9, 10, 36);
            }
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (((Boolean)ModConfigs.ENABLE_CRAFTING_CORE.get()).booleanValue()) {
            registration.addRecipeClickArea(CraftingCoreScreen.class, 117, 47, 21, 14, new RecipeType[]{CombinationCraftingCategory.RECIPE_TYPE});
        }
        if (((Boolean)ModConfigs.ENABLE_TABLES.get()).booleanValue()) {
            registration.addRecipeClickArea(BasicTableScreen.class, 91, 37, 21, 14, new RecipeType[]{BasicTableCategory.RECIPE_TYPE});
            registration.addRecipeClickArea(AdvancedTableScreen.class, 109, 54, 21, 14, new RecipeType[]{AdvancedTableCategory.RECIPE_TYPE});
            registration.addRecipeClickArea(EliteTableScreen.class, 139, 72, 21, 14, new RecipeType[]{EliteTableCategory.RECIPE_TYPE});
            registration.addRecipeClickArea(UltimateTableScreen.class, 174, 90, 21, 14, new RecipeType[]{UltimateTableCategory.RECIPE_TYPE});
            if (((Boolean)ModConfigs.ENABLE_AUTO_TABLES.get()).booleanValue()) {
                registration.addRecipeClickArea(BasicAutoTableScreen.class, 97, 36, 21, 14, new RecipeType[]{BasicTableCategory.RECIPE_TYPE});
                registration.addRecipeClickArea(AdvancedAutoTableScreen.class, 121, 39, 21, 14, new RecipeType[]{AdvancedTableCategory.RECIPE_TYPE});
                registration.addRecipeClickArea(EliteAutoTableScreen.class, 158, 72, 21, 14, new RecipeType[]{EliteTableCategory.RECIPE_TYPE});
                registration.addRecipeClickArea(UltimateAutoTableScreen.class, 193, 90, 21, 14, new RecipeType[]{UltimateTableCategory.RECIPE_TYPE});
            }
        }
        if (((Boolean)ModConfigs.ENABLE_COMPRESSOR.get()).booleanValue()) {
            registration.addRecipeClickArea(CompressorScreen.class, 97, 47, 21, 14, new RecipeType[]{CompressorCraftingCategory.RECIPE_TYPE});
        }
        if (((Boolean)ModConfigs.ENABLE_ENDER_CRAFTER.get()).booleanValue()) {
            registration.addRecipeClickArea(EnderCrafterScreen.class, 90, 36, 21, 14, new RecipeType[]{EnderCrafterCategory.RECIPE_TYPE});
            if (((Boolean)ModConfigs.ENABLE_AUTO_ENDER_CRAFTER.get()).booleanValue()) {
                registration.addRecipeClickArea(AutoEnderCrafterScreen.class, 95, 48, 21, 14, new RecipeType[]{EnderCrafterCategory.RECIPE_TYPE});
            }
        }
        if (((Boolean)ModConfigs.ENABLE_FLUX_CRAFTER.get()).booleanValue()) {
            registration.addRecipeClickArea(FluxCrafterScreen.class, 90, 36, 21, 14, new RecipeType[]{FluxCraftingCategory.RECIPE_TYPE});
            if (((Boolean)ModConfigs.ENABLE_AUTO_FLUX_CRAFTER.get()).booleanValue()) {
                registration.addRecipeClickArea(AutoFluxCrafterScreen.class, 95, 48, 21, 14, new RecipeType[]{FluxCraftingCategory.RECIPE_TYPE});
            }
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModItems.SINGULARITY.get()), (stack, context) -> {
            Singularity singularity = SingularityUtils.getSingularity(stack);
            return singularity != null ? singularity.getId().toString() : "";
        });
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)((Item)ModItems.RECIPE_MAKER.get()), (stack, context) -> ((RecipeMakerComponent)stack.getOrDefault(ModDataComponentTypes.RECIPE_MAKER, (Object)RecipeMakerComponent.EMPTY)).type());
    }
}

