/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.client.tesr;

import com.blakebr0.extendedcrafting.api.crafting.ICompressorRecipe;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.tileentity.CompressorTileEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class CompressorRenderer
implements BlockEntityRenderer<CompressorTileEntity> {
    public CompressorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(CompressorTileEntity tile, float v, PoseStack matrix, MultiBufferSource buffer, int i, int i1) {
        ItemStack stack;
        if (!((Boolean)ModConfigs.ENABLE_COMPRESSOR_RENDERER.get()).booleanValue()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            return;
        }
        ICompressorRecipe recipe = tile.getActiveRecipe();
        if (recipe != null && !(stack = recipe.getResultItem((HolderLookup.Provider)level.registryAccess())).isEmpty()) {
            matrix.pushPose();
            matrix.translate(0.5, 1.3, 0.5);
            float scale = stack.getItem() instanceof BlockItem ? 0.9f : 0.75f;
            matrix.scale(scale, scale, scale);
            double tick = (double)System.currentTimeMillis() / 800.0;
            matrix.translate(0.0, Math.sin(tick % (Math.PI * 2)) * 0.065, 0.0);
            matrix.mulPose(Axis.YP.rotationDegrees((float)(tick * 40.0 % 360.0)));
            minecraft.getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, 234, i1, matrix, buffer, (Level)level, 0);
            matrix.popPose();
        }
    }
}

