/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.client.screen;

import com.blakebr0.cucumber.client.screen.BaseContainerScreen;
import com.blakebr0.cucumber.client.screen.widget.EnergyBarWidget;
import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.container.FluxAlternatorContainer;
import com.blakebr0.extendedcrafting.tileentity.FluxAlternatorTileEntity;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class FluxAlternatorScreen
extends BaseContainerScreen<FluxAlternatorContainer> {
    public static final ResourceLocation BACKGROUND = ExtendedCrafting.resource("textures/gui/flux_alternator.png");

    public FluxAlternatorScreen(FluxAlternatorContainer container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title, BACKGROUND, 176, 194);
    }

    protected void init() {
        super.init();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        FluxAlternatorTileEntity tile = this.getTileEntity();
        if (tile != null) {
            this.addRenderableWidget((GuiEventListener)new EnergyBarWidget(x + 7, y + 17, (IEnergyStorage)tile.getEnergy()));
        }
    }

    protected void renderLabels(GuiGraphics gfx, int mouseX, int mouseY) {
        String title = this.getTitle().getString();
        gfx.drawString(this.font, title, this.imageWidth / 2 - this.font.width(title) / 2, 6, 0x404040, false);
        gfx.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 94, 0x404040, false);
    }

    private FluxAlternatorTileEntity getTileEntity() {
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().level;
        if (level != null && (tile = level.getBlockEntity(((FluxAlternatorContainer)this.getMenu()).getBlockPos())) instanceof FluxAlternatorTileEntity) {
            FluxAlternatorTileEntity alternator = (FluxAlternatorTileEntity)tile;
            return alternator;
        }
        return null;
    }
}

