/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.block;

import com.blakebr0.cucumber.block.BaseTileEntityBlock;
import com.blakebr0.cucumber.util.VoxelShapeBuilder;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import com.blakebr0.extendedcrafting.tileentity.UltimateTableTileEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class UltimateTableBlock
extends BaseTileEntityBlock {
    public static final VoxelShape ULTIMATE_TABLE_SHAPE = VoxelShapeBuilder.builder().cuboid(2.0, 0.0, 2.0, 14.0, 2.0, 14.0).cuboid(3.0, 2.0, 3.0, 5.0, 10.0, 5.0).cuboid(11.0, 2.0, 11.0, 13.0, 10.0, 13.0).cuboid(11.0, 2.0, 3.0, 13.0, 10.0, 5.0).cuboid(3.0, 2.0, 11.0, 5.0, 10.0, 13.0).cuboid(0.0, 10.0, 0.0, 16.0, 16.0, 16.0).build();

    public UltimateTableBlock() {
        super(SoundType.METAL, 5.0f, 10.0f, true);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new UltimateTableTileEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity tile;
        if (!level.isClientSide() && (tile = level.getBlockEntity(pos)) instanceof UltimateTableTileEntity) {
            UltimateTableTileEntity table = (UltimateTableTileEntity)tile;
            player.openMenu((MenuProvider)table, pos);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (state.getBlock() != newState.getBlock() && (tile = level.getBlockEntity(pos)) instanceof UltimateTableTileEntity) {
            UltimateTableTileEntity table = (UltimateTableTileEntity)tile;
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)table.getInventory().getStacks());
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ULTIMATE_TABLE_SHAPE;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)ModTooltips.TIER.args(new Object[]{4}).build());
    }
}

