/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.block;

import com.blakebr0.cucumber.block.BaseTileEntityBlock;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.util.VoxelShapeBuilder;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import com.blakebr0.extendedcrafting.tileentity.CraftingCoreTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CraftingCoreBlock
extends BaseTileEntityBlock {
    public static final VoxelShape CRAFTING_CORE_SHAPE = VoxelShapeBuilder.builder().cuboid(2.0, 0.0, 2.0, 14.0, 2.0, 14.0).cuboid(0.0, 2.0, 0.0, 16.0, 5.0, 16.0).cuboid(1.0, 5.0, 1.0, 15.0, 6.0, 15.0).cuboid(0.0, 6.0, 0.0, 16.0, 12.0, 16.0).cuboid(1.0, 12.0, 1.0, 15.0, 13.0, 15.0).cuboid(0.0, 13.0, 0.0, 16.0, 16.0, 16.0).build();

    public CraftingCoreBlock() {
        super(SoundType.METAL, 5.0f, 10.0f, true);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CraftingCoreTileEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity tile;
        ItemStack held = player.getItemInHand(hand);
        if (!level.isClientSide() && (tile = level.getBlockEntity(pos)) instanceof CraftingCoreTileEntity) {
            CraftingCoreTileEntity core = (CraftingCoreTileEntity)tile;
            if (hitResult.getDirection() == Direction.UP) {
                BaseItemStackHandler inventory = core.getInventory();
                ItemStack stackInSlot = inventory.getStackInSlot(0);
                if (stackInSlot.isEmpty()) {
                    if (!held.isEmpty()) {
                        inventory.setStackInSlot(0, StackHelper.withSize((ItemStack)held, (int)1, (boolean)false));
                        player.setItemInHand(hand, StackHelper.shrink((ItemStack)held, (int)1, (boolean)false));
                        level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    ItemEntity item = new ItemEntity(level, player.getX(), player.getY(), player.getZ(), stackInSlot);
                    item.setNoPickUpDelay();
                    level.addFreshEntity((Entity)item);
                    inventory.setStackInSlot(0, ItemStack.EMPTY);
                }
            } else {
                player.openMenu((MenuProvider)core, pos);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (state.getBlock() != newState.getBlock() && (tile = level.getBlockEntity(pos)) instanceof CraftingCoreTileEntity) {
            CraftingCoreTileEntity core = (CraftingCoreTileEntity)tile;
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)core.getInventory().getStacks());
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return CRAFTING_CORE_SHAPE;
    }

    protected <T extends BlockEntity> BlockEntityTicker<T> getServerTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return CraftingCoreBlock.createTicker(type, (BlockEntityType)((BlockEntityType)ModTileEntities.CRAFTING_CORE.get()), CraftingCoreTileEntity::tick);
    }
}

