/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.block;

import com.blakebr0.cucumber.block.BaseTileEntityBlock;
import com.blakebr0.extendedcrafting.api.component.TableRecipeStorageComponent;
import com.blakebr0.extendedcrafting.init.ModDataComponentTypes;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import com.blakebr0.extendedcrafting.lib.ModTooltips;
import com.blakebr0.extendedcrafting.tileentity.AutoEnderCrafterTileEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class AutoEnderCrafterBlock
extends BaseTileEntityBlock {
    public AutoEnderCrafterBlock() {
        super(SoundType.METAL, 6.0f, 12.0f, true);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AutoEnderCrafterTileEntity(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity tile;
        if (!level.isClientSide() && (tile = level.getBlockEntity(pos)) instanceof AutoEnderCrafterTileEntity) {
            AutoEnderCrafterTileEntity crafter = (AutoEnderCrafterTileEntity)tile;
            player.openMenu((MenuProvider)crafter, pos);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (state.getBlock() != newState.getBlock() && (tile = level.getBlockEntity(pos)) instanceof AutoEnderCrafterTileEntity) {
            AutoEnderCrafterTileEntity crafter = (AutoEnderCrafterTileEntity)tile;
            Containers.dropContents((Level)level, (BlockPos)pos, (NonNullList)crafter.getInventory().getStacks());
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        BlockEntity tile;
        TableRecipeStorageComponent storage = (TableRecipeStorageComponent)stack.get(ModDataComponentTypes.TABLE_RECIPE_STORAGE);
        if (storage != null && (tile = level.getBlockEntity(pos)) instanceof AutoEnderCrafterTileEntity) {
            AutoEnderCrafterTileEntity crafter = (AutoEnderCrafterTileEntity)tile;
            crafter.getRecipeStorage().deserializeNBT((HolderLookup.Provider)level.registryAccess(), storage.data());
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        TableRecipeStorageComponent storage = (TableRecipeStorageComponent)stack.get(ModDataComponentTypes.TABLE_RECIPE_STORAGE);
        if (storage != null && storage.recipeCount() > 0) {
            tooltip.add((Component)ModTooltips.RECIPE_COUNT.args(new Object[]{storage.recipeCount()}).build());
        }
    }

    protected <T extends BlockEntity> BlockEntityTicker<T> getServerTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return AutoEnderCrafterBlock.createTicker(type, (BlockEntityType)((BlockEntityType)ModTileEntities.AUTO_ENDER_CRAFTER.get()), AutoEnderCrafterTileEntity::tick);
    }
}

