/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.core.context;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.core.v1.context.CompostableBlocksContext;
import fuzs.puzzleslib.neoforge.api.data.v2.core.DataProviderHelper;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.DataMapProvider;
import net.neoforged.neoforge.registries.datamaps.builtin.Compostable;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;

public record CompostableBlocksContextNeoForgeImpl(String modId, Map<Holder<? extends ItemLike>, Compostable> compostingChances) implements CompostableBlocksContext
{
    public CompostableBlocksContextNeoForgeImpl(String modId) {
        this(modId, new IdentityHashMap<Holder<? extends ItemLike>, Compostable>());
    }

    @Override
    public void registerCompostable(float compostingChance, Holder<? extends ItemLike> ... items) {
        Preconditions.checkArgument((compostingChance >= 0.0f && compostingChance <= 1.0f ? 1 : 0) != 0, (Object)("Value " + compostingChance + " outside of range [0.0:1.0]"));
        Objects.requireNonNull(items, "items is null");
        Preconditions.checkState((items.length > 0 ? 1 : 0) != 0, (Object)"items is empty");
        for (Holder<? extends ItemLike> item : items) {
            Objects.requireNonNull(item, "item is null");
            this.registerCompostable(item, compostingChance);
        }
    }

    private void registerCompostable(Holder<? extends ItemLike> item, float compostingChance) {
        if (this.compostingChances.isEmpty()) {
            DataProviderHelper.registerDataProviders(this.modId, context -> new DataMapProvider(context.getPackOutput(), context.getRegistries()){

                protected void gather() {
                    DataMapProvider.Builder builder = this.builder(NeoForgeDataMaps.COMPOSTABLES);
                    for (Map.Entry<Holder<? extends ItemLike>, Compostable> entry : CompostableBlocksContextNeoForgeImpl.this.compostingChances().entrySet()) {
                        Holder.Reference holder = ((ItemLike)entry.getKey().value()).asItem().builtInRegistryHolder();
                        builder.add((Holder)holder, (Object)entry.getValue(), false, new ICondition[0]);
                    }
                }
            });
        }
        this.compostingChances.put(item, new Compostable(compostingChance));
    }
}

