/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.neoforge.impl.core;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.impl.item.CopyComponentsRecipe;
import fuzs.puzzleslib.neoforge.api.core.v1.NeoForgeModContainerHelper;
import fuzs.puzzleslib.neoforge.impl.core.NeoForgeBiomeLoadingHandler;
import fuzs.puzzleslib.neoforge.impl.core.context.BiomeModificationsContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.BlockInteractionsContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.CompostableBlocksContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.CreativeModeTabContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.CreativeTabContentsContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.DataPackSourcesContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.EntityAttributesCreateContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.EntityAttributesModifyContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.FlammableBlocksContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.FuelBurnTimesContextNeoForgeImpl;
import fuzs.puzzleslib.neoforge.impl.core.context.SpawnPlacementsContextNeoForgeImpl;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class NeoForgeModConstructor {
    private NeoForgeModConstructor() {
    }

    public static void construct(ModConstructor constructor, String modId, Set<ContentRegistrationFlags> availableFlags, Set<ContentRegistrationFlags> flagsToHandle) {
        NeoForgeModContainerHelper.getOptionalModEventBus(modId).ifPresent(modEventBus -> {
            HashMultimap biomeModifications = HashMultimap.create();
            NeoForgeModConstructor.registerContent(constructor, modId, modEventBus, (Multimap<BiomeLoadingPhase, NeoForgeBiomeLoadingHandler.BiomeModification>)biomeModifications, flagsToHandle);
            NeoForgeModConstructor.registerLoadingHandlers(constructor, modId, modEventBus, (Multimap<BiomeLoadingPhase, NeoForgeBiomeLoadingHandler.BiomeModification>)biomeModifications, availableFlags, flagsToHandle);
            constructor.onConstructMod();
            constructor.onRegisterCompostableBlocks(new CompostableBlocksContextNeoForgeImpl(modId));
        });
    }

    private static void registerContent(ModConstructor constructor, String modId, IEventBus modEventBus, Multimap<BiomeLoadingPhase, NeoForgeBiomeLoadingHandler.BiomeModification> biomeModifications, Set<ContentRegistrationFlags> flagsToHandle) {
        constructor.onRegisterCreativeModeTabs(new CreativeModeTabContextNeoForgeImpl(modEventBus));
        if (flagsToHandle.contains((Object)ContentRegistrationFlags.BIOME_MODIFICATIONS)) {
            NeoForgeBiomeLoadingHandler.register(modId, modEventBus, biomeModifications);
        }
        if (flagsToHandle.contains((Object)ContentRegistrationFlags.COPY_RECIPES)) {
            DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)Registries.RECIPE_SERIALIZER, (String)modId);
            deferredRegister.register(modEventBus);
            CopyComponentsRecipe.registerSerializers((arg_0, arg_1) -> ((DeferredRegister)deferredRegister).register(arg_0, arg_1));
        }
    }

    private static void registerLoadingHandlers(ModConstructor constructor, String modId, IEventBus eventBus, Multimap<BiomeLoadingPhase, NeoForgeBiomeLoadingHandler.BiomeModification> biomeModifications, Set<ContentRegistrationFlags> availableFlags, Set<ContentRegistrationFlags> flagsToHandle) {
        eventBus.addListener(evt -> evt.enqueueWork(() -> {
            constructor.onCommonSetup();
            constructor.onRegisterFuelBurnTimes(new FuelBurnTimesContextNeoForgeImpl());
            constructor.onRegisterBiomeModifications(new BiomeModificationsContextNeoForgeImpl(biomeModifications, availableFlags));
            constructor.onRegisterFlammableBlocks(new FlammableBlocksContextNeoForgeImpl());
            constructor.onRegisterBlockInteractions(new BlockInteractionsContextNeoForgeImpl());
        }));
        eventBus.addListener(evt -> constructor.onRegisterSpawnPlacements(new SpawnPlacementsContextNeoForgeImpl((RegisterSpawnPlacementsEvent)evt)));
        eventBus.addListener(evt -> constructor.onEntityAttributeCreation(new EntityAttributesCreateContextNeoForgeImpl((arg_0, arg_1) -> ((EntityAttributeCreationEvent)evt).put(arg_0, arg_1))));
        eventBus.addListener(evt -> constructor.onEntityAttributeModification(new EntityAttributesModifyContextNeoForgeImpl((arg_0, arg_1, arg_2) -> ((EntityAttributeModificationEvent)evt).add(arg_0, arg_1, arg_2))));
        eventBus.addListener(evt -> constructor.onBuildCreativeModeTabContents(new CreativeTabContentsContextNeoForgeImpl((BuildCreativeModeTabContentsEvent)evt)));
        eventBus.addListener(evt -> {
            if (evt.getPackType() == PackType.SERVER_DATA) {
                constructor.onAddDataPackFinders(new DataPackSourcesContextNeoForgeImpl(arg_0 -> ((AddPackFindersEvent)evt).addRepositorySource(arg_0)));
                if (flagsToHandle.contains((Object)ContentRegistrationFlags.BIOME_MODIFICATIONS)) {
                    evt.addRepositorySource(NeoForgeBiomeLoadingHandler.buildPack(modId));
                }
            }
        });
    }
}

