/*
 * Decompiled with CFR 0.152.
 */
package com.phantomwing.rusticdelight.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.phantomwing.rusticdelight.Configuration;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class SquidsDropCalamariModifier
extends LootModifier {
    public static final MapCodec<SquidsDropCalamariModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(e -> e.item), (App)Codec.INT.fieldOf("minAmount").forGetter(e -> e.minAmount), (App)Codec.INT.fieldOf("maxAmount").forGetter(e -> e.maxAmount))).apply((Applicative)inst, SquidsDropCalamariModifier::new));
    private final Item item;
    private final int minAmount;
    private final int maxAmount;

    public SquidsDropCalamariModifier(LootItemCondition[] conditionsIn, Item item, int minAmount, int maxAmount) {
        super(conditionsIn);
        this.item = item;
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (!((Boolean)Configuration.SQUIDS_DROP_CALAMARI.get()).booleanValue()) {
            return generatedLoot;
        }
        for (LootItemCondition condition : this.conditions) {
            if (condition.test((Object)context)) continue;
            return generatedLoot;
        }
        int count = UniformGenerator.between((float)this.minAmount, (float)this.maxAmount).getInt(context);
        if (count > 0) {
            generatedLoot.add((Object)new ItemStack((ItemLike)this.item, count));
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

